/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class AdminReplyTicketRequest {
    private final MessageType messageType;
    private final Optional<String> body;
    private final String adminId;
    private final Optional<Integer> createdAt;
    private final Optional<List<ReplyOptionsItem>> replyOptions;
    private final Optional<List<String>> attachmentUrls;
    private final Map<String, Object> additionalProperties;

    private AdminReplyTicketRequest(MessageType messageType, Optional<String> body, String adminId, Optional<Integer> createdAt, Optional<List<ReplyOptionsItem>> replyOptions, Optional<List<String>> attachmentUrls, Map<String, Object> additionalProperties) {
        this.messageType = messageType;
        this.body = body;
        this.adminId = adminId;
        this.createdAt = createdAt;
        this.replyOptions = replyOptions;
        this.attachmentUrls = attachmentUrls;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="message_type")
    public MessageType getMessageType() {
        return this.messageType;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "admin";
    }

    @JsonProperty(value="body")
    public Optional<String> getBody() {
        return this.body;
    }

    @JsonProperty(value="admin_id")
    public String getAdminId() {
        return this.adminId;
    }

    @JsonProperty(value="created_at")
    public Optional<Integer> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="reply_options")
    public Optional<List<ReplyOptionsItem>> getReplyOptions() {
        return this.replyOptions;
    }

    @JsonProperty(value="attachment_urls")
    public Optional<List<String>> getAttachmentUrls() {
        return this.attachmentUrls;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AdminReplyTicketRequest && this.equalTo((AdminReplyTicketRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AdminReplyTicketRequest other) {
        return this.messageType.equals(other.messageType) && this.body.equals(other.body) && this.adminId.equals(other.adminId) && this.createdAt.equals(other.createdAt) && this.replyOptions.equals(other.replyOptions) && this.attachmentUrls.equals(other.attachmentUrls);
    }

    public int hashCode() {
        return Objects.hash(this.messageType, this.body, this.adminId, this.createdAt, this.replyOptions, this.attachmentUrls);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static MessageTypeStage builder() {
        return new Builder();
    }

    public static final class MessageType {
        public static final MessageType NOTE = new MessageType(Value.NOTE, "note");
        public static final MessageType QUICK_REPLY = new MessageType(Value.QUICK_REPLY, "quick_reply");
        public static final MessageType COMMENT = new MessageType(Value.COMMENT, "comment");
        private final Value value;
        private final String string;

        MessageType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof MessageType && this.string.equals(((MessageType)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case NOTE: {
                    return visitor.visitNote();
                }
                case QUICK_REPLY: {
                    return visitor.visitQuickReply();
                }
                case COMMENT: {
                    return visitor.visitComment();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static MessageType valueOf(String value) {
            switch (value) {
                case "note": {
                    return NOTE;
                }
                case "quick_reply": {
                    return QUICK_REPLY;
                }
                case "comment": {
                    return COMMENT;
                }
            }
            return new MessageType(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitComment();

            public T visitNote();

            public T visitQuickReply();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            COMMENT,
            NOTE,
            QUICK_REPLY,
            UNKNOWN;

        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class ReplyOptionsItem {
        private final String text;
        private final String uuid;
        private final Map<String, Object> additionalProperties;

        private ReplyOptionsItem(String text, String uuid, Map<String, Object> additionalProperties) {
            this.text = text;
            this.uuid = uuid;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="text")
        public String getText() {
            return this.text;
        }

        @JsonProperty(value="uuid")
        public String getUuid() {
            return this.uuid;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ReplyOptionsItem && this.equalTo((ReplyOptionsItem)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(ReplyOptionsItem other) {
            return this.text.equals(other.text) && this.uuid.equals(other.uuid);
        }

        public int hashCode() {
            return Objects.hash(this.text, this.uuid);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static TextStage builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder
        implements TextStage,
        UuidStage,
        _FinalStage {
            private String text;
            private String uuid;
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            @Override
            public Builder from(ReplyOptionsItem other) {
                this.text(other.getText());
                this.uuid(other.getUuid());
                return this;
            }

            @Override
            @JsonSetter(value="text")
            public UuidStage text(@NotNull String text) {
                this.text = Objects.requireNonNull(text, "text must not be null");
                return this;
            }

            @Override
            @JsonSetter(value="uuid")
            public _FinalStage uuid(@NotNull String uuid) {
                this.uuid = Objects.requireNonNull(uuid, "uuid must not be null");
                return this;
            }

            @Override
            public ReplyOptionsItem build() {
                return new ReplyOptionsItem(this.text, this.uuid, this.additionalProperties);
            }
        }

        public static interface _FinalStage {
            public ReplyOptionsItem build();
        }

        public static interface UuidStage {
            public _FinalStage uuid(@NotNull String var1);
        }

        public static interface TextStage {
            public UuidStage text(@NotNull String var1);

            public Builder from(ReplyOptionsItem var1);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements MessageTypeStage,
    AdminIdStage,
    _FinalStage {
        private MessageType messageType;
        private String adminId;
        private Optional<List<String>> attachmentUrls = Optional.empty();
        private Optional<List<ReplyOptionsItem>> replyOptions = Optional.empty();
        private Optional<Integer> createdAt = Optional.empty();
        private Optional<String> body = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(AdminReplyTicketRequest other) {
            this.messageType(other.getMessageType());
            this.body(other.getBody());
            this.adminId(other.getAdminId());
            this.createdAt(other.getCreatedAt());
            this.replyOptions(other.getReplyOptions());
            this.attachmentUrls(other.getAttachmentUrls());
            return this;
        }

        @Override
        @JsonSetter(value="message_type")
        public AdminIdStage messageType(@NotNull MessageType messageType) {
            this.messageType = Objects.requireNonNull(messageType, "messageType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="admin_id")
        public _FinalStage adminId(@NotNull String adminId) {
            this.adminId = Objects.requireNonNull(adminId, "adminId must not be null");
            return this;
        }

        @Override
        public _FinalStage attachmentUrls(List<String> attachmentUrls) {
            this.attachmentUrls = Optional.ofNullable(attachmentUrls);
            return this;
        }

        @Override
        @JsonSetter(value="attachment_urls", nulls=Nulls.SKIP)
        public _FinalStage attachmentUrls(Optional<List<String>> attachmentUrls) {
            this.attachmentUrls = attachmentUrls;
            return this;
        }

        @Override
        public _FinalStage replyOptions(List<ReplyOptionsItem> replyOptions) {
            this.replyOptions = Optional.ofNullable(replyOptions);
            return this;
        }

        @Override
        @JsonSetter(value="reply_options", nulls=Nulls.SKIP)
        public _FinalStage replyOptions(Optional<List<ReplyOptionsItem>> replyOptions) {
            this.replyOptions = replyOptions;
            return this;
        }

        @Override
        public _FinalStage createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        @Override
        @JsonSetter(value="body", nulls=Nulls.SKIP)
        public _FinalStage body(Optional<String> body) {
            this.body = body;
            return this;
        }

        @Override
        public AdminReplyTicketRequest build() {
            return new AdminReplyTicketRequest(this.messageType, this.body, this.adminId, this.createdAt, this.replyOptions, this.attachmentUrls, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public AdminReplyTicketRequest build();

        public _FinalStage body(Optional<String> var1);

        public _FinalStage body(String var1);

        public _FinalStage createdAt(Optional<Integer> var1);

        public _FinalStage createdAt(Integer var1);

        public _FinalStage replyOptions(Optional<List<ReplyOptionsItem>> var1);

        public _FinalStage replyOptions(List<ReplyOptionsItem> var1);

        public _FinalStage attachmentUrls(Optional<List<String>> var1);

        public _FinalStage attachmentUrls(List<String> var1);
    }

    public static interface AdminIdStage {
        public _FinalStage adminId(@NotNull String var1);
    }

    public static interface MessageTypeStage {
        public AdminIdStage messageType(@NotNull MessageType var1);

        public Builder from(AdminReplyTicketRequest var1);
    }
}

