/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CloseConversationRequest {
    private final String adminId;
    private final Optional<String> body;
    private final Map<String, Object> additionalProperties;

    private CloseConversationRequest(String adminId, Optional<String> body, Map<String, Object> additionalProperties) {
        this.adminId = adminId;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "admin";
    }

    @JsonProperty(value="admin_id")
    public String getAdminId() {
        return this.adminId;
    }

    @JsonProperty(value="body")
    public Optional<String> getBody() {
        return this.body;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CloseConversationRequest && this.equalTo((CloseConversationRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CloseConversationRequest other) {
        return this.adminId.equals(other.adminId) && this.body.equals(other.body);
    }

    public int hashCode() {
        return Objects.hash(this.adminId, this.body);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AdminIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AdminIdStage,
    _FinalStage {
        private String adminId;
        private Optional<String> body = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CloseConversationRequest other) {
            this.adminId(other.getAdminId());
            this.body(other.getBody());
            return this;
        }

        @Override
        @JsonSetter(value="admin_id")
        public _FinalStage adminId(@NotNull String adminId) {
            this.adminId = Objects.requireNonNull(adminId, "adminId must not be null");
            return this;
        }

        @Override
        public _FinalStage body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        @Override
        @JsonSetter(value="body", nulls=Nulls.SKIP)
        public _FinalStage body(Optional<String> body) {
            this.body = body;
            return this;
        }

        @Override
        public CloseConversationRequest build() {
            return new CloseConversationRequest(this.adminId, this.body, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CloseConversationRequest build();

        public _FinalStage body(Optional<String> var1);

        public _FinalStage body(String var1);
    }

    public static interface AdminIdStage {
        public _FinalStage adminId(@NotNull String var1);

        public Builder from(CloseConversationRequest var1);
    }
}

