/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateInternalArticleRequest {
    private final String title;
    private final Optional<String> body;
    private final int authorId;
    private final int ownerId;
    private final Map<String, Object> additionalProperties;

    private CreateInternalArticleRequest(String title, Optional<String> body, int authorId, int ownerId, Map<String, Object> additionalProperties) {
        this.title = title;
        this.body = body;
        this.authorId = authorId;
        this.ownerId = ownerId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="body")
    public Optional<String> getBody() {
        return this.body;
    }

    @JsonProperty(value="author_id")
    public int getAuthorId() {
        return this.authorId;
    }

    @JsonProperty(value="owner_id")
    public int getOwnerId() {
        return this.ownerId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateInternalArticleRequest && this.equalTo((CreateInternalArticleRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateInternalArticleRequest other) {
        return this.title.equals(other.title) && this.body.equals(other.body) && this.authorId == other.authorId && this.ownerId == other.ownerId;
    }

    public int hashCode() {
        return Objects.hash(this.title, this.body, this.authorId, this.ownerId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TitleStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TitleStage,
    AuthorIdStage,
    OwnerIdStage,
    _FinalStage {
        private String title;
        private int authorId;
        private int ownerId;
        private Optional<String> body = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateInternalArticleRequest other) {
            this.title(other.getTitle());
            this.body(other.getBody());
            this.authorId(other.getAuthorId());
            this.ownerId(other.getOwnerId());
            return this;
        }

        @Override
        @JsonSetter(value="title")
        public AuthorIdStage title(@NotNull String title) {
            this.title = Objects.requireNonNull(title, "title must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="author_id")
        public OwnerIdStage authorId(int authorId) {
            this.authorId = authorId;
            return this;
        }

        @Override
        @JsonSetter(value="owner_id")
        public _FinalStage ownerId(int ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        @Override
        public _FinalStage body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        @Override
        @JsonSetter(value="body", nulls=Nulls.SKIP)
        public _FinalStage body(Optional<String> body) {
            this.body = body;
            return this;
        }

        @Override
        public CreateInternalArticleRequest build() {
            return new CreateInternalArticleRequest(this.title, this.body, this.authorId, this.ownerId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateInternalArticleRequest build();

        public _FinalStage body(Optional<String> var1);

        public _FinalStage body(String var1);
    }

    public static interface OwnerIdStage {
        public _FinalStage ownerId(int var1);
    }

    public static interface AuthorIdStage {
        public OwnerIdStage authorId(int var1);
    }

    public static interface TitleStage {
        public AuthorIdStage title(@NotNull String var1);

        public Builder from(CreateInternalArticleRequest var1);
    }
}

