/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.contacts.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = MergeContactsRequest.Builder.class)
public final class MergeContactsRequest {
    private final Optional<String> leadId;

    private final Optional<String> contactId;

    private final Map<String, Object> additionalProperties;

    private MergeContactsRequest(
            Optional<String> leadId, Optional<String> contactId, Map<String, Object> additionalProperties) {
        this.leadId = leadId;
        this.contactId = contactId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the contact to merge away from. Must be a lead.
     */
    @JsonProperty("from")
    public Optional<String> getLeadId() {
        return leadId;
    }

    /**
     * @return The unique identifier for the contact to merge into. Must be a user.
     */
    @JsonProperty("into")
    public Optional<String> getContactId() {
        return contactId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof MergeContactsRequest && equalTo((MergeContactsRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(MergeContactsRequest other) {
        return leadId.equals(other.leadId) && contactId.equals(other.contactId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.leadId, this.contactId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> leadId = Optional.empty();

        private Optional<String> contactId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(MergeContactsRequest other) {
            leadId(other.getLeadId());
            contactId(other.getContactId());
            return this;
        }

        /**
         * <p>The unique identifier for the contact to merge away from. Must be a lead.</p>
         */
        @JsonSetter(value = "from", nulls = Nulls.SKIP)
        public Builder leadId(Optional<String> leadId) {
            this.leadId = leadId;
            return this;
        }

        public Builder leadId(String leadId) {
            this.leadId = Optional.ofNullable(leadId);
            return this;
        }

        /**
         * <p>The unique identifier for the contact to merge into. Must be a user.</p>
         */
        @JsonSetter(value = "into", nulls = Nulls.SKIP)
        public Builder contactId(Optional<String> contactId) {
            this.contactId = contactId;
            return this;
        }

        public Builder contactId(String contactId) {
            this.contactId = Optional.ofNullable(contactId);
            return this;
        }

        public MergeContactsRequest build() {
            return new MergeContactsRequest(leadId, contactId, additionalProperties);
        }
    }
}
