/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.tickets;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.IntercomApiException;
import com.intercom.api.core.IntercomException;
import com.intercom.api.core.IntercomHttpResponse;
import com.intercom.api.core.MediaTypes;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.errors.BadRequestError;
import com.intercom.api.resources.unstable.errors.NotFoundError;
import com.intercom.api.resources.unstable.errors.UnauthorizedError;
import com.intercom.api.resources.unstable.jobs.types.Jobs;
import com.intercom.api.resources.unstable.tickets.requests.DeleteTicketRequest;
import com.intercom.api.resources.unstable.tickets.requests.EnqueueCreateTicketRequest;
import com.intercom.api.resources.unstable.tickets.requests.GetTicketRequest;
import com.intercom.api.resources.unstable.tickets.requests.ReplyTicketRequest;
import com.intercom.api.resources.unstable.tickets.requests.UpdateTicketRequest;
import com.intercom.api.resources.unstable.tickets.types.DeleteTicketResponse;
import com.intercom.api.resources.unstable.tickets.types.Ticket;
import com.intercom.api.resources.unstable.types.Error;
import com.intercom.api.resources.unstable.types.SearchRequest;
import com.intercom.api.resources.unstable.types.TicketList;
import com.intercom.api.resources.unstable.types.TicketReply;
import java.io.IOException;
import java.util.Optional;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawTicketsClient {
    protected final ClientOptions clientOptions;

    public RawTicketsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    /**
     * You can reply to a ticket with a message from an admin or on behalf of a contact, or with a note for admins.
     */
    public IntercomHttpResponse<TicketReply> replyTicket(ReplyTicketRequest request) {
        return replyTicket(request, null);
    }

    /**
     * You can reply to a ticket with a message from an admin or on behalf of a contact, or with a note for admins.
     */
    public IntercomHttpResponse<TicketReply> replyTicket(ReplyTicketRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("tickets")
                .addPathSegment(request.getId())
                .addPathSegments("reply")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request.getBody()), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TicketReply.class), response);
            }
            try {
                switch (response.code()) {
                    case 400:
                        throw new BadRequestError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    case 401:
                        throw new UnauthorizedError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 404:
                        throw new NotFoundError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * Enqueues ticket creation for asynchronous processing, returning if the job was enqueued successfully to be processed. We attempt to perform a best-effort validation on inputs before tasks are enqueued. If the given parameters are incorrect, we won't enqueue the job.
     */
    public IntercomHttpResponse<Jobs> enqueueCreateTicket(EnqueueCreateTicketRequest request) {
        return enqueueCreateTicket(request, null);
    }

    /**
     * Enqueues ticket creation for asynchronous processing, returning if the job was enqueued successfully to be processed. We attempt to perform a best-effort validation on inputs before tasks are enqueued. If the given parameters are incorrect, we won't enqueue the job.
     */
    public IntercomHttpResponse<Jobs> enqueueCreateTicket(
            EnqueueCreateTicketRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("tickets/enqueue")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Jobs.class), response);
            }
            try {
                switch (response.code()) {
                    case 400:
                        throw new BadRequestError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    case 401:
                        throw new UnauthorizedError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can fetch the details of a single ticket.
     */
    public IntercomHttpResponse<Optional<Ticket>> getTicket(GetTicketRequest request) {
        return getTicket(request, null);
    }

    /**
     * You can fetch the details of a single ticket.
     */
    public IntercomHttpResponse<Optional<Ticket>> getTicket(GetTicketRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("tickets")
                .addPathSegment(request.getId())
                .build();
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(
                                responseBodyString, new TypeReference<Optional<Ticket>>() {}),
                        response);
            }
            try {
                if (response.code() == 401) {
                    throw new UnauthorizedError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can update a ticket.
     */
    public IntercomHttpResponse<Optional<Ticket>> updateTicket(UpdateTicketRequest request) {
        return updateTicket(request, null);
    }

    /**
     * You can update a ticket.
     */
    public IntercomHttpResponse<Optional<Ticket>> updateTicket(
            UpdateTicketRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("tickets")
                .addPathSegment(request.getId())
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("PUT", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(
                                responseBodyString, new TypeReference<Optional<Ticket>>() {}),
                        response);
            }
            try {
                switch (response.code()) {
                    case 400:
                        throw new BadRequestError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    case 401:
                        throw new UnauthorizedError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 404:
                        throw new NotFoundError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can delete a ticket using the Intercom provided ID.
     */
    public IntercomHttpResponse<DeleteTicketResponse> deleteTicket(DeleteTicketRequest request) {
        return deleteTicket(request, null);
    }

    /**
     * You can delete a ticket using the Intercom provided ID.
     */
    public IntercomHttpResponse<DeleteTicketResponse> deleteTicket(
            DeleteTicketRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("tickets")
                .addPathSegment(request.getId())
                .build();
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl)
                .method("DELETE", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, DeleteTicketResponse.class), response);
            }
            try {
                switch (response.code()) {
                    case 401:
                        throw new UnauthorizedError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 404:
                        throw new NotFoundError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can search for multiple tickets by the value of their attributes in order to fetch exactly which ones you want.
     * <p>To search for tickets, you send a <code>POST</code> request to <code>https://api.intercom.io/tickets/search</code>.</p>
     * <p>This will accept a query object in the body which will define your filters.
     * {% admonition type=&quot;warning&quot; name=&quot;Optimizing search queries&quot; %}
     * Search queries can be complex, so optimizing them can help the performance of your search.
     * Use the <code>AND</code> and <code>OR</code> operators to combine multiple filters to get the exact results you need and utilize
     * pagination to limit the number of results returned. The default is <code>20</code> results per page.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#example-search-conversations-request">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}</p>
     * <h3>Nesting &amp; Limitations</h3>
     * <p>You can nest these filters in order to get even more granular insights that pinpoint exactly what you need. Example: (1 OR 2) AND (3 OR 4).
     * There are some limitations to the amount of multiples there can be:</p>
     * <ul>
     * <li>There's a limit of max 2 nested filters</li>
     * <li>There's a limit of max 15 filters for each AND or OR group</li>
     * </ul>
     * <h3>Accepted Fields</h3>
     * <p>Most keys listed as part of the Ticket model are searchable, whether writeable or not. The value you search for has to match the accepted type, otherwise the query will fail (ie. as <code>created_at</code> accepts a date, the <code>value</code> cannot be a string such as <code>&quot;foobar&quot;</code>).
     * The <code>source.body</code> field is unique as the search will not be performed against the entire value, but instead against every element of the value separately. For example, when searching for a conversation with a <code>&quot;I need support&quot;</code> body - the query should contain a <code>=</code> operator with the value <code>&quot;support&quot;</code> for such conversation to be returned. A query with a <code>=</code> operator and a <code>&quot;need support&quot;</code> value will not yield a result.</p>
     * <p>| Field                                     | Type                                                                                     |
     * | :---------------------------------------- | :--------------------------------------------------------------------------------------- |
     * | id                                        | String                                                                                   |
     * | created_at                                | Date (UNIX timestamp)                                                                    |
     * | updated_at                                | Date (UNIX timestamp)                                                                    |
     * | title                           | String                                                                                   |
     * | description                     | String                                                                                   |
     * | category                                  | String                                                                                   |
     * | ticket_type_id                            | String                                                                                   |
     * | contact_ids                               | String                                                                                   |
     * | teammate_ids                              | String                                                                                   |
     * | admin_assignee_id                         | String                                                                                   |
     * | team_assignee_id                          | String                                                                                   |
     * | open                                      | Boolean                                                                                  |
     * | state                                     | String                                                                                   |
     * | snoozed_until                             | Date (UNIX timestamp)                                                                    |
     * | ticket_attribute.{id}                     | String or Boolean or Date (UNIX timestamp) or Float or Integer                           |</p>
     * <p>{% admonition type=&quot;info&quot; name=&quot;Searching by Category&quot; %}
     * When searching for tickets by the <strong><code>category</code></strong> field, specific terms must be used instead of the category names:</p>
     * <ul>
     * <li>For <strong>Customer</strong> category tickets, use the term <code>request</code>.</li>
     * <li>For <strong>Back-office</strong> category tickets, use the term <code>task</code>.</li>
     * <li>For <strong>Tracker</strong> category tickets, use the term <code>tracker</code>.
     * {% /admonition %}</li>
     * </ul>
     * <h3>Accepted Operators</h3>
     * <p>{% admonition type=&quot;info&quot; name=&quot;Searching based on <code>created_at</code>&quot; %}
     * You may use the <code>&lt;=</code> or <code>&gt;=</code> operators to search by <code>created_at</code>.
     * {% /admonition %}</p>
     * <p>The table below shows the operators you can use to define how you want to search for the value.  The operator should be put in as a string (<code>&quot;=&quot;</code>). The operator has to be compatible with the field's type  (eg. you cannot search with <code>&gt;</code> for a given string value as it's only compatible for integer's and dates).</p>
     * <p>| Operator | Valid Types                    | Description                                                  |
     * | :------- | :----------------------------- | :----------------------------------------------------------- |
     * | =        | All                            | Equals                                                       |
     * | !=       | All                            | Doesn't Equal                                                |
     * | IN       | All                            | In  Shortcut for <code>OR</code> queries  Values most be in Array       |
     * | NIN      | All                            | Not In  Shortcut for <code>OR !</code> queries  Values must be in Array |
     * | &gt;        | Integer  Date (UNIX Timestamp) | Greater (or equal) than                                      |
     * | &lt;       | Integer  Date (UNIX Timestamp) | Lower (or equal) than                                        |
     * | ~        | String                         | Contains                                                     |
     * | !~       | String                         | Doesn't Contain                                              |
     * | ^        | String                         | Starts With                                                  |
     * | $        | String                         | Ends With                                                    |</p>
     */
    public IntercomHttpResponse<TicketList> searchTickets(SearchRequest request) {
        return searchTickets(request, null);
    }

    /**
     * You can search for multiple tickets by the value of their attributes in order to fetch exactly which ones you want.
     * <p>To search for tickets, you send a <code>POST</code> request to <code>https://api.intercom.io/tickets/search</code>.</p>
     * <p>This will accept a query object in the body which will define your filters.
     * {% admonition type=&quot;warning&quot; name=&quot;Optimizing search queries&quot; %}
     * Search queries can be complex, so optimizing them can help the performance of your search.
     * Use the <code>AND</code> and <code>OR</code> operators to combine multiple filters to get the exact results you need and utilize
     * pagination to limit the number of results returned. The default is <code>20</code> results per page.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#example-search-conversations-request">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}</p>
     * <h3>Nesting &amp; Limitations</h3>
     * <p>You can nest these filters in order to get even more granular insights that pinpoint exactly what you need. Example: (1 OR 2) AND (3 OR 4).
     * There are some limitations to the amount of multiples there can be:</p>
     * <ul>
     * <li>There's a limit of max 2 nested filters</li>
     * <li>There's a limit of max 15 filters for each AND or OR group</li>
     * </ul>
     * <h3>Accepted Fields</h3>
     * <p>Most keys listed as part of the Ticket model are searchable, whether writeable or not. The value you search for has to match the accepted type, otherwise the query will fail (ie. as <code>created_at</code> accepts a date, the <code>value</code> cannot be a string such as <code>&quot;foobar&quot;</code>).
     * The <code>source.body</code> field is unique as the search will not be performed against the entire value, but instead against every element of the value separately. For example, when searching for a conversation with a <code>&quot;I need support&quot;</code> body - the query should contain a <code>=</code> operator with the value <code>&quot;support&quot;</code> for such conversation to be returned. A query with a <code>=</code> operator and a <code>&quot;need support&quot;</code> value will not yield a result.</p>
     * <p>| Field                                     | Type                                                                                     |
     * | :---------------------------------------- | :--------------------------------------------------------------------------------------- |
     * | id                                        | String                                                                                   |
     * | created_at                                | Date (UNIX timestamp)                                                                    |
     * | updated_at                                | Date (UNIX timestamp)                                                                    |
     * | title                           | String                                                                                   |
     * | description                     | String                                                                                   |
     * | category                                  | String                                                                                   |
     * | ticket_type_id                            | String                                                                                   |
     * | contact_ids                               | String                                                                                   |
     * | teammate_ids                              | String                                                                                   |
     * | admin_assignee_id                         | String                                                                                   |
     * | team_assignee_id                          | String                                                                                   |
     * | open                                      | Boolean                                                                                  |
     * | state                                     | String                                                                                   |
     * | snoozed_until                             | Date (UNIX timestamp)                                                                    |
     * | ticket_attribute.{id}                     | String or Boolean or Date (UNIX timestamp) or Float or Integer                           |</p>
     * <p>{% admonition type=&quot;info&quot; name=&quot;Searching by Category&quot; %}
     * When searching for tickets by the <strong><code>category</code></strong> field, specific terms must be used instead of the category names:</p>
     * <ul>
     * <li>For <strong>Customer</strong> category tickets, use the term <code>request</code>.</li>
     * <li>For <strong>Back-office</strong> category tickets, use the term <code>task</code>.</li>
     * <li>For <strong>Tracker</strong> category tickets, use the term <code>tracker</code>.
     * {% /admonition %}</li>
     * </ul>
     * <h3>Accepted Operators</h3>
     * <p>{% admonition type=&quot;info&quot; name=&quot;Searching based on <code>created_at</code>&quot; %}
     * You may use the <code>&lt;=</code> or <code>&gt;=</code> operators to search by <code>created_at</code>.
     * {% /admonition %}</p>
     * <p>The table below shows the operators you can use to define how you want to search for the value.  The operator should be put in as a string (<code>&quot;=&quot;</code>). The operator has to be compatible with the field's type  (eg. you cannot search with <code>&gt;</code> for a given string value as it's only compatible for integer's and dates).</p>
     * <p>| Operator | Valid Types                    | Description                                                  |
     * | :------- | :----------------------------- | :----------------------------------------------------------- |
     * | =        | All                            | Equals                                                       |
     * | !=       | All                            | Doesn't Equal                                                |
     * | IN       | All                            | In  Shortcut for <code>OR</code> queries  Values most be in Array       |
     * | NIN      | All                            | Not In  Shortcut for <code>OR !</code> queries  Values must be in Array |
     * | &gt;        | Integer  Date (UNIX Timestamp) | Greater (or equal) than                                      |
     * | &lt;       | Integer  Date (UNIX Timestamp) | Lower (or equal) than                                        |
     * | ~        | String                         | Contains                                                     |
     * | !~       | String                         | Doesn't Contain                                              |
     * | ^        | String                         | Starts With                                                  |
     * | $        | String                         | Ends With                                                    |</p>
     */
    public IntercomHttpResponse<TicketList> searchTickets(SearchRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("tickets/search")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TicketList.class), response);
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }
}
