/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ConversationContacts.Builder.class)
public final class ConversationContacts {
    private final Optional<String> type;

    private final Optional<List<ContactReference>> contacts;

    private final Map<String, Object> additionalProperties;

    private ConversationContacts(
            Optional<String> type,
            Optional<List<ContactReference>> contacts,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.contacts = contacts;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The list of contacts (users or leads) involved in this conversation. This will only contain one customer unless more were added via the group conversation feature.
     */
    @JsonProperty("contacts")
    public Optional<List<ContactReference>> getContacts() {
        return contacts;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ConversationContacts && equalTo((ConversationContacts) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationContacts other) {
        return type.equals(other.type) && contacts.equals(other.contacts);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.contacts);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<List<ContactReference>> contacts = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ConversationContacts other) {
            type(other.getType());
            contacts(other.getContacts());
            return this;
        }

        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The list of contacts (users or leads) involved in this conversation. This will only contain one customer unless more were added via the group conversation feature.</p>
         */
        @JsonSetter(value = "contacts", nulls = Nulls.SKIP)
        public Builder contacts(Optional<List<ContactReference>> contacts) {
            this.contacts = contacts;
            return this;
        }

        public Builder contacts(List<ContactReference> contacts) {
            this.contacts = Optional.ofNullable(contacts);
            return this;
        }

        public ConversationContacts build() {
            return new ConversationContacts(type, contacts, additionalProperties);
        }
    }
}
