/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.notes;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.pagination.SyncPagingIterable;
import com.intercom.api.resources.notes.AsyncRawNotesClient;
import com.intercom.api.resources.notes.requests.CreateContactNoteRequest;
import com.intercom.api.resources.notes.requests.FindNoteRequest;
import com.intercom.api.resources.notes.requests.ListContactNotesRequest;
import com.intercom.api.resources.notes.types.Note;
import java.util.concurrent.CompletableFuture;

public class AsyncNotesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawNotesClient rawClient;

    public AsyncNotesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawNotesClient(clientOptions);
    }

    public AsyncRawNotesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<Note>> list(ListContactNotesRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Note>> list(ListContactNotesRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<Note> create(CreateContactNoteRequest request) {
        return this.rawClient.create(request).thenApply(response -> (Note)response.body());
    }

    public CompletableFuture<Note> create(CreateContactNoteRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (Note)response.body());
    }

    public CompletableFuture<Note> find(FindNoteRequest request) {
        return this.rawClient.find(request).thenApply(response -> (Note)response.body());
    }

    public CompletableFuture<Note> find(FindNoteRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).thenApply(response -> (Note)response.body());
    }
}

