/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.notes.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListContactNotesRequest {
    private final String contactId;
    private final Optional<Integer> page;
    private final Optional<Integer> perPage;
    private final Map<String, Object> additionalProperties;

    private ListContactNotesRequest(String contactId, Optional<Integer> page, Optional<Integer> perPage, Map<String, Object> additionalProperties) {
        this.contactId = contactId;
        this.page = page;
        this.perPage = perPage;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="contact_id")
    public String getContactId() {
        return this.contactId;
    }

    @JsonProperty(value="page")
    public Optional<Integer> getPage() {
        return this.page;
    }

    @JsonProperty(value="per_page")
    public Optional<Integer> getPerPage() {
        return this.perPage;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListContactNotesRequest && this.equalTo((ListContactNotesRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListContactNotesRequest other) {
        return this.contactId.equals(other.contactId) && this.page.equals(other.page) && this.perPage.equals(other.perPage);
    }

    public int hashCode() {
        return Objects.hash(this.contactId, this.page, this.perPage);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ContactIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ContactIdStage,
    _FinalStage {
        private String contactId;
        private Optional<Integer> perPage = Optional.empty();
        private Optional<Integer> page = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ListContactNotesRequest other) {
            this.contactId(other.getContactId());
            this.page(other.getPage());
            this.perPage(other.getPerPage());
            return this;
        }

        @Override
        @JsonSetter(value="contact_id")
        public _FinalStage contactId(@NotNull String contactId) {
            this.contactId = Objects.requireNonNull(contactId, "contactId must not be null");
            return this;
        }

        @Override
        public _FinalStage perPage(Integer perPage) {
            this.perPage = Optional.ofNullable(perPage);
            return this;
        }

        @Override
        @JsonSetter(value="per_page", nulls=Nulls.SKIP)
        public _FinalStage perPage(Optional<Integer> perPage) {
            this.perPage = perPage;
            return this;
        }

        @Override
        public _FinalStage page(Integer page) {
            this.page = Optional.ofNullable(page);
            return this;
        }

        @Override
        @JsonSetter(value="page", nulls=Nulls.SKIP)
        public _FinalStage page(Optional<Integer> page) {
            this.page = page;
            return this;
        }

        @Override
        public ListContactNotesRequest build() {
            return new ListContactNotesRequest(this.contactId, this.page, this.perPage, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ListContactNotesRequest build();

        public _FinalStage page(Optional<Integer> var1);

        public _FinalStage page(Integer var1);

        public _FinalStage perPage(Optional<Integer> var1);

        public _FinalStage perPage(Integer var1);
    }

    public static interface ContactIdStage {
        public _FinalStage contactId(@NotNull String var1);

        public Builder from(ListContactNotesRequest var1);
    }
}

