/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.tickettypes.attributes.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateTicketTypeAttributeRequest {
    private final String ticketTypeId;
    private final String attributeId;
    private final Optional<String> name;
    private final Optional<String> description;
    private final Optional<Boolean> requiredToCreate;
    private final Optional<Boolean> requiredToCreateForContacts;
    private final Optional<Boolean> visibleOnCreate;
    private final Optional<Boolean> visibleToContacts;
    private final Optional<Boolean> multiline;
    private final Optional<String> listItems;
    private final Optional<Boolean> allowMultipleValues;
    private final Optional<Boolean> archived;
    private final Map<String, Object> additionalProperties;

    private UpdateTicketTypeAttributeRequest(String ticketTypeId, String attributeId, Optional<String> name, Optional<String> description, Optional<Boolean> requiredToCreate, Optional<Boolean> requiredToCreateForContacts, Optional<Boolean> visibleOnCreate, Optional<Boolean> visibleToContacts, Optional<Boolean> multiline, Optional<String> listItems, Optional<Boolean> allowMultipleValues, Optional<Boolean> archived, Map<String, Object> additionalProperties) {
        this.ticketTypeId = ticketTypeId;
        this.attributeId = attributeId;
        this.name = name;
        this.description = description;
        this.requiredToCreate = requiredToCreate;
        this.requiredToCreateForContacts = requiredToCreateForContacts;
        this.visibleOnCreate = visibleOnCreate;
        this.visibleToContacts = visibleToContacts;
        this.multiline = multiline;
        this.listItems = listItems;
        this.allowMultipleValues = allowMultipleValues;
        this.archived = archived;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="ticket_type_id")
    public String getTicketTypeId() {
        return this.ticketTypeId;
    }

    @JsonProperty(value="attribute_id")
    public String getAttributeId() {
        return this.attributeId;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="required_to_create")
    public Optional<Boolean> getRequiredToCreate() {
        return this.requiredToCreate;
    }

    @JsonProperty(value="required_to_create_for_contacts")
    public Optional<Boolean> getRequiredToCreateForContacts() {
        return this.requiredToCreateForContacts;
    }

    @JsonProperty(value="visible_on_create")
    public Optional<Boolean> getVisibleOnCreate() {
        return this.visibleOnCreate;
    }

    @JsonProperty(value="visible_to_contacts")
    public Optional<Boolean> getVisibleToContacts() {
        return this.visibleToContacts;
    }

    @JsonProperty(value="multiline")
    public Optional<Boolean> getMultiline() {
        return this.multiline;
    }

    @JsonProperty(value="list_items")
    public Optional<String> getListItems() {
        return this.listItems;
    }

    @JsonProperty(value="allow_multiple_values")
    public Optional<Boolean> getAllowMultipleValues() {
        return this.allowMultipleValues;
    }

    @JsonProperty(value="archived")
    public Optional<Boolean> getArchived() {
        return this.archived;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateTicketTypeAttributeRequest && this.equalTo((UpdateTicketTypeAttributeRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateTicketTypeAttributeRequest other) {
        return this.ticketTypeId.equals(other.ticketTypeId) && this.attributeId.equals(other.attributeId) && this.name.equals(other.name) && this.description.equals(other.description) && this.requiredToCreate.equals(other.requiredToCreate) && this.requiredToCreateForContacts.equals(other.requiredToCreateForContacts) && this.visibleOnCreate.equals(other.visibleOnCreate) && this.visibleToContacts.equals(other.visibleToContacts) && this.multiline.equals(other.multiline) && this.listItems.equals(other.listItems) && this.allowMultipleValues.equals(other.allowMultipleValues) && this.archived.equals(other.archived);
    }

    public int hashCode() {
        return Objects.hash(this.ticketTypeId, this.attributeId, this.name, this.description, this.requiredToCreate, this.requiredToCreateForContacts, this.visibleOnCreate, this.visibleToContacts, this.multiline, this.listItems, this.allowMultipleValues, this.archived);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TicketTypeIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TicketTypeIdStage,
    AttributeIdStage,
    _FinalStage {
        private String ticketTypeId;
        private String attributeId;
        private Optional<Boolean> archived = Optional.empty();
        private Optional<Boolean> allowMultipleValues = Optional.empty();
        private Optional<String> listItems = Optional.empty();
        private Optional<Boolean> multiline = Optional.empty();
        private Optional<Boolean> visibleToContacts = Optional.empty();
        private Optional<Boolean> visibleOnCreate = Optional.empty();
        private Optional<Boolean> requiredToCreateForContacts = Optional.empty();
        private Optional<Boolean> requiredToCreate = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> name = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateTicketTypeAttributeRequest other) {
            this.ticketTypeId(other.getTicketTypeId());
            this.attributeId(other.getAttributeId());
            this.name(other.getName());
            this.description(other.getDescription());
            this.requiredToCreate(other.getRequiredToCreate());
            this.requiredToCreateForContacts(other.getRequiredToCreateForContacts());
            this.visibleOnCreate(other.getVisibleOnCreate());
            this.visibleToContacts(other.getVisibleToContacts());
            this.multiline(other.getMultiline());
            this.listItems(other.getListItems());
            this.allowMultipleValues(other.getAllowMultipleValues());
            this.archived(other.getArchived());
            return this;
        }

        @Override
        @JsonSetter(value="ticket_type_id")
        public AttributeIdStage ticketTypeId(@NotNull String ticketTypeId) {
            this.ticketTypeId = Objects.requireNonNull(ticketTypeId, "ticketTypeId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="attribute_id")
        public _FinalStage attributeId(@NotNull String attributeId) {
            this.attributeId = Objects.requireNonNull(attributeId, "attributeId must not be null");
            return this;
        }

        @Override
        public _FinalStage archived(Boolean archived) {
            this.archived = Optional.ofNullable(archived);
            return this;
        }

        @Override
        @JsonSetter(value="archived", nulls=Nulls.SKIP)
        public _FinalStage archived(Optional<Boolean> archived) {
            this.archived = archived;
            return this;
        }

        @Override
        public _FinalStage allowMultipleValues(Boolean allowMultipleValues) {
            this.allowMultipleValues = Optional.ofNullable(allowMultipleValues);
            return this;
        }

        @Override
        @JsonSetter(value="allow_multiple_values", nulls=Nulls.SKIP)
        public _FinalStage allowMultipleValues(Optional<Boolean> allowMultipleValues) {
            this.allowMultipleValues = allowMultipleValues;
            return this;
        }

        @Override
        public _FinalStage listItems(String listItems) {
            this.listItems = Optional.ofNullable(listItems);
            return this;
        }

        @Override
        @JsonSetter(value="list_items", nulls=Nulls.SKIP)
        public _FinalStage listItems(Optional<String> listItems) {
            this.listItems = listItems;
            return this;
        }

        @Override
        public _FinalStage multiline(Boolean multiline) {
            this.multiline = Optional.ofNullable(multiline);
            return this;
        }

        @Override
        @JsonSetter(value="multiline", nulls=Nulls.SKIP)
        public _FinalStage multiline(Optional<Boolean> multiline) {
            this.multiline = multiline;
            return this;
        }

        @Override
        public _FinalStage visibleToContacts(Boolean visibleToContacts) {
            this.visibleToContacts = Optional.ofNullable(visibleToContacts);
            return this;
        }

        @Override
        @JsonSetter(value="visible_to_contacts", nulls=Nulls.SKIP)
        public _FinalStage visibleToContacts(Optional<Boolean> visibleToContacts) {
            this.visibleToContacts = visibleToContacts;
            return this;
        }

        @Override
        public _FinalStage visibleOnCreate(Boolean visibleOnCreate) {
            this.visibleOnCreate = Optional.ofNullable(visibleOnCreate);
            return this;
        }

        @Override
        @JsonSetter(value="visible_on_create", nulls=Nulls.SKIP)
        public _FinalStage visibleOnCreate(Optional<Boolean> visibleOnCreate) {
            this.visibleOnCreate = visibleOnCreate;
            return this;
        }

        @Override
        public _FinalStage requiredToCreateForContacts(Boolean requiredToCreateForContacts) {
            this.requiredToCreateForContacts = Optional.ofNullable(requiredToCreateForContacts);
            return this;
        }

        @Override
        @JsonSetter(value="required_to_create_for_contacts", nulls=Nulls.SKIP)
        public _FinalStage requiredToCreateForContacts(Optional<Boolean> requiredToCreateForContacts) {
            this.requiredToCreateForContacts = requiredToCreateForContacts;
            return this;
        }

        @Override
        public _FinalStage requiredToCreate(Boolean requiredToCreate) {
            this.requiredToCreate = Optional.ofNullable(requiredToCreate);
            return this;
        }

        @Override
        @JsonSetter(value="required_to_create", nulls=Nulls.SKIP)
        public _FinalStage requiredToCreate(Optional<Boolean> requiredToCreate) {
            this.requiredToCreate = requiredToCreate;
            return this;
        }

        @Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @Override
        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public UpdateTicketTypeAttributeRequest build() {
            return new UpdateTicketTypeAttributeRequest(this.ticketTypeId, this.attributeId, this.name, this.description, this.requiredToCreate, this.requiredToCreateForContacts, this.visibleOnCreate, this.visibleToContacts, this.multiline, this.listItems, this.allowMultipleValues, this.archived, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateTicketTypeAttributeRequest build();

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage description(Optional<String> var1);

        public _FinalStage description(String var1);

        public _FinalStage requiredToCreate(Optional<Boolean> var1);

        public _FinalStage requiredToCreate(Boolean var1);

        public _FinalStage requiredToCreateForContacts(Optional<Boolean> var1);

        public _FinalStage requiredToCreateForContacts(Boolean var1);

        public _FinalStage visibleOnCreate(Optional<Boolean> var1);

        public _FinalStage visibleOnCreate(Boolean var1);

        public _FinalStage visibleToContacts(Optional<Boolean> var1);

        public _FinalStage visibleToContacts(Boolean var1);

        public _FinalStage multiline(Optional<Boolean> var1);

        public _FinalStage multiline(Boolean var1);

        public _FinalStage listItems(Optional<String> var1);

        public _FinalStage listItems(String var1);

        public _FinalStage allowMultipleValues(Optional<Boolean> var1);

        public _FinalStage allowMultipleValues(Boolean var1);

        public _FinalStage archived(Optional<Boolean> var1);

        public _FinalStage archived(Boolean var1);
    }

    public static interface AttributeIdStage {
        public _FinalStage attributeId(@NotNull String var1);
    }

    public static interface TicketTypeIdStage {
        public AttributeIdStage ticketTypeId(@NotNull String var1);

        public Builder from(UpdateTicketTypeAttributeRequest var1);
    }
}

