/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.articles.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.articles.types.IArticleListItem;
import com.intercom.api.resources.unstable.types.ArticleTranslatedContent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ArticleListItem
implements IArticleListItem {
    private final Optional<String> type;
    private final Optional<String> id;
    private final Optional<String> workspaceId;
    private final Optional<String> title;
    private final Optional<String> description;
    private final Optional<String> body;
    private final Optional<Integer> authorId;
    private final Optional<State> state;
    private final Optional<Integer> createdAt;
    private final Optional<Integer> updatedAt;
    private final Optional<String> url;
    private final Optional<Integer> parentId;
    private final Optional<List<Integer>> parentIds;
    private final Optional<String> parentType;
    private final Optional<String> defaultLocale;
    private final Optional<ArticleTranslatedContent> translatedContent;
    private final Map<String, Object> additionalProperties;

    private ArticleListItem(Optional<String> type, Optional<String> id, Optional<String> workspaceId, Optional<String> title, Optional<String> description, Optional<String> body, Optional<Integer> authorId, Optional<State> state, Optional<Integer> createdAt, Optional<Integer> updatedAt, Optional<String> url, Optional<Integer> parentId, Optional<List<Integer>> parentIds, Optional<String> parentType, Optional<String> defaultLocale, Optional<ArticleTranslatedContent> translatedContent, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.workspaceId = workspaceId;
        this.title = title;
        this.description = description;
        this.body = body;
        this.authorId = authorId;
        this.state = state;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.url = url;
        this.parentId = parentId;
        this.parentIds = parentIds;
        this.parentType = parentType;
        this.defaultLocale = defaultLocale;
        this.translatedContent = translatedContent;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="workspace_id")
    public Optional<String> getWorkspaceId() {
        return this.workspaceId;
    }

    @Override
    @JsonProperty(value="title")
    public Optional<String> getTitle() {
        return this.title;
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="body")
    public Optional<String> getBody() {
        return this.body;
    }

    @Override
    @JsonProperty(value="author_id")
    public Optional<Integer> getAuthorId() {
        return this.authorId;
    }

    @JsonProperty(value="state")
    public Optional<State> getState() {
        return this.state;
    }

    @Override
    @JsonProperty(value="created_at")
    public Optional<Integer> getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="updated_at")
    public Optional<Integer> getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="url")
    public Optional<String> getUrl() {
        return this.url;
    }

    @Override
    @JsonProperty(value="parent_id")
    public Optional<Integer> getParentId() {
        return this.parentId;
    }

    @Override
    @JsonProperty(value="parent_ids")
    public Optional<List<Integer>> getParentIds() {
        return this.parentIds;
    }

    @Override
    @JsonProperty(value="parent_type")
    public Optional<String> getParentType() {
        return this.parentType;
    }

    @Override
    @JsonProperty(value="default_locale")
    public Optional<String> getDefaultLocale() {
        return this.defaultLocale;
    }

    @Override
    @JsonProperty(value="translated_content")
    public Optional<ArticleTranslatedContent> getTranslatedContent() {
        return this.translatedContent;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ArticleListItem && this.equalTo((ArticleListItem)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ArticleListItem other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.workspaceId.equals(other.workspaceId) && this.title.equals(other.title) && this.description.equals(other.description) && this.body.equals(other.body) && this.authorId.equals(other.authorId) && this.state.equals(other.state) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.url.equals(other.url) && this.parentId.equals(other.parentId) && this.parentIds.equals(other.parentIds) && this.parentType.equals(other.parentType) && this.defaultLocale.equals(other.defaultLocale) && this.translatedContent.equals(other.translatedContent);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.workspaceId, this.title, this.description, this.body, this.authorId, this.state, this.createdAt, this.updatedAt, this.url, this.parentId, this.parentIds, this.parentType, this.defaultLocale, this.translatedContent);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class State {
        public static final State PUBLISHED = new State(Value.PUBLISHED, "published");
        public static final State DRAFT = new State(Value.DRAFT, "draft");
        private final Value value;
        private final String string;

        State(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof State && this.string.equals(((State)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case PUBLISHED: {
                    return visitor.visitPublished();
                }
                case DRAFT: {
                    return visitor.visitDraft();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static State valueOf(String value) {
            switch (value) {
                case "published": {
                    return PUBLISHED;
                }
                case "draft": {
                    return DRAFT;
                }
            }
            return new State(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitPublished();

            public T visitDraft();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            PUBLISHED,
            DRAFT,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<String> workspaceId = Optional.empty();
        private Optional<String> title = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> body = Optional.empty();
        private Optional<Integer> authorId = Optional.empty();
        private Optional<State> state = Optional.empty();
        private Optional<Integer> createdAt = Optional.empty();
        private Optional<Integer> updatedAt = Optional.empty();
        private Optional<String> url = Optional.empty();
        private Optional<Integer> parentId = Optional.empty();
        private Optional<List<Integer>> parentIds = Optional.empty();
        private Optional<String> parentType = Optional.empty();
        private Optional<String> defaultLocale = Optional.empty();
        private Optional<ArticleTranslatedContent> translatedContent = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ArticleListItem other) {
            this.type(other.getType());
            this.id(other.getId());
            this.workspaceId(other.getWorkspaceId());
            this.title(other.getTitle());
            this.description(other.getDescription());
            this.body(other.getBody());
            this.authorId(other.getAuthorId());
            this.state(other.getState());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.url(other.getUrl());
            this.parentId(other.getParentId());
            this.parentIds(other.getParentIds());
            this.parentType(other.getParentType());
            this.defaultLocale(other.getDefaultLocale());
            this.translatedContent(other.getTranslatedContent());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="workspace_id", nulls=Nulls.SKIP)
        public Builder workspaceId(Optional<String> workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = Optional.ofNullable(workspaceId);
            return this;
        }

        @JsonSetter(value="title", nulls=Nulls.SKIP)
        public Builder title(Optional<String> title) {
            this.title = title;
            return this;
        }

        public Builder title(String title) {
            this.title = Optional.ofNullable(title);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @JsonSetter(value="body", nulls=Nulls.SKIP)
        public Builder body(Optional<String> body) {
            this.body = body;
            return this;
        }

        public Builder body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        @JsonSetter(value="author_id", nulls=Nulls.SKIP)
        public Builder authorId(Optional<Integer> authorId) {
            this.authorId = authorId;
            return this;
        }

        public Builder authorId(Integer authorId) {
            this.authorId = Optional.ofNullable(authorId);
            return this;
        }

        @JsonSetter(value="state", nulls=Nulls.SKIP)
        public Builder state(Optional<State> state) {
            this.state = state;
            return this;
        }

        public Builder state(State state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="url", nulls=Nulls.SKIP)
        public Builder url(Optional<String> url) {
            this.url = url;
            return this;
        }

        public Builder url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        @JsonSetter(value="parent_id", nulls=Nulls.SKIP)
        public Builder parentId(Optional<Integer> parentId) {
            this.parentId = parentId;
            return this;
        }

        public Builder parentId(Integer parentId) {
            this.parentId = Optional.ofNullable(parentId);
            return this;
        }

        @JsonSetter(value="parent_ids", nulls=Nulls.SKIP)
        public Builder parentIds(Optional<List<Integer>> parentIds) {
            this.parentIds = parentIds;
            return this;
        }

        public Builder parentIds(List<Integer> parentIds) {
            this.parentIds = Optional.ofNullable(parentIds);
            return this;
        }

        @JsonSetter(value="parent_type", nulls=Nulls.SKIP)
        public Builder parentType(Optional<String> parentType) {
            this.parentType = parentType;
            return this;
        }

        public Builder parentType(String parentType) {
            this.parentType = Optional.ofNullable(parentType);
            return this;
        }

        @JsonSetter(value="default_locale", nulls=Nulls.SKIP)
        public Builder defaultLocale(Optional<String> defaultLocale) {
            this.defaultLocale = defaultLocale;
            return this;
        }

        public Builder defaultLocale(String defaultLocale) {
            this.defaultLocale = Optional.ofNullable(defaultLocale);
            return this;
        }

        @JsonSetter(value="translated_content", nulls=Nulls.SKIP)
        public Builder translatedContent(Optional<ArticleTranslatedContent> translatedContent) {
            this.translatedContent = translatedContent;
            return this;
        }

        public Builder translatedContent(ArticleTranslatedContent translatedContent) {
            this.translatedContent = Optional.ofNullable(translatedContent);
            return this;
        }

        public ArticleListItem build() {
            return new ArticleListItem(this.type, this.id, this.workspaceId, this.title, this.description, this.body, this.authorId, this.state, this.createdAt, this.updatedAt, this.url, this.parentId, this.parentIds, this.parentType, this.defaultLocale, this.translatedContent, this.additionalProperties);
        }
    }
}

