/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.jobs.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Jobs {
    private final Optional<String> type;
    private final String id;
    private final Optional<String> url;
    private final Optional<Status> status;
    private final Optional<String> resourceType;
    private final Optional<String> resourceId;
    private final Optional<String> resourceUrl;
    private final Map<String, Object> additionalProperties;

    private Jobs(Optional<String> type, String id, Optional<String> url, Optional<Status> status, Optional<String> resourceType, Optional<String> resourceId, Optional<String> resourceUrl, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.url = url;
        this.status = status;
        this.resourceType = resourceType;
        this.resourceId = resourceId;
        this.resourceUrl = resourceUrl;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="url")
    public Optional<String> getUrl() {
        return this.url;
    }

    @JsonProperty(value="status")
    public Optional<Status> getStatus() {
        return this.status;
    }

    @JsonProperty(value="resource_type")
    public Optional<String> getResourceType() {
        return this.resourceType;
    }

    @JsonProperty(value="resource_id")
    public Optional<String> getResourceId() {
        return this.resourceId;
    }

    @JsonProperty(value="resource_url")
    public Optional<String> getResourceUrl() {
        return this.resourceUrl;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Jobs && this.equalTo((Jobs)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Jobs other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.url.equals(other.url) && this.status.equals(other.status) && this.resourceType.equals(other.resourceType) && this.resourceId.equals(other.resourceId) && this.resourceUrl.equals(other.resourceUrl);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.url, this.status, this.resourceType, this.resourceId, this.resourceUrl);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public static final class Status {
        public static final Status SUCCESS = new Status(Value.SUCCESS, "success");
        public static final Status FAILED = new Status(Value.FAILED, "failed");
        public static final Status PENDING = new Status(Value.PENDING, "pending");
        private final Value value;
        private final String string;

        Status(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Status && this.string.equals(((Status)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case SUCCESS: {
                    return visitor.visitSuccess();
                }
                case FAILED: {
                    return visitor.visitFailed();
                }
                case PENDING: {
                    return visitor.visitPending();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Status valueOf(String value) {
            switch (value) {
                case "success": {
                    return SUCCESS;
                }
                case "failed": {
                    return FAILED;
                }
                case "pending": {
                    return PENDING;
                }
            }
            return new Status(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitPending();

            public T visitSuccess();

            public T visitFailed();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            PENDING,
            SUCCESS,
            FAILED,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    _FinalStage {
        private String id;
        private Optional<String> resourceUrl = Optional.empty();
        private Optional<String> resourceId = Optional.empty();
        private Optional<String> resourceType = Optional.empty();
        private Optional<Status> status = Optional.empty();
        private Optional<String> url = Optional.empty();
        private Optional<String> type = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Jobs other) {
            this.type(other.getType());
            this.id(other.getId());
            this.url(other.getUrl());
            this.status(other.getStatus());
            this.resourceType(other.getResourceType());
            this.resourceId(other.getResourceId());
            this.resourceUrl(other.getResourceUrl());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        public _FinalStage resourceUrl(String resourceUrl) {
            this.resourceUrl = Optional.ofNullable(resourceUrl);
            return this;
        }

        @Override
        @JsonSetter(value="resource_url", nulls=Nulls.SKIP)
        public _FinalStage resourceUrl(Optional<String> resourceUrl) {
            this.resourceUrl = resourceUrl;
            return this;
        }

        @Override
        public _FinalStage resourceId(String resourceId) {
            this.resourceId = Optional.ofNullable(resourceId);
            return this;
        }

        @Override
        @JsonSetter(value="resource_id", nulls=Nulls.SKIP)
        public _FinalStage resourceId(Optional<String> resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        @Override
        public _FinalStage resourceType(String resourceType) {
            this.resourceType = Optional.ofNullable(resourceType);
            return this;
        }

        @Override
        @JsonSetter(value="resource_type", nulls=Nulls.SKIP)
        public _FinalStage resourceType(Optional<String> resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public _FinalStage status(Status status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<Status> status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        @Override
        @JsonSetter(value="url", nulls=Nulls.SKIP)
        public _FinalStage url(Optional<String> url) {
            this.url = url;
            return this;
        }

        @Override
        public _FinalStage type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @Override
        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public _FinalStage type(Optional<String> type) {
            this.type = type;
            return this;
        }

        @Override
        public Jobs build() {
            return new Jobs(this.type, this.id, this.url, this.status, this.resourceType, this.resourceId, this.resourceUrl, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Jobs build();

        public _FinalStage type(Optional<String> var1);

        public _FinalStage type(String var1);

        public _FinalStage url(Optional<String> var1);

        public _FinalStage url(String var1);

        public _FinalStage status(Optional<Status> var1);

        public _FinalStage status(Status var1);

        public _FinalStage resourceType(Optional<String> var1);

        public _FinalStage resourceType(String var1);

        public _FinalStage resourceId(Optional<String> var1);

        public _FinalStage resourceId(String var1);

        public _FinalStage resourceUrl(Optional<String> var1);

        public _FinalStage resourceUrl(String var1);
    }

    public static interface IdStage {
        public _FinalStage id(@NotNull String var1);

        public Builder from(Jobs var1);
    }
}

