/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class RedactConversationRequest {
    private final Value value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private RedactConversationRequest(Value value) {
        this.value = value;
    }

    public <T> T visit(Visitor<T> visitor) {
        return this.value.visit(visitor);
    }

    public static RedactConversationRequest conversationPart(ConversationPart value) {
        return new RedactConversationRequest(new ConversationPartValue(value));
    }

    public static RedactConversationRequest source(Source value) {
        return new RedactConversationRequest(new SourceValue(value));
    }

    public boolean isConversationPart() {
        return this.value instanceof ConversationPartValue;
    }

    public boolean isSource() {
        return this.value instanceof SourceValue;
    }

    public boolean _isUnknown() {
        return this.value instanceof _UnknownValue;
    }

    public Optional<ConversationPart> getConversationPart() {
        if (this.isConversationPart()) {
            return Optional.of(((ConversationPartValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<Source> getSource() {
        if (this.isSource()) {
            return Optional.of(((SourceValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<Object> _getUnknown() {
        if (this._isUnknown()) {
            return Optional.of(((_UnknownValue)this.value).value);
        }
        return Optional.empty();
    }

    @JsonValue
    private Value getValue() {
        return this.value;
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Source {
        private final String conversationId;
        private final String sourceId;
        private final Map<String, Object> additionalProperties;

        private Source(String conversationId, String sourceId, Map<String, Object> additionalProperties) {
            this.conversationId = conversationId;
            this.sourceId = sourceId;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="conversation_id")
        public String getConversationId() {
            return this.conversationId;
        }

        @JsonProperty(value="source_id")
        public String getSourceId() {
            return this.sourceId;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Source && this.equalTo((Source)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Source other) {
            return this.conversationId.equals(other.conversationId) && this.sourceId.equals(other.sourceId);
        }

        public int hashCode() {
            return Objects.hash(this.conversationId, this.sourceId);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static ConversationIdStage builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder
        implements ConversationIdStage,
        SourceIdStage,
        _FinalStage {
            private String conversationId;
            private String sourceId;
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            @Override
            public Builder from(Source other) {
                this.conversationId(other.getConversationId());
                this.sourceId(other.getSourceId());
                return this;
            }

            @Override
            @JsonSetter(value="conversation_id")
            public SourceIdStage conversationId(@NotNull String conversationId) {
                this.conversationId = Objects.requireNonNull(conversationId, "conversationId must not be null");
                return this;
            }

            @Override
            @JsonSetter(value="source_id")
            public _FinalStage sourceId(@NotNull String sourceId) {
                this.sourceId = Objects.requireNonNull(sourceId, "sourceId must not be null");
                return this;
            }

            @Override
            public Source build() {
                return new Source(this.conversationId, this.sourceId, this.additionalProperties);
            }
        }

        public static interface _FinalStage {
            public Source build();
        }

        public static interface SourceIdStage {
            public _FinalStage sourceId(@NotNull String var1);
        }

        public static interface ConversationIdStage {
            public SourceIdStage conversationId(@NotNull String var1);

            public Builder from(Source var1);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class ConversationPart {
        private final String conversationId;
        private final String conversationPartId;
        private final Map<String, Object> additionalProperties;

        private ConversationPart(String conversationId, String conversationPartId, Map<String, Object> additionalProperties) {
            this.conversationId = conversationId;
            this.conversationPartId = conversationPartId;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="conversation_id")
        public String getConversationId() {
            return this.conversationId;
        }

        @JsonProperty(value="conversation_part_id")
        public String getConversationPartId() {
            return this.conversationPartId;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ConversationPart && this.equalTo((ConversationPart)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(ConversationPart other) {
            return this.conversationId.equals(other.conversationId) && this.conversationPartId.equals(other.conversationPartId);
        }

        public int hashCode() {
            return Objects.hash(this.conversationId, this.conversationPartId);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static ConversationIdStage builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder
        implements ConversationIdStage,
        ConversationPartIdStage,
        _FinalStage {
            private String conversationId;
            private String conversationPartId;
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            @Override
            public Builder from(ConversationPart other) {
                this.conversationId(other.getConversationId());
                this.conversationPartId(other.getConversationPartId());
                return this;
            }

            @Override
            @JsonSetter(value="conversation_id")
            public ConversationPartIdStage conversationId(@NotNull String conversationId) {
                this.conversationId = Objects.requireNonNull(conversationId, "conversationId must not be null");
                return this;
            }

            @Override
            @JsonSetter(value="conversation_part_id")
            public _FinalStage conversationPartId(@NotNull String conversationPartId) {
                this.conversationPartId = Objects.requireNonNull(conversationPartId, "conversationPartId must not be null");
                return this;
            }

            @Override
            public ConversationPart build() {
                return new ConversationPart(this.conversationId, this.conversationPartId, this.additionalProperties);
            }
        }

        public static interface _FinalStage {
            public ConversationPart build();
        }

        public static interface ConversationPartIdStage {
            public _FinalStage conversationPartId(@NotNull String var1);
        }

        public static interface ConversationIdStage {
            public ConversationPartIdStage conversationId(@NotNull String var1);

            public Builder from(ConversationPart var1);
        }
    }

    @JsonIgnoreProperties(value={"type"})
    private static final class _UnknownValue
    implements Value {
        private String type;
        @JsonValue
        private Object value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private _UnknownValue(@JsonProperty(value="value") Object value) {
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor._visitUnknown(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof _UnknownValue && this.equalTo((_UnknownValue)other);
        }

        private boolean equalTo(_UnknownValue other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public String toString() {
            return "RedactConversationRequest{type: " + this.type + ", value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="source")
    @JsonIgnoreProperties(value={"type"})
    private static final class SourceValue
    implements Value {
        @JsonUnwrapped
        private Source value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private SourceValue() {
        }

        private SourceValue(Source value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitSource(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof SourceValue && this.equalTo((SourceValue)other);
        }

        private boolean equalTo(SourceValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "RedactConversationRequest{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="conversation_part")
    @JsonIgnoreProperties(value={"type"})
    private static final class ConversationPartValue
    implements Value {
        @JsonUnwrapped
        private ConversationPart value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ConversationPartValue() {
        }

        private ConversationPartValue(ConversationPart value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitConversationPart(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ConversationPartValue && this.equalTo((ConversationPartValue)other);
        }

        private boolean equalTo(ConversationPartValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "RedactConversationRequest{value: " + this.value + "}";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", visible=true, defaultImpl=_UnknownValue.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=ConversationPartValue.class), @JsonSubTypes.Type(value=SourceValue.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Value {
        public <T> T visit(Visitor<T> var1);
    }

    public static interface Visitor<T> {
        public T visitConversationPart(ConversationPart var1);

        public T visitSource(Source var1);

        public T _visitUnknown(Object var1);
    }
}

