/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SingleFilterSearchRequest {
    private final Optional<String> field;
    private final Optional<Operator> operator;
    private final Optional<Value> value;
    private final Map<String, Object> additionalProperties;

    private SingleFilterSearchRequest(Optional<String> field, Optional<Operator> operator, Optional<Value> value, Map<String, Object> additionalProperties) {
        this.field = field;
        this.operator = operator;
        this.value = value;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="field")
    public Optional<String> getField() {
        return this.field;
    }

    @JsonProperty(value="operator")
    public Optional<Operator> getOperator() {
        return this.operator;
    }

    @JsonProperty(value="value")
    public Optional<Value> getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SingleFilterSearchRequest && this.equalTo((SingleFilterSearchRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SingleFilterSearchRequest other) {
        return this.field.equals(other.field) && this.operator.equals(other.operator) && this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.operator, this.value);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Operator {
        public static final Operator NOT_EQUALS = new Operator(Value.NOT_EQUALS, "!=");
        public static final Operator IN = new Operator(Value.IN, "IN");
        public static final Operator LESS_THAN = new Operator(Value.LESS_THAN, "<");
        public static final Operator EQUAL_TO = new Operator(Value.EQUAL_TO, "=");
        public static final Operator NIN = new Operator(Value.NIN, "NIN");
        public static final Operator GREATER_THAN = new Operator(Value.GREATER_THAN, ">");
        private final Value value;
        private final String string;

        Operator(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Operator && this.string.equals(((Operator)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case NOT_EQUALS: {
                    return visitor.visitNotEquals();
                }
                case IN: {
                    return visitor.visitIn();
                }
                case LESS_THAN: {
                    return visitor.visitLessThan();
                }
                case EQUAL_TO: {
                    return visitor.visitEqualTo();
                }
                case NIN: {
                    return visitor.visitNin();
                }
                case GREATER_THAN: {
                    return visitor.visitGreaterThan();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Operator valueOf(String value) {
            switch (value) {
                case "!=": {
                    return NOT_EQUALS;
                }
                case "IN": {
                    return IN;
                }
                case "<": {
                    return LESS_THAN;
                }
                case "=": {
                    return EQUAL_TO;
                }
                case "NIN": {
                    return NIN;
                }
                case ">": {
                    return GREATER_THAN;
                }
            }
            return new Operator(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitEqualTo();

            public T visitNotEquals();

            public T visitIn();

            public T visitNin();

            public T visitLessThan();

            public T visitGreaterThan();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            EQUAL_TO,
            NOT_EQUALS,
            IN,
            NIN,
            LESS_THAN,
            GREATER_THAN,
            UNKNOWN;

        }
    }

    @JsonDeserialize(using=Deserializer.class)
    public static final class Value {
        private final Object value;
        private final int type;

        private Value(Object value, int type) {
            this.value = value;
            this.type = type;
        }

        @JsonValue
        public Object get() {
            return this.value;
        }

        public <T> T visit(Visitor<T> visitor) {
            if (this.type == 0) {
                return visitor.visit((String)this.value);
            }
            if (this.type == 1) {
                return visitor.visit((Integer)this.value);
            }
            if (this.type == 2) {
                return visitor.visit((List)this.value);
            }
            throw new IllegalStateException("Failed to visit value. This should never happen.");
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Value && this.equalTo((Value)other);
        }

        private boolean equalTo(Value other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return this.value.toString();
        }

        public static Value of(String value) {
            return new Value(value, 0);
        }

        public static Value of(int value) {
            return new Value(value, 1);
        }

        public static Value of(List<TwoItem> value) {
            return new Value(value, 2);
        }

        @JsonDeserialize(using=Deserializer.class)
        public static final class TwoItem {
            private final Object value;
            private final int type;

            private TwoItem(Object value, int type) {
                this.value = value;
                this.type = type;
            }

            @JsonValue
            public Object get() {
                return this.value;
            }

            public <T> T visit(Visitor<T> visitor) {
                if (this.type == 0) {
                    return visitor.visit((String)this.value);
                }
                if (this.type == 1) {
                    return visitor.visit((Integer)this.value);
                }
                throw new IllegalStateException("Failed to visit value. This should never happen.");
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                return other instanceof TwoItem && this.equalTo((TwoItem)other);
            }

            private boolean equalTo(TwoItem other) {
                return this.value.equals(other.value);
            }

            public int hashCode() {
                return Objects.hash(this.value);
            }

            public String toString() {
                return this.value.toString();
            }

            public static TwoItem of(String value) {
                return new TwoItem(value, 0);
            }

            public static TwoItem of(int value) {
                return new TwoItem(value, 1);
            }

            static final class Deserializer
            extends StdDeserializer<TwoItem> {
                Deserializer() {
                    super(TwoItem.class);
                }

                public TwoItem deserialize(JsonParser p, DeserializationContext context) throws IOException {
                    Object value = p.readValueAs(Object.class);
                    try {
                        return TwoItem.of((String)ObjectMappers.JSON_MAPPER.convertValue(value, String.class));
                    }
                    catch (RuntimeException runtimeException) {
                        if (value instanceof Integer) {
                            return TwoItem.of((Integer)value);
                        }
                        throw new JsonParseException(p, "Failed to deserialize");
                    }
                }
            }

            public static interface Visitor<T> {
                public T visit(String var1);

                public T visit(int var1);
            }
        }

        static final class Deserializer
        extends StdDeserializer<Value> {
            Deserializer() {
                super(Value.class);
            }

            public Value deserialize(JsonParser p, DeserializationContext context) throws IOException {
                Object value = p.readValueAs(Object.class);
                try {
                    return Value.of((String)ObjectMappers.JSON_MAPPER.convertValue(value, String.class));
                }
                catch (RuntimeException runtimeException) {
                    if (value instanceof Integer) {
                        return Value.of((Integer)value);
                    }
                    try {
                        return Value.of((List)ObjectMappers.JSON_MAPPER.convertValue(value, (TypeReference)new TypeReference<List<TwoItem>>(){}));
                    }
                    catch (RuntimeException runtimeException2) {
                        throw new JsonParseException(p, "Failed to deserialize");
                    }
                }
            }
        }

        public static interface Visitor<T> {
            public T visit(String var1);

            public T visit(int var1);

            public T visit(List<TwoItem> var1);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> field = Optional.empty();
        private Optional<Operator> operator = Optional.empty();
        private Optional<Value> value = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SingleFilterSearchRequest other) {
            this.field(other.getField());
            this.operator(other.getOperator());
            this.value(other.getValue());
            return this;
        }

        @JsonSetter(value="field", nulls=Nulls.SKIP)
        public Builder field(Optional<String> field) {
            this.field = field;
            return this;
        }

        public Builder field(String field) {
            this.field = Optional.ofNullable(field);
            return this;
        }

        @JsonSetter(value="operator", nulls=Nulls.SKIP)
        public Builder operator(Optional<Operator> operator) {
            this.operator = operator;
            return this;
        }

        public Builder operator(Operator operator) {
            this.operator = Optional.ofNullable(operator);
            return this;
        }

        @JsonSetter(value="value", nulls=Nulls.SKIP)
        public Builder value(Optional<Value> value) {
            this.value = value;
            return this;
        }

        public Builder value(Value value) {
            this.value = Optional.ofNullable(value);
            return this;
        }

        public SingleFilterSearchRequest build() {
            return new SingleFilterSearchRequest(this.field, this.operator, this.value, this.additionalProperties);
        }
    }
}

