/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.ConversationPart;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConversationParts {
    private final Optional<String> type;
    private final Optional<List<ConversationPart>> conversationParts;
    private final Optional<Integer> totalCount;
    private final Map<String, Object> additionalProperties;

    private ConversationParts(Optional<String> type, Optional<List<ConversationPart>> conversationParts, Optional<Integer> totalCount, Map<String, Object> additionalProperties) {
        this.type = type;
        this.conversationParts = conversationParts;
        this.totalCount = totalCount;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="conversation_parts")
    public Optional<List<ConversationPart>> getConversationParts() {
        return this.conversationParts;
    }

    @JsonProperty(value="total_count")
    public Optional<Integer> getTotalCount() {
        return this.totalCount;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConversationParts && this.equalTo((ConversationParts)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationParts other) {
        return this.type.equals(other.type) && this.conversationParts.equals(other.conversationParts) && this.totalCount.equals(other.totalCount);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.conversationParts, this.totalCount);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<List<ConversationPart>> conversationParts = Optional.empty();
        private Optional<Integer> totalCount = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ConversationParts other) {
            this.type(other.getType());
            this.conversationParts(other.getConversationParts());
            this.totalCount(other.getTotalCount());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="conversation_parts", nulls=Nulls.SKIP)
        public Builder conversationParts(Optional<List<ConversationPart>> conversationParts) {
            this.conversationParts = conversationParts;
            return this;
        }

        public Builder conversationParts(List<ConversationPart> conversationParts) {
            this.conversationParts = Optional.ofNullable(conversationParts);
            return this;
        }

        @JsonSetter(value="total_count", nulls=Nulls.SKIP)
        public Builder totalCount(Optional<Integer> totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public Builder totalCount(Integer totalCount) {
            this.totalCount = Optional.ofNullable(totalCount);
            return this;
        }

        public ConversationParts build() {
            return new ConversationParts(this.type, this.conversationParts, this.totalCount, this.additionalProperties);
        }
    }
}

