/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.helpcenter.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = HelpCenter.Builder.class)
public final class HelpCenter {
    private final String id;

    private final String workspaceId;

    private final int createdAt;

    private final int updatedAt;

    private final String identifier;

    private final Optional<Boolean> websiteTurnedOn;

    private final Optional<String> displayName;

    private final Optional<String> url;

    private final Optional<String> customDomain;

    private final Map<String, Object> additionalProperties;

    private HelpCenter(
            String id,
            String workspaceId,
            int createdAt,
            int updatedAt,
            String identifier,
            Optional<Boolean> websiteTurnedOn,
            Optional<String> displayName,
            Optional<String> url,
            Optional<String> customDomain,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.workspaceId = workspaceId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.identifier = identifier;
        this.websiteTurnedOn = websiteTurnedOn;
        this.displayName = displayName;
        this.url = url;
        this.customDomain = customDomain;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the Help Center which is given by Intercom.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The id of the workspace which the Help Center belongs to.
     */
    @JsonProperty("workspace_id")
    public String getWorkspaceId() {
        return workspaceId;
    }

    /**
     * @return The time when the Help Center was created.
     */
    @JsonProperty("created_at")
    public int getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The time when the Help Center was last updated.
     */
    @JsonProperty("updated_at")
    public int getUpdatedAt() {
        return updatedAt;
    }

    /**
     * @return The identifier of the Help Center. This is used in the URL of the Help Center.
     */
    @JsonProperty("identifier")
    public String getIdentifier() {
        return identifier;
    }

    /**
     * @return Whether the Help Center is turned on or not. This is controlled in your Help Center settings.
     */
    @JsonProperty("website_turned_on")
    public Optional<Boolean> getWebsiteTurnedOn() {
        return websiteTurnedOn;
    }

    /**
     * @return The display name of the Help Center only seen by teammates.
     */
    @JsonProperty("display_name")
    public Optional<String> getDisplayName() {
        return displayName;
    }

    /**
     * @return The URL for the help center, if you have a custom domain then this will show the URL using the custom domain.
     */
    @JsonProperty("url")
    public Optional<String> getUrl() {
        return url;
    }

    /**
     * @return Custom domain configured for the help center
     */
    @JsonProperty("custom_domain")
    public Optional<String> getCustomDomain() {
        return customDomain;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof HelpCenter && equalTo((HelpCenter) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(HelpCenter other) {
        return id.equals(other.id)
                && workspaceId.equals(other.workspaceId)
                && createdAt == other.createdAt
                && updatedAt == other.updatedAt
                && identifier.equals(other.identifier)
                && websiteTurnedOn.equals(other.websiteTurnedOn)
                && displayName.equals(other.displayName)
                && url.equals(other.url)
                && customDomain.equals(other.customDomain);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.id,
                this.workspaceId,
                this.createdAt,
                this.updatedAt,
                this.identifier,
                this.websiteTurnedOn,
                this.displayName,
                this.url,
                this.customDomain);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * <p>The unique identifier for the Help Center which is given by Intercom.</p>
         */
        WorkspaceIdStage id(@NotNull String id);

        Builder from(HelpCenter other);
    }

    public interface WorkspaceIdStage {
        /**
         * <p>The id of the workspace which the Help Center belongs to.</p>
         */
        CreatedAtStage workspaceId(@NotNull String workspaceId);
    }

    public interface CreatedAtStage {
        /**
         * <p>The time when the Help Center was created.</p>
         */
        UpdatedAtStage createdAt(int createdAt);
    }

    public interface UpdatedAtStage {
        /**
         * <p>The time when the Help Center was last updated.</p>
         */
        IdentifierStage updatedAt(int updatedAt);
    }

    public interface IdentifierStage {
        /**
         * <p>The identifier of the Help Center. This is used in the URL of the Help Center.</p>
         */
        _FinalStage identifier(@NotNull String identifier);
    }

    public interface _FinalStage {
        HelpCenter build();

        /**
         * <p>Whether the Help Center is turned on or not. This is controlled in your Help Center settings.</p>
         */
        _FinalStage websiteTurnedOn(Optional<Boolean> websiteTurnedOn);

        _FinalStage websiteTurnedOn(Boolean websiteTurnedOn);

        /**
         * <p>The display name of the Help Center only seen by teammates.</p>
         */
        _FinalStage displayName(Optional<String> displayName);

        _FinalStage displayName(String displayName);

        /**
         * <p>The URL for the help center, if you have a custom domain then this will show the URL using the custom domain.</p>
         */
        _FinalStage url(Optional<String> url);

        _FinalStage url(String url);

        /**
         * <p>Custom domain configured for the help center</p>
         */
        _FinalStage customDomain(Optional<String> customDomain);

        _FinalStage customDomain(String customDomain);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements IdStage, WorkspaceIdStage, CreatedAtStage, UpdatedAtStage, IdentifierStage, _FinalStage {
        private String id;

        private String workspaceId;

        private int createdAt;

        private int updatedAt;

        private String identifier;

        private Optional<String> customDomain = Optional.empty();

        private Optional<String> url = Optional.empty();

        private Optional<String> displayName = Optional.empty();

        private Optional<Boolean> websiteTurnedOn = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(HelpCenter other) {
            id(other.getId());
            workspaceId(other.getWorkspaceId());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            identifier(other.getIdentifier());
            websiteTurnedOn(other.getWebsiteTurnedOn());
            displayName(other.getDisplayName());
            url(other.getUrl());
            customDomain(other.getCustomDomain());
            return this;
        }

        /**
         * <p>The unique identifier for the Help Center which is given by Intercom.</p>
         * <p>The unique identifier for the Help Center which is given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public WorkspaceIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * <p>The id of the workspace which the Help Center belongs to.</p>
         * <p>The id of the workspace which the Help Center belongs to.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("workspace_id")
        public CreatedAtStage workspaceId(@NotNull String workspaceId) {
            this.workspaceId = Objects.requireNonNull(workspaceId, "workspaceId must not be null");
            return this;
        }

        /**
         * <p>The time when the Help Center was created.</p>
         * <p>The time when the Help Center was created.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_at")
        public UpdatedAtStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        /**
         * <p>The time when the Help Center was last updated.</p>
         * <p>The time when the Help Center was last updated.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("updated_at")
        public IdentifierStage updatedAt(int updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        /**
         * <p>The identifier of the Help Center. This is used in the URL of the Help Center.</p>
         * <p>The identifier of the Help Center. This is used in the URL of the Help Center.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("identifier")
        public _FinalStage identifier(@NotNull String identifier) {
            this.identifier = Objects.requireNonNull(identifier, "identifier must not be null");
            return this;
        }

        /**
         * <p>Custom domain configured for the help center</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage customDomain(String customDomain) {
            this.customDomain = Optional.ofNullable(customDomain);
            return this;
        }

        /**
         * <p>Custom domain configured for the help center</p>
         */
        @java.lang.Override
        @JsonSetter(value = "custom_domain", nulls = Nulls.SKIP)
        public _FinalStage customDomain(Optional<String> customDomain) {
            this.customDomain = customDomain;
            return this;
        }

        /**
         * <p>The URL for the help center, if you have a custom domain then this will show the URL using the custom domain.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        /**
         * <p>The URL for the help center, if you have a custom domain then this will show the URL using the custom domain.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "url", nulls = Nulls.SKIP)
        public _FinalStage url(Optional<String> url) {
            this.url = url;
            return this;
        }

        /**
         * <p>The display name of the Help Center only seen by teammates.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage displayName(String displayName) {
            this.displayName = Optional.ofNullable(displayName);
            return this;
        }

        /**
         * <p>The display name of the Help Center only seen by teammates.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "display_name", nulls = Nulls.SKIP)
        public _FinalStage displayName(Optional<String> displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * <p>Whether the Help Center is turned on or not. This is controlled in your Help Center settings.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage websiteTurnedOn(Boolean websiteTurnedOn) {
            this.websiteTurnedOn = Optional.ofNullable(websiteTurnedOn);
            return this;
        }

        /**
         * <p>Whether the Help Center is turned on or not. This is controlled in your Help Center settings.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "website_turned_on", nulls = Nulls.SKIP)
        public _FinalStage websiteTurnedOn(Optional<Boolean> websiteTurnedOn) {
            this.websiteTurnedOn = websiteTurnedOn;
            return this;
        }

        @java.lang.Override
        public HelpCenter build() {
            return new HelpCenter(
                    id,
                    workspaceId,
                    createdAt,
                    updatedAt,
                    identifier,
                    websiteTurnedOn,
                    displayName,
                    url,
                    customDomain,
                    additionalProperties);
        }
    }
}
