/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.news.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = NewsItem.Builder.class)
public final class NewsItem {
    private final String id;

    private final String workspaceId;

    private final String title;

    private final Optional<String> body;

    private final Optional<Integer> senderId;

    private final State state;

    private final Optional<List<NewsfeedAssignment>> newsfeedAssignments;

    private final Optional<List<Optional<String>>> labels;

    private final Optional<String> coverImageUrl;

    private final Optional<List<Optional<String>>> reactions;

    private final Optional<Boolean> deliverSilently;

    private final int createdAt;

    private final int updatedAt;

    private final Map<String, Object> additionalProperties;

    private NewsItem(
            String id,
            String workspaceId,
            String title,
            Optional<String> body,
            Optional<Integer> senderId,
            State state,
            Optional<List<NewsfeedAssignment>> newsfeedAssignments,
            Optional<List<Optional<String>>> labels,
            Optional<String> coverImageUrl,
            Optional<List<Optional<String>>> reactions,
            Optional<Boolean> deliverSilently,
            int createdAt,
            int updatedAt,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.workspaceId = workspaceId;
        this.title = title;
        this.body = body;
        this.senderId = senderId;
        this.state = state;
        this.newsfeedAssignments = newsfeedAssignments;
        this.labels = labels;
        this.coverImageUrl = coverImageUrl;
        this.reactions = reactions;
        this.deliverSilently = deliverSilently;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of object.
     */
    @JsonProperty("type")
    public String getType() {
        return "news-item";
    }

    /**
     * @return The unique identifier for the news item which is given by Intercom.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The id of the workspace which the news item belongs to.
     */
    @JsonProperty("workspace_id")
    public String getWorkspaceId() {
        return workspaceId;
    }

    /**
     * @return The title of the news item.
     */
    @JsonProperty("title")
    public String getTitle() {
        return title;
    }

    /**
     * @return The news item body, which may contain HTML.
     */
    @JsonProperty("body")
    public Optional<String> getBody() {
        return body;
    }

    /**
     * @return The id of the sender of the news item. Must be a teammate on the workspace.
     */
    @JsonProperty("sender_id")
    public Optional<Integer> getSenderId() {
        return senderId;
    }

    /**
     * @return News items will not be visible to your users in the assigned newsfeeds until they are set live.
     */
    @JsonProperty("state")
    public State getState() {
        return state;
    }

    /**
     * @return A list of newsfeed_assignments to assign to the specified newsfeed.
     */
    @JsonProperty("newsfeed_assignments")
    public Optional<List<NewsfeedAssignment>> getNewsfeedAssignments() {
        return newsfeedAssignments;
    }

    /**
     * @return Label names displayed to users to categorize the news item.
     */
    @JsonProperty("labels")
    public Optional<List<Optional<String>>> getLabels() {
        return labels;
    }

    /**
     * @return URL of the image used as cover. Must have .jpg or .png extension.
     */
    @JsonProperty("cover_image_url")
    public Optional<String> getCoverImageUrl() {
        return coverImageUrl;
    }

    /**
     * @return Ordered list of emoji reactions to the news item. When empty, reactions are disabled.
     */
    @JsonProperty("reactions")
    public Optional<List<Optional<String>>> getReactions() {
        return reactions;
    }

    /**
     * @return When set to true, the news item will appear in the messenger newsfeed without showing a notification badge.
     */
    @JsonProperty("deliver_silently")
    public Optional<Boolean> getDeliverSilently() {
        return deliverSilently;
    }

    /**
     * @return Timestamp for when the news item was created.
     */
    @JsonProperty("created_at")
    public int getCreatedAt() {
        return createdAt;
    }

    /**
     * @return Timestamp for when the news item was last updated.
     */
    @JsonProperty("updated_at")
    public int getUpdatedAt() {
        return updatedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof NewsItem && equalTo((NewsItem) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(NewsItem other) {
        return id.equals(other.id)
                && workspaceId.equals(other.workspaceId)
                && title.equals(other.title)
                && body.equals(other.body)
                && senderId.equals(other.senderId)
                && state.equals(other.state)
                && newsfeedAssignments.equals(other.newsfeedAssignments)
                && labels.equals(other.labels)
                && coverImageUrl.equals(other.coverImageUrl)
                && reactions.equals(other.reactions)
                && deliverSilently.equals(other.deliverSilently)
                && createdAt == other.createdAt
                && updatedAt == other.updatedAt;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.id,
                this.workspaceId,
                this.title,
                this.body,
                this.senderId,
                this.state,
                this.newsfeedAssignments,
                this.labels,
                this.coverImageUrl,
                this.reactions,
                this.deliverSilently,
                this.createdAt,
                this.updatedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * <p>The unique identifier for the news item which is given by Intercom.</p>
         */
        WorkspaceIdStage id(@NotNull String id);

        Builder from(NewsItem other);
    }

    public interface WorkspaceIdStage {
        /**
         * <p>The id of the workspace which the news item belongs to.</p>
         */
        TitleStage workspaceId(@NotNull String workspaceId);
    }

    public interface TitleStage {
        /**
         * <p>The title of the news item.</p>
         */
        StateStage title(@NotNull String title);
    }

    public interface StateStage {
        /**
         * <p>News items will not be visible to your users in the assigned newsfeeds until they are set live.</p>
         */
        CreatedAtStage state(@NotNull State state);
    }

    public interface CreatedAtStage {
        /**
         * <p>Timestamp for when the news item was created.</p>
         */
        UpdatedAtStage createdAt(int createdAt);
    }

    public interface UpdatedAtStage {
        /**
         * <p>Timestamp for when the news item was last updated.</p>
         */
        _FinalStage updatedAt(int updatedAt);
    }

    public interface _FinalStage {
        NewsItem build();

        /**
         * <p>The news item body, which may contain HTML.</p>
         */
        _FinalStage body(Optional<String> body);

        _FinalStage body(String body);

        /**
         * <p>The id of the sender of the news item. Must be a teammate on the workspace.</p>
         */
        _FinalStage senderId(Optional<Integer> senderId);

        _FinalStage senderId(Integer senderId);

        /**
         * <p>A list of newsfeed_assignments to assign to the specified newsfeed.</p>
         */
        _FinalStage newsfeedAssignments(Optional<List<NewsfeedAssignment>> newsfeedAssignments);

        _FinalStage newsfeedAssignments(List<NewsfeedAssignment> newsfeedAssignments);

        /**
         * <p>Label names displayed to users to categorize the news item.</p>
         */
        _FinalStage labels(Optional<List<Optional<String>>> labels);

        _FinalStage labels(List<Optional<String>> labels);

        /**
         * <p>URL of the image used as cover. Must have .jpg or .png extension.</p>
         */
        _FinalStage coverImageUrl(Optional<String> coverImageUrl);

        _FinalStage coverImageUrl(String coverImageUrl);

        /**
         * <p>Ordered list of emoji reactions to the news item. When empty, reactions are disabled.</p>
         */
        _FinalStage reactions(Optional<List<Optional<String>>> reactions);

        _FinalStage reactions(List<Optional<String>> reactions);

        /**
         * <p>When set to true, the news item will appear in the messenger newsfeed without showing a notification badge.</p>
         */
        _FinalStage deliverSilently(Optional<Boolean> deliverSilently);

        _FinalStage deliverSilently(Boolean deliverSilently);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements IdStage, WorkspaceIdStage, TitleStage, StateStage, CreatedAtStage, UpdatedAtStage, _FinalStage {
        private String id;

        private String workspaceId;

        private String title;

        private State state;

        private int createdAt;

        private int updatedAt;

        private Optional<Boolean> deliverSilently = Optional.empty();

        private Optional<List<Optional<String>>> reactions = Optional.empty();

        private Optional<String> coverImageUrl = Optional.empty();

        private Optional<List<Optional<String>>> labels = Optional.empty();

        private Optional<List<NewsfeedAssignment>> newsfeedAssignments = Optional.empty();

        private Optional<Integer> senderId = Optional.empty();

        private Optional<String> body = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(NewsItem other) {
            id(other.getId());
            workspaceId(other.getWorkspaceId());
            title(other.getTitle());
            body(other.getBody());
            senderId(other.getSenderId());
            state(other.getState());
            newsfeedAssignments(other.getNewsfeedAssignments());
            labels(other.getLabels());
            coverImageUrl(other.getCoverImageUrl());
            reactions(other.getReactions());
            deliverSilently(other.getDeliverSilently());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            return this;
        }

        /**
         * <p>The unique identifier for the news item which is given by Intercom.</p>
         * <p>The unique identifier for the news item which is given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public WorkspaceIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * <p>The id of the workspace which the news item belongs to.</p>
         * <p>The id of the workspace which the news item belongs to.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("workspace_id")
        public TitleStage workspaceId(@NotNull String workspaceId) {
            this.workspaceId = Objects.requireNonNull(workspaceId, "workspaceId must not be null");
            return this;
        }

        /**
         * <p>The title of the news item.</p>
         * <p>The title of the news item.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("title")
        public StateStage title(@NotNull String title) {
            this.title = Objects.requireNonNull(title, "title must not be null");
            return this;
        }

        /**
         * <p>News items will not be visible to your users in the assigned newsfeeds until they are set live.</p>
         * <p>News items will not be visible to your users in the assigned newsfeeds until they are set live.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("state")
        public CreatedAtStage state(@NotNull State state) {
            this.state = Objects.requireNonNull(state, "state must not be null");
            return this;
        }

        /**
         * <p>Timestamp for when the news item was created.</p>
         * <p>Timestamp for when the news item was created.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_at")
        public UpdatedAtStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        /**
         * <p>Timestamp for when the news item was last updated.</p>
         * <p>Timestamp for when the news item was last updated.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("updated_at")
        public _FinalStage updatedAt(int updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        /**
         * <p>When set to true, the news item will appear in the messenger newsfeed without showing a notification badge.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage deliverSilently(Boolean deliverSilently) {
            this.deliverSilently = Optional.ofNullable(deliverSilently);
            return this;
        }

        /**
         * <p>When set to true, the news item will appear in the messenger newsfeed without showing a notification badge.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "deliver_silently", nulls = Nulls.SKIP)
        public _FinalStage deliverSilently(Optional<Boolean> deliverSilently) {
            this.deliverSilently = deliverSilently;
            return this;
        }

        /**
         * <p>Ordered list of emoji reactions to the news item. When empty, reactions are disabled.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage reactions(List<Optional<String>> reactions) {
            this.reactions = Optional.ofNullable(reactions);
            return this;
        }

        /**
         * <p>Ordered list of emoji reactions to the news item. When empty, reactions are disabled.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "reactions", nulls = Nulls.SKIP)
        public _FinalStage reactions(Optional<List<Optional<String>>> reactions) {
            this.reactions = reactions;
            return this;
        }

        /**
         * <p>URL of the image used as cover. Must have .jpg or .png extension.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage coverImageUrl(String coverImageUrl) {
            this.coverImageUrl = Optional.ofNullable(coverImageUrl);
            return this;
        }

        /**
         * <p>URL of the image used as cover. Must have .jpg or .png extension.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "cover_image_url", nulls = Nulls.SKIP)
        public _FinalStage coverImageUrl(Optional<String> coverImageUrl) {
            this.coverImageUrl = coverImageUrl;
            return this;
        }

        /**
         * <p>Label names displayed to users to categorize the news item.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage labels(List<Optional<String>> labels) {
            this.labels = Optional.ofNullable(labels);
            return this;
        }

        /**
         * <p>Label names displayed to users to categorize the news item.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "labels", nulls = Nulls.SKIP)
        public _FinalStage labels(Optional<List<Optional<String>>> labels) {
            this.labels = labels;
            return this;
        }

        /**
         * <p>A list of newsfeed_assignments to assign to the specified newsfeed.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage newsfeedAssignments(List<NewsfeedAssignment> newsfeedAssignments) {
            this.newsfeedAssignments = Optional.ofNullable(newsfeedAssignments);
            return this;
        }

        /**
         * <p>A list of newsfeed_assignments to assign to the specified newsfeed.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "newsfeed_assignments", nulls = Nulls.SKIP)
        public _FinalStage newsfeedAssignments(Optional<List<NewsfeedAssignment>> newsfeedAssignments) {
            this.newsfeedAssignments = newsfeedAssignments;
            return this;
        }

        /**
         * <p>The id of the sender of the news item. Must be a teammate on the workspace.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage senderId(Integer senderId) {
            this.senderId = Optional.ofNullable(senderId);
            return this;
        }

        /**
         * <p>The id of the sender of the news item. Must be a teammate on the workspace.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "sender_id", nulls = Nulls.SKIP)
        public _FinalStage senderId(Optional<Integer> senderId) {
            this.senderId = senderId;
            return this;
        }

        /**
         * <p>The news item body, which may contain HTML.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        /**
         * <p>The news item body, which may contain HTML.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "body", nulls = Nulls.SKIP)
        public _FinalStage body(Optional<String> body) {
            this.body = body;
            return this;
        }

        @java.lang.Override
        public NewsItem build() {
            return new NewsItem(
                    id,
                    workspaceId,
                    title,
                    body,
                    senderId,
                    state,
                    newsfeedAssignments,
                    labels,
                    coverImageUrl,
                    reactions,
                    deliverSilently,
                    createdAt,
                    updatedAt,
                    additionalProperties);
        }
    }

    public static final class State {
        public static final State LIVE = new State(Value.LIVE, "live");

        public static final State DRAFT = new State(Value.DRAFT, "draft");

        private final Value value;

        private final String string;

        State(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof State && this.string.equals(((State) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case LIVE:
                    return visitor.visitLive();
                case DRAFT:
                    return visitor.visitDraft();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static State valueOf(String value) {
            switch (value) {
                case "live":
                    return LIVE;
                case "draft":
                    return DRAFT;
                default:
                    return new State(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            DRAFT,

            LIVE,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitDraft();

            T visitLive();

            T visitUnknown(String unknownType);
        }
    }
}
