/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.teams.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.AdminPriorityLevel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Team.Builder.class)
public final class Team {
    private final String type;

    private final String id;

    private final String name;

    private final List<Integer> adminIds;

    private final Optional<AdminPriorityLevel> adminPriorityLevel;

    private final Optional<Integer> assignmentLimit;

    private final Optional<String> distributionMethod;

    private final Map<String, Object> additionalProperties;

    private Team(
            String type,
            String id,
            String name,
            List<Integer> adminIds,
            Optional<AdminPriorityLevel> adminPriorityLevel,
            Optional<Integer> assignmentLimit,
            Optional<String> distributionMethod,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.adminIds = adminIds;
        this.adminPriorityLevel = adminPriorityLevel;
        this.assignmentLimit = assignmentLimit;
        this.distributionMethod = distributionMethod;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Value is always &quot;team&quot;
     */
    @JsonProperty("type")
    public String getType() {
        return type;
    }

    /**
     * @return The id of the team
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The name of the team
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * @return The list of admin IDs that are a part of the team.
     */
    @JsonProperty("admin_ids")
    public List<Integer> getAdminIds() {
        return adminIds;
    }

    @JsonProperty("admin_priority_level")
    public Optional<AdminPriorityLevel> getAdminPriorityLevel() {
        return adminPriorityLevel;
    }

    /**
     * @return The assignment limit for the team. This field is only present when the team's distribution type is load balanced.
     */
    @JsonProperty("assignment_limit")
    public Optional<Integer> getAssignmentLimit() {
        return assignmentLimit;
    }

    /**
     * @return Describes how assignments are distributed among the team members
     */
    @JsonProperty("distribution_method")
    public Optional<String> getDistributionMethod() {
        return distributionMethod;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Team && equalTo((Team) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Team other) {
        return type.equals(other.type)
                && id.equals(other.id)
                && name.equals(other.name)
                && adminIds.equals(other.adminIds)
                && adminPriorityLevel.equals(other.adminPriorityLevel)
                && assignmentLimit.equals(other.assignmentLimit)
                && distributionMethod.equals(other.distributionMethod);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.type,
                this.id,
                this.name,
                this.adminIds,
                this.adminPriorityLevel,
                this.assignmentLimit,
                this.distributionMethod);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    public interface TypeStage {
        /**
         * <p>Value is always &quot;team&quot;</p>
         */
        IdStage type(@NotNull String type);

        Builder from(Team other);
    }

    public interface IdStage {
        /**
         * <p>The id of the team</p>
         */
        NameStage id(@NotNull String id);
    }

    public interface NameStage {
        /**
         * <p>The name of the team</p>
         */
        _FinalStage name(@NotNull String name);
    }

    public interface _FinalStage {
        Team build();

        /**
         * <p>The list of admin IDs that are a part of the team.</p>
         */
        _FinalStage adminIds(List<Integer> adminIds);

        _FinalStage addAdminIds(Integer adminIds);

        _FinalStage addAllAdminIds(List<Integer> adminIds);

        _FinalStage adminPriorityLevel(Optional<AdminPriorityLevel> adminPriorityLevel);

        _FinalStage adminPriorityLevel(AdminPriorityLevel adminPriorityLevel);

        /**
         * <p>The assignment limit for the team. This field is only present when the team's distribution type is load balanced.</p>
         */
        _FinalStage assignmentLimit(Optional<Integer> assignmentLimit);

        _FinalStage assignmentLimit(Integer assignmentLimit);

        /**
         * <p>Describes how assignments are distributed among the team members</p>
         */
        _FinalStage distributionMethod(Optional<String> distributionMethod);

        _FinalStage distributionMethod(String distributionMethod);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TypeStage, IdStage, NameStage, _FinalStage {
        private String type;

        private String id;

        private String name;

        private Optional<String> distributionMethod = Optional.empty();

        private Optional<Integer> assignmentLimit = Optional.empty();

        private Optional<AdminPriorityLevel> adminPriorityLevel = Optional.empty();

        private List<Integer> adminIds = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(Team other) {
            type(other.getType());
            id(other.getId());
            name(other.getName());
            adminIds(other.getAdminIds());
            adminPriorityLevel(other.getAdminPriorityLevel());
            assignmentLimit(other.getAssignmentLimit());
            distributionMethod(other.getDistributionMethod());
            return this;
        }

        /**
         * <p>Value is always &quot;team&quot;</p>
         * <p>Value is always &quot;team&quot;</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("type")
        public IdStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        /**
         * <p>The id of the team</p>
         * <p>The id of the team</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * <p>The name of the team</p>
         * <p>The name of the team</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        /**
         * <p>Describes how assignments are distributed among the team members</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage distributionMethod(String distributionMethod) {
            this.distributionMethod = Optional.ofNullable(distributionMethod);
            return this;
        }

        /**
         * <p>Describes how assignments are distributed among the team members</p>
         */
        @java.lang.Override
        @JsonSetter(value = "distribution_method", nulls = Nulls.SKIP)
        public _FinalStage distributionMethod(Optional<String> distributionMethod) {
            this.distributionMethod = distributionMethod;
            return this;
        }

        /**
         * <p>The assignment limit for the team. This field is only present when the team's distribution type is load balanced.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage assignmentLimit(Integer assignmentLimit) {
            this.assignmentLimit = Optional.ofNullable(assignmentLimit);
            return this;
        }

        /**
         * <p>The assignment limit for the team. This field is only present when the team's distribution type is load balanced.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "assignment_limit", nulls = Nulls.SKIP)
        public _FinalStage assignmentLimit(Optional<Integer> assignmentLimit) {
            this.assignmentLimit = assignmentLimit;
            return this;
        }

        @java.lang.Override
        public _FinalStage adminPriorityLevel(AdminPriorityLevel adminPriorityLevel) {
            this.adminPriorityLevel = Optional.ofNullable(adminPriorityLevel);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "admin_priority_level", nulls = Nulls.SKIP)
        public _FinalStage adminPriorityLevel(Optional<AdminPriorityLevel> adminPriorityLevel) {
            this.adminPriorityLevel = adminPriorityLevel;
            return this;
        }

        /**
         * <p>The list of admin IDs that are a part of the team.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addAllAdminIds(List<Integer> adminIds) {
            if (adminIds != null) {
                this.adminIds.addAll(adminIds);
            }
            return this;
        }

        /**
         * <p>The list of admin IDs that are a part of the team.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addAdminIds(Integer adminIds) {
            this.adminIds.add(adminIds);
            return this;
        }

        /**
         * <p>The list of admin IDs that are a part of the team.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "admin_ids", nulls = Nulls.SKIP)
        public _FinalStage adminIds(List<Integer> adminIds) {
            this.adminIds.clear();
            if (adminIds != null) {
                this.adminIds.addAll(adminIds);
            }
            return this;
        }

        @java.lang.Override
        public Team build() {
            return new Team(
                    type,
                    id,
                    name,
                    adminIds,
                    adminPriorityLevel,
                    assignmentLimit,
                    distributionMethod,
                    additionalProperties);
        }
    }
}
