/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.dataevents.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DataEvent.Builder.class)
public final class DataEvent {
    private final Optional<String> type;

    private final String eventName;

    private final int createdAt;

    private final Optional<String> userId;

    private final Optional<String> id;

    private final Optional<String> intercomUserId;

    private final Optional<String> email;

    private final Optional<Map<String, String>> metadata;

    private final Map<String, Object> additionalProperties;

    private DataEvent(
            Optional<String> type,
            String eventName,
            int createdAt,
            Optional<String> userId,
            Optional<String> id,
            Optional<String> intercomUserId,
            Optional<String> email,
            Optional<Map<String, String>> metadata,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.eventName = eventName;
        this.createdAt = createdAt;
        this.userId = userId;
        this.id = id;
        this.intercomUserId = intercomUserId;
        this.email = email;
        this.metadata = metadata;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of the object
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The name of the event that occurred. This is presented to your App's admins when filtering and creating segments - a good event name is typically a past tense 'verb-noun' combination, to improve readability, for example <code>updated-plan</code>.
     */
    @JsonProperty("event_name")
    public String getEventName() {
        return eventName;
    }

    /**
     * @return The time the event occurred as a UTC Unix timestamp
     */
    @JsonProperty("created_at")
    public int getCreatedAt() {
        return createdAt;
    }

    /**
     * @return Your identifier for the user.
     */
    @JsonProperty("user_id")
    public Optional<String> getUserId() {
        return userId;
    }

    /**
     * @return Your identifier for a lead or a user.
     */
    @JsonProperty("id")
    public Optional<String> getId() {
        return id;
    }

    /**
     * @return The Intercom identifier for the user.
     */
    @JsonProperty("intercom_user_id")
    public Optional<String> getIntercomUserId() {
        return intercomUserId;
    }

    /**
     * @return An email address for your user. An email should only be used where your application uses email to uniquely identify users.
     */
    @JsonProperty("email")
    public Optional<String> getEmail() {
        return email;
    }

    /**
     * @return Optional metadata about the event.
     */
    @JsonProperty("metadata")
    public Optional<Map<String, String>> getMetadata() {
        return metadata;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DataEvent && equalTo((DataEvent) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DataEvent other) {
        return type.equals(other.type)
                && eventName.equals(other.eventName)
                && createdAt == other.createdAt
                && userId.equals(other.userId)
                && id.equals(other.id)
                && intercomUserId.equals(other.intercomUserId)
                && email.equals(other.email)
                && metadata.equals(other.metadata);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.type,
                this.eventName,
                this.createdAt,
                this.userId,
                this.id,
                this.intercomUserId,
                this.email,
                this.metadata);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static EventNameStage builder() {
        return new Builder();
    }

    public interface EventNameStage {
        /**
         * <p>The name of the event that occurred. This is presented to your App's admins when filtering and creating segments - a good event name is typically a past tense 'verb-noun' combination, to improve readability, for example <code>updated-plan</code>.</p>
         */
        CreatedAtStage eventName(@NotNull String eventName);

        Builder from(DataEvent other);
    }

    public interface CreatedAtStage {
        /**
         * <p>The time the event occurred as a UTC Unix timestamp</p>
         */
        _FinalStage createdAt(int createdAt);
    }

    public interface _FinalStage {
        DataEvent build();

        /**
         * <p>The type of the object</p>
         */
        _FinalStage type(Optional<String> type);

        _FinalStage type(String type);

        /**
         * <p>Your identifier for the user.</p>
         */
        _FinalStage userId(Optional<String> userId);

        _FinalStage userId(String userId);

        /**
         * <p>Your identifier for a lead or a user.</p>
         */
        _FinalStage id(Optional<String> id);

        _FinalStage id(String id);

        /**
         * <p>The Intercom identifier for the user.</p>
         */
        _FinalStage intercomUserId(Optional<String> intercomUserId);

        _FinalStage intercomUserId(String intercomUserId);

        /**
         * <p>An email address for your user. An email should only be used where your application uses email to uniquely identify users.</p>
         */
        _FinalStage email(Optional<String> email);

        _FinalStage email(String email);

        /**
         * <p>Optional metadata about the event.</p>
         */
        _FinalStage metadata(Optional<Map<String, String>> metadata);

        _FinalStage metadata(Map<String, String> metadata);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements EventNameStage, CreatedAtStage, _FinalStage {
        private String eventName;

        private int createdAt;

        private Optional<Map<String, String>> metadata = Optional.empty();

        private Optional<String> email = Optional.empty();

        private Optional<String> intercomUserId = Optional.empty();

        private Optional<String> id = Optional.empty();

        private Optional<String> userId = Optional.empty();

        private Optional<String> type = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(DataEvent other) {
            type(other.getType());
            eventName(other.getEventName());
            createdAt(other.getCreatedAt());
            userId(other.getUserId());
            id(other.getId());
            intercomUserId(other.getIntercomUserId());
            email(other.getEmail());
            metadata(other.getMetadata());
            return this;
        }

        /**
         * <p>The name of the event that occurred. This is presented to your App's admins when filtering and creating segments - a good event name is typically a past tense 'verb-noun' combination, to improve readability, for example <code>updated-plan</code>.</p>
         * <p>The name of the event that occurred. This is presented to your App's admins when filtering and creating segments - a good event name is typically a past tense 'verb-noun' combination, to improve readability, for example <code>updated-plan</code>.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("event_name")
        public CreatedAtStage eventName(@NotNull String eventName) {
            this.eventName = Objects.requireNonNull(eventName, "eventName must not be null");
            return this;
        }

        /**
         * <p>The time the event occurred as a UTC Unix timestamp</p>
         * <p>The time the event occurred as a UTC Unix timestamp</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_at")
        public _FinalStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        /**
         * <p>Optional metadata about the event.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage metadata(Map<String, String> metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        /**
         * <p>Optional metadata about the event.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "metadata", nulls = Nulls.SKIP)
        public _FinalStage metadata(Optional<Map<String, String>> metadata) {
            this.metadata = metadata;
            return this;
        }

        /**
         * <p>An email address for your user. An email should only be used where your application uses email to uniquely identify users.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        /**
         * <p>An email address for your user. An email should only be used where your application uses email to uniquely identify users.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "email", nulls = Nulls.SKIP)
        public _FinalStage email(Optional<String> email) {
            this.email = email;
            return this;
        }

        /**
         * <p>The Intercom identifier for the user.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage intercomUserId(String intercomUserId) {
            this.intercomUserId = Optional.ofNullable(intercomUserId);
            return this;
        }

        /**
         * <p>The Intercom identifier for the user.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "intercom_user_id", nulls = Nulls.SKIP)
        public _FinalStage intercomUserId(Optional<String> intercomUserId) {
            this.intercomUserId = intercomUserId;
            return this;
        }

        /**
         * <p>Your identifier for a lead or a user.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>Your identifier for a lead or a user.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        /**
         * <p>Your identifier for the user.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage userId(String userId) {
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        /**
         * <p>Your identifier for the user.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "user_id", nulls = Nulls.SKIP)
        public _FinalStage userId(Optional<String> userId) {
            this.userId = userId;
            return this;
        }

        /**
         * <p>The type of the object</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The type of the object</p>
         */
        @java.lang.Override
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public _FinalStage type(Optional<String> type) {
            this.type = type;
            return this;
        }

        @java.lang.Override
        public DataEvent build() {
            return new DataEvent(
                    type, eventName, createdAt, userId, id, intercomUserId, email, metadata, additionalProperties);
        }
    }
}
