/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.dataexport;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.IntercomApiException;
import com.intercom.api.core.IntercomException;
import com.intercom.api.core.IntercomHttpResponse;
import com.intercom.api.core.MediaTypes;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.dataexport.requests.CancelDataExportRequest;
import com.intercom.api.resources.unstable.dataexport.requests.CreateDataExportsRequest;
import com.intercom.api.resources.unstable.dataexport.requests.DownloadDataExportRequest;
import com.intercom.api.resources.unstable.dataexport.requests.GetDataExportRequest;
import com.intercom.api.resources.unstable.dataexport.types.DataExport;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawDataExportClient {
    protected final ClientOptions clientOptions;

    public AsyncRawDataExportClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    /**
     * To create your export job, you need to send a <code>POST</code> request to the export endpoint <code>https://api.intercom.io/export/content/data</code>.
     * <p>The only parameters you need to provide are the range of dates that you want exported.</p>
     * <blockquote>
     * <p>🚧 Limit of one active job</p>
     * <p>You can only have one active job per workspace. You will receive a HTTP status code of 429 with the message Exceeded rate limit of 1 pending message data export jobs if you attempt to create a second concurrent job.</p>
     * </blockquote>
     * <blockquote>
     * <p>❗️ Updated_at not included</p>
     * <p>It should be noted that the timeframe only includes messages sent during the time period and not messages that were only updated during this period. For example, if a message was updated yesterday but sent two days ago, you would need to set the created_at_after date before the message was sent to include that in your retrieval job.</p>
     * </blockquote>
     * <blockquote>
     * <p>📘 Date ranges are inclusive</p>
     * <p>Requesting data for 2018-06-01 until 2018-06-30 will get all data for those days including those specified - e.g. 2018-06-01 00:00:00 until 2018-06-30 23:59:99.</p>
     * </blockquote>
     */
    public CompletableFuture<IntercomHttpResponse<DataExport>> createDataExport(CreateDataExportsRequest request) {
        return createDataExport(request, null);
    }

    /**
     * To create your export job, you need to send a <code>POST</code> request to the export endpoint <code>https://api.intercom.io/export/content/data</code>.
     * <p>The only parameters you need to provide are the range of dates that you want exported.</p>
     * <blockquote>
     * <p>🚧 Limit of one active job</p>
     * <p>You can only have one active job per workspace. You will receive a HTTP status code of 429 with the message Exceeded rate limit of 1 pending message data export jobs if you attempt to create a second concurrent job.</p>
     * </blockquote>
     * <blockquote>
     * <p>❗️ Updated_at not included</p>
     * <p>It should be noted that the timeframe only includes messages sent during the time period and not messages that were only updated during this period. For example, if a message was updated yesterday but sent two days ago, you would need to set the created_at_after date before the message was sent to include that in your retrieval job.</p>
     * </blockquote>
     * <blockquote>
     * <p>📘 Date ranges are inclusive</p>
     * <p>Requesting data for 2018-06-01 until 2018-06-30 will get all data for those days including those specified - e.g. 2018-06-01 00:00:00 until 2018-06-30 23:59:99.</p>
     * </blockquote>
     */
    public CompletableFuture<IntercomHttpResponse<DataExport>> createDataExport(
            CreateDataExportsRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("export/content/data")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<IntercomHttpResponse<DataExport>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new IntercomHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, DataExport.class), response));
                        return;
                    }
                    Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
                    future.completeExceptionally(new IntercomApiException(
                            "Error with status code " + response.code(), response.code(), errorBody, response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * You can view the status of your job by sending a <code>GET</code> request to the URL
     * <code>https://api.intercom.io/export/content/data/{job_identifier}</code> - the <code>{job_identifier}</code> is the value returned in the response when you first created the export job. More on it can be seen in the Export Job Model.
     * <blockquote>
     * <p>🚧 Jobs expire after two days
     * All jobs that have completed processing (and are thus available to download from the provided URL) will have an expiry limit of two days from when the export ob completed. After this, the data will no longer be available.</p>
     * </blockquote>
     */
    public CompletableFuture<IntercomHttpResponse<DataExport>> getDataExport(GetDataExportRequest request) {
        return getDataExport(request, null);
    }

    /**
     * You can view the status of your job by sending a <code>GET</code> request to the URL
     * <code>https://api.intercom.io/export/content/data/{job_identifier}</code> - the <code>{job_identifier}</code> is the value returned in the response when you first created the export job. More on it can be seen in the Export Job Model.
     * <blockquote>
     * <p>🚧 Jobs expire after two days
     * All jobs that have completed processing (and are thus available to download from the provided URL) will have an expiry limit of two days from when the export ob completed. After this, the data will no longer be available.</p>
     * </blockquote>
     */
    public CompletableFuture<IntercomHttpResponse<DataExport>> getDataExport(
            GetDataExportRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("export/content/data")
                .addPathSegment(request.getJobIdentifier())
                .build();
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<IntercomHttpResponse<DataExport>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new IntercomHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, DataExport.class), response));
                        return;
                    }
                    Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
                    future.completeExceptionally(new IntercomApiException(
                            "Error with status code " + response.code(), response.code(), errorBody, response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * You can cancel your job
     */
    public CompletableFuture<IntercomHttpResponse<DataExport>> cancelDataExport(CancelDataExportRequest request) {
        return cancelDataExport(request, null);
    }

    /**
     * You can cancel your job
     */
    public CompletableFuture<IntercomHttpResponse<DataExport>> cancelDataExport(
            CancelDataExportRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("export/cancel")
                .addPathSegment(request.getJobIdentifier())
                .build();
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl)
                .method("POST", RequestBody.create("", null))
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<IntercomHttpResponse<DataExport>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new IntercomHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, DataExport.class), response));
                        return;
                    }
                    Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
                    future.completeExceptionally(new IntercomApiException(
                            "Error with status code " + response.code(), response.code(), errorBody, response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * When a job has a status of complete, and thus a filled download_url, you can download your data by hitting that provided URL, formatted like so: https://api.intercom.io/download/content/data/xyz1234.
     * <p>Your exported message data will be streamed continuously back down to you in a gzipped CSV format.</p>
     * <blockquote>
     * <p>📘 Octet header required</p>
     * <p>You will have to specify the header Accept: <code>application/octet-stream</code> when hitting this endpoint.</p>
     * </blockquote>
     */
    public CompletableFuture<IntercomHttpResponse<Void>> downloadDataExport(DownloadDataExportRequest request) {
        return downloadDataExport(request, null);
    }

    /**
     * When a job has a status of complete, and thus a filled download_url, you can download your data by hitting that provided URL, formatted like so: https://api.intercom.io/download/content/data/xyz1234.
     * <p>Your exported message data will be streamed continuously back down to you in a gzipped CSV format.</p>
     * <blockquote>
     * <p>📘 Octet header required</p>
     * <p>You will have to specify the header Accept: <code>application/octet-stream</code> when hitting this endpoint.</p>
     * </blockquote>
     */
    public CompletableFuture<IntercomHttpResponse<Void>> downloadDataExport(
            DownloadDataExportRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("download/content/data")
                .addPathSegment(request.getJobIdentifier())
                .build();
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)));
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<IntercomHttpResponse<Void>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    if (response.isSuccessful()) {
                        future.complete(new IntercomHttpResponse<>(null, response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
                    future.completeExceptionally(new IntercomApiException(
                            "Error with status code " + response.code(), response.code(), errorBody, response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
            }
        });
        return future;
    }
}
