/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CustomActionFinished.Builder.class)
public final class CustomActionFinished {
    private final Optional<Action> action;

    private final Map<String, Object> additionalProperties;

    private CustomActionFinished(Optional<Action> action, Map<String, Object> additionalProperties) {
        this.action = action;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("action")
    public Optional<Action> getAction() {
        return action;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CustomActionFinished && equalTo((CustomActionFinished) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomActionFinished other) {
        return action.equals(other.action);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.action);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<Action> action = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(CustomActionFinished other) {
            action(other.getAction());
            return this;
        }

        @JsonSetter(value = "action", nulls = Nulls.SKIP)
        public Builder action(Optional<Action> action) {
            this.action = action;
            return this;
        }

        public Builder action(Action action) {
            this.action = Optional.ofNullable(action);
            return this;
        }

        public CustomActionFinished build() {
            return new CustomActionFinished(action, additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Action.Builder.class)
    public static final class Action {
        private final Optional<String> name;

        private final Optional<Result> result;

        private final Map<String, Object> additionalProperties;

        private Action(Optional<String> name, Optional<Result> result, Map<String, Object> additionalProperties) {
            this.name = name;
            this.result = result;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return Name of the action
         */
        @JsonProperty("name")
        public Optional<String> getName() {
            return name;
        }

        /**
         * @return Status of the action
         */
        @JsonProperty("result")
        public Optional<Result> getResult() {
            return result;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Action && equalTo((Action) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Action other) {
            return name.equals(other.name) && result.equals(other.result);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.name, this.result);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> name = Optional.empty();

            private Optional<Result> result = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(Action other) {
                name(other.getName());
                result(other.getResult());
                return this;
            }

            /**
             * <p>Name of the action</p>
             */
            @JsonSetter(value = "name", nulls = Nulls.SKIP)
            public Builder name(Optional<String> name) {
                this.name = name;
                return this;
            }

            public Builder name(String name) {
                this.name = Optional.ofNullable(name);
                return this;
            }

            /**
             * <p>Status of the action</p>
             */
            @JsonSetter(value = "result", nulls = Nulls.SKIP)
            public Builder result(Optional<Result> result) {
                this.result = result;
                return this;
            }

            public Builder result(Result result) {
                this.result = Optional.ofNullable(result);
                return this;
            }

            public Action build() {
                return new Action(name, result, additionalProperties);
            }
        }

        public static final class Result {
            public static final Result SUCCESS = new Result(Value.SUCCESS, "success");

            public static final Result FAILED = new Result(Value.FAILED, "failed");

            private final Value value;

            private final String string;

            Result(Value value, String string) {
                this.value = value;
                this.string = string;
            }

            public Value getEnumValue() {
                return value;
            }

            @java.lang.Override
            @JsonValue
            public String toString() {
                return this.string;
            }

            @java.lang.Override
            public boolean equals(Object other) {
                return (this == other) || (other instanceof Result && this.string.equals(((Result) other).string));
            }

            @java.lang.Override
            public int hashCode() {
                return this.string.hashCode();
            }

            public <T> T visit(Visitor<T> visitor) {
                switch (value) {
                    case SUCCESS:
                        return visitor.visitSuccess();
                    case FAILED:
                        return visitor.visitFailed();
                    case UNKNOWN:
                    default:
                        return visitor.visitUnknown(string);
                }
            }

            @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
            public static Result valueOf(String value) {
                switch (value) {
                    case "success":
                        return SUCCESS;
                    case "failed":
                        return FAILED;
                    default:
                        return new Result(Value.UNKNOWN, value);
                }
            }

            public enum Value {
                SUCCESS,

                FAILED,

                UNKNOWN
            }

            public interface Visitor<T> {
                T visitSuccess();

                T visitFailed();

                T visitUnknown(String unknownType);
            }
        }
    }
}
