/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.tags.types.TagBasic;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ConversationPart.Builder.class)
public final class ConversationPart {
    private final String type;

    private final String id;

    private final String partType;

    private final Optional<String> body;

    private final int createdAt;

    private final int updatedAt;

    private final Optional<Integer> notifiedAt;

    private final Optional<Reference> assignedTo;

    private final ConversationPartAuthor author;

    private final Optional<List<PartAttachment>> attachments;

    private final Optional<String> externalId;

    private final boolean redacted;

    private final Optional<EmailMessageMetadata> emailMessageMetadata;

    private final Optional<ConversationPartMetadata> metadata;

    private final Optional<State> state;

    private final Optional<List<TagBasic>> tags;

    private final Optional<EventDetails> eventDetails;

    private final Optional<String> appPackageCode;

    private final Map<String, Object> additionalProperties;

    private ConversationPart(
            String type,
            String id,
            String partType,
            Optional<String> body,
            int createdAt,
            int updatedAt,
            Optional<Integer> notifiedAt,
            Optional<Reference> assignedTo,
            ConversationPartAuthor author,
            Optional<List<PartAttachment>> attachments,
            Optional<String> externalId,
            boolean redacted,
            Optional<EmailMessageMetadata> emailMessageMetadata,
            Optional<ConversationPartMetadata> metadata,
            Optional<State> state,
            Optional<List<TagBasic>> tags,
            Optional<EventDetails> eventDetails,
            Optional<String> appPackageCode,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.partType = partType;
        this.body = body;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.notifiedAt = notifiedAt;
        this.assignedTo = assignedTo;
        this.author = author;
        this.attachments = attachments;
        this.externalId = externalId;
        this.redacted = redacted;
        this.emailMessageMetadata = emailMessageMetadata;
        this.metadata = metadata;
        this.state = state;
        this.tags = tags;
        this.eventDetails = eventDetails;
        this.appPackageCode = appPackageCode;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Always conversation_part
     */
    @JsonProperty("type")
    public String getType() {
        return type;
    }

    /**
     * @return The id representing the conversation part.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The type of conversation part.
     */
    @JsonProperty("part_type")
    public String getPartType() {
        return partType;
    }

    /**
     * @return The message body, which may contain HTML. For Twitter, this will show a generic message regarding why the body is obscured.
     */
    @JsonProperty("body")
    public Optional<String> getBody() {
        return body;
    }

    /**
     * @return The time the conversation part was created.
     */
    @JsonProperty("created_at")
    public int getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The last time the conversation part was updated.
     */
    @JsonProperty("updated_at")
    public int getUpdatedAt() {
        return updatedAt;
    }

    /**
     * @return The time the user was notified with the conversation part.
     */
    @JsonProperty("notified_at")
    public Optional<Integer> getNotifiedAt() {
        return notifiedAt;
    }

    /**
     * @return The id of the admin that was assigned the conversation by this conversation_part (null if there has been no change in assignment.)
     */
    @JsonProperty("assigned_to")
    public Optional<Reference> getAssignedTo() {
        return assignedTo;
    }

    @JsonProperty("author")
    public ConversationPartAuthor getAuthor() {
        return author;
    }

    /**
     * @return A list of attachments for the part.
     */
    @JsonProperty("attachments")
    public Optional<List<PartAttachment>> getAttachments() {
        return attachments;
    }

    /**
     * @return The external id of the conversation part
     */
    @JsonProperty("external_id")
    public Optional<String> getExternalId() {
        return externalId;
    }

    /**
     * @return Whether or not the conversation part has been redacted.
     */
    @JsonProperty("redacted")
    public boolean getRedacted() {
        return redacted;
    }

    @JsonProperty("email_message_metadata")
    public Optional<EmailMessageMetadata> getEmailMessageMetadata() {
        return emailMessageMetadata;
    }

    @JsonProperty("metadata")
    public Optional<ConversationPartMetadata> getMetadata() {
        return metadata;
    }

    /**
     * @return Indicates the current state of conversation when the conversation part was created.
     */
    @JsonProperty("state")
    public Optional<State> getState() {
        return state;
    }

    /**
     * @return A list of tags objects associated with the conversation part.
     */
    @JsonProperty("tags")
    public Optional<List<TagBasic>> getTags() {
        return tags;
    }

    @JsonProperty("event_details")
    public Optional<EventDetails> getEventDetails() {
        return eventDetails;
    }

    /**
     * @return The app package code if this part was created via API. null if the part was not created via API.
     */
    @JsonProperty("app_package_code")
    public Optional<String> getAppPackageCode() {
        return appPackageCode;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ConversationPart && equalTo((ConversationPart) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationPart other) {
        return type.equals(other.type)
                && id.equals(other.id)
                && partType.equals(other.partType)
                && body.equals(other.body)
                && createdAt == other.createdAt
                && updatedAt == other.updatedAt
                && notifiedAt.equals(other.notifiedAt)
                && assignedTo.equals(other.assignedTo)
                && author.equals(other.author)
                && attachments.equals(other.attachments)
                && externalId.equals(other.externalId)
                && redacted == other.redacted
                && emailMessageMetadata.equals(other.emailMessageMetadata)
                && metadata.equals(other.metadata)
                && state.equals(other.state)
                && tags.equals(other.tags)
                && eventDetails.equals(other.eventDetails)
                && appPackageCode.equals(other.appPackageCode);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.type,
                this.id,
                this.partType,
                this.body,
                this.createdAt,
                this.updatedAt,
                this.notifiedAt,
                this.assignedTo,
                this.author,
                this.attachments,
                this.externalId,
                this.redacted,
                this.emailMessageMetadata,
                this.metadata,
                this.state,
                this.tags,
                this.eventDetails,
                this.appPackageCode);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    public interface TypeStage {
        /**
         * <p>Always conversation_part</p>
         */
        IdStage type(@NotNull String type);

        Builder from(ConversationPart other);
    }

    public interface IdStage {
        /**
         * <p>The id representing the conversation part.</p>
         */
        PartTypeStage id(@NotNull String id);
    }

    public interface PartTypeStage {
        /**
         * <p>The type of conversation part.</p>
         */
        CreatedAtStage partType(@NotNull String partType);
    }

    public interface CreatedAtStage {
        /**
         * <p>The time the conversation part was created.</p>
         */
        UpdatedAtStage createdAt(int createdAt);
    }

    public interface UpdatedAtStage {
        /**
         * <p>The last time the conversation part was updated.</p>
         */
        AuthorStage updatedAt(int updatedAt);
    }

    public interface AuthorStage {
        RedactedStage author(@NotNull ConversationPartAuthor author);
    }

    public interface RedactedStage {
        /**
         * <p>Whether or not the conversation part has been redacted.</p>
         */
        _FinalStage redacted(boolean redacted);
    }

    public interface _FinalStage {
        ConversationPart build();

        /**
         * <p>The message body, which may contain HTML. For Twitter, this will show a generic message regarding why the body is obscured.</p>
         */
        _FinalStage body(Optional<String> body);

        _FinalStage body(String body);

        /**
         * <p>The time the user was notified with the conversation part.</p>
         */
        _FinalStage notifiedAt(Optional<Integer> notifiedAt);

        _FinalStage notifiedAt(Integer notifiedAt);

        /**
         * <p>The id of the admin that was assigned the conversation by this conversation_part (null if there has been no change in assignment.)</p>
         */
        _FinalStage assignedTo(Optional<Reference> assignedTo);

        _FinalStage assignedTo(Reference assignedTo);

        /**
         * <p>A list of attachments for the part.</p>
         */
        _FinalStage attachments(Optional<List<PartAttachment>> attachments);

        _FinalStage attachments(List<PartAttachment> attachments);

        /**
         * <p>The external id of the conversation part</p>
         */
        _FinalStage externalId(Optional<String> externalId);

        _FinalStage externalId(String externalId);

        _FinalStage emailMessageMetadata(Optional<EmailMessageMetadata> emailMessageMetadata);

        _FinalStage emailMessageMetadata(EmailMessageMetadata emailMessageMetadata);

        _FinalStage metadata(Optional<ConversationPartMetadata> metadata);

        _FinalStage metadata(ConversationPartMetadata metadata);

        /**
         * <p>Indicates the current state of conversation when the conversation part was created.</p>
         */
        _FinalStage state(Optional<State> state);

        _FinalStage state(State state);

        /**
         * <p>A list of tags objects associated with the conversation part.</p>
         */
        _FinalStage tags(Optional<List<TagBasic>> tags);

        _FinalStage tags(List<TagBasic> tags);

        _FinalStage eventDetails(Optional<EventDetails> eventDetails);

        _FinalStage eventDetails(EventDetails eventDetails);

        /**
         * <p>The app package code if this part was created via API. null if the part was not created via API.</p>
         */
        _FinalStage appPackageCode(Optional<String> appPackageCode);

        _FinalStage appPackageCode(String appPackageCode);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements TypeStage,
                    IdStage,
                    PartTypeStage,
                    CreatedAtStage,
                    UpdatedAtStage,
                    AuthorStage,
                    RedactedStage,
                    _FinalStage {
        private String type;

        private String id;

        private String partType;

        private int createdAt;

        private int updatedAt;

        private ConversationPartAuthor author;

        private boolean redacted;

        private Optional<String> appPackageCode = Optional.empty();

        private Optional<EventDetails> eventDetails = Optional.empty();

        private Optional<List<TagBasic>> tags = Optional.empty();

        private Optional<State> state = Optional.empty();

        private Optional<ConversationPartMetadata> metadata = Optional.empty();

        private Optional<EmailMessageMetadata> emailMessageMetadata = Optional.empty();

        private Optional<String> externalId = Optional.empty();

        private Optional<List<PartAttachment>> attachments = Optional.empty();

        private Optional<Reference> assignedTo = Optional.empty();

        private Optional<Integer> notifiedAt = Optional.empty();

        private Optional<String> body = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ConversationPart other) {
            type(other.getType());
            id(other.getId());
            partType(other.getPartType());
            body(other.getBody());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            notifiedAt(other.getNotifiedAt());
            assignedTo(other.getAssignedTo());
            author(other.getAuthor());
            attachments(other.getAttachments());
            externalId(other.getExternalId());
            redacted(other.getRedacted());
            emailMessageMetadata(other.getEmailMessageMetadata());
            metadata(other.getMetadata());
            state(other.getState());
            tags(other.getTags());
            eventDetails(other.getEventDetails());
            appPackageCode(other.getAppPackageCode());
            return this;
        }

        /**
         * <p>Always conversation_part</p>
         * <p>Always conversation_part</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("type")
        public IdStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        /**
         * <p>The id representing the conversation part.</p>
         * <p>The id representing the conversation part.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public PartTypeStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * <p>The type of conversation part.</p>
         * <p>The type of conversation part.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("part_type")
        public CreatedAtStage partType(@NotNull String partType) {
            this.partType = Objects.requireNonNull(partType, "partType must not be null");
            return this;
        }

        /**
         * <p>The time the conversation part was created.</p>
         * <p>The time the conversation part was created.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_at")
        public UpdatedAtStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        /**
         * <p>The last time the conversation part was updated.</p>
         * <p>The last time the conversation part was updated.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("updated_at")
        public AuthorStage updatedAt(int updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @java.lang.Override
        @JsonSetter("author")
        public RedactedStage author(@NotNull ConversationPartAuthor author) {
            this.author = Objects.requireNonNull(author, "author must not be null");
            return this;
        }

        /**
         * <p>Whether or not the conversation part has been redacted.</p>
         * <p>Whether or not the conversation part has been redacted.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("redacted")
        public _FinalStage redacted(boolean redacted) {
            this.redacted = redacted;
            return this;
        }

        /**
         * <p>The app package code if this part was created via API. null if the part was not created via API.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage appPackageCode(String appPackageCode) {
            this.appPackageCode = Optional.ofNullable(appPackageCode);
            return this;
        }

        /**
         * <p>The app package code if this part was created via API. null if the part was not created via API.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "app_package_code", nulls = Nulls.SKIP)
        public _FinalStage appPackageCode(Optional<String> appPackageCode) {
            this.appPackageCode = appPackageCode;
            return this;
        }

        @java.lang.Override
        public _FinalStage eventDetails(EventDetails eventDetails) {
            this.eventDetails = Optional.ofNullable(eventDetails);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "event_details", nulls = Nulls.SKIP)
        public _FinalStage eventDetails(Optional<EventDetails> eventDetails) {
            this.eventDetails = eventDetails;
            return this;
        }

        /**
         * <p>A list of tags objects associated with the conversation part.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage tags(List<TagBasic> tags) {
            this.tags = Optional.ofNullable(tags);
            return this;
        }

        /**
         * <p>A list of tags objects associated with the conversation part.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "tags", nulls = Nulls.SKIP)
        public _FinalStage tags(Optional<List<TagBasic>> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * <p>Indicates the current state of conversation when the conversation part was created.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage state(State state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        /**
         * <p>Indicates the current state of conversation when the conversation part was created.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "state", nulls = Nulls.SKIP)
        public _FinalStage state(Optional<State> state) {
            this.state = state;
            return this;
        }

        @java.lang.Override
        public _FinalStage metadata(ConversationPartMetadata metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "metadata", nulls = Nulls.SKIP)
        public _FinalStage metadata(Optional<ConversationPartMetadata> metadata) {
            this.metadata = metadata;
            return this;
        }

        @java.lang.Override
        public _FinalStage emailMessageMetadata(EmailMessageMetadata emailMessageMetadata) {
            this.emailMessageMetadata = Optional.ofNullable(emailMessageMetadata);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "email_message_metadata", nulls = Nulls.SKIP)
        public _FinalStage emailMessageMetadata(Optional<EmailMessageMetadata> emailMessageMetadata) {
            this.emailMessageMetadata = emailMessageMetadata;
            return this;
        }

        /**
         * <p>The external id of the conversation part</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage externalId(String externalId) {
            this.externalId = Optional.ofNullable(externalId);
            return this;
        }

        /**
         * <p>The external id of the conversation part</p>
         */
        @java.lang.Override
        @JsonSetter(value = "external_id", nulls = Nulls.SKIP)
        public _FinalStage externalId(Optional<String> externalId) {
            this.externalId = externalId;
            return this;
        }

        /**
         * <p>A list of attachments for the part.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage attachments(List<PartAttachment> attachments) {
            this.attachments = Optional.ofNullable(attachments);
            return this;
        }

        /**
         * <p>A list of attachments for the part.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "attachments", nulls = Nulls.SKIP)
        public _FinalStage attachments(Optional<List<PartAttachment>> attachments) {
            this.attachments = attachments;
            return this;
        }

        /**
         * <p>The id of the admin that was assigned the conversation by this conversation_part (null if there has been no change in assignment.)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage assignedTo(Reference assignedTo) {
            this.assignedTo = Optional.ofNullable(assignedTo);
            return this;
        }

        /**
         * <p>The id of the admin that was assigned the conversation by this conversation_part (null if there has been no change in assignment.)</p>
         */
        @java.lang.Override
        @JsonSetter(value = "assigned_to", nulls = Nulls.SKIP)
        public _FinalStage assignedTo(Optional<Reference> assignedTo) {
            this.assignedTo = assignedTo;
            return this;
        }

        /**
         * <p>The time the user was notified with the conversation part.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage notifiedAt(Integer notifiedAt) {
            this.notifiedAt = Optional.ofNullable(notifiedAt);
            return this;
        }

        /**
         * <p>The time the user was notified with the conversation part.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "notified_at", nulls = Nulls.SKIP)
        public _FinalStage notifiedAt(Optional<Integer> notifiedAt) {
            this.notifiedAt = notifiedAt;
            return this;
        }

        /**
         * <p>The message body, which may contain HTML. For Twitter, this will show a generic message regarding why the body is obscured.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        /**
         * <p>The message body, which may contain HTML. For Twitter, this will show a generic message regarding why the body is obscured.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "body", nulls = Nulls.SKIP)
        public _FinalStage body(Optional<String> body) {
            this.body = body;
            return this;
        }

        @java.lang.Override
        public ConversationPart build() {
            return new ConversationPart(
                    type,
                    id,
                    partType,
                    body,
                    createdAt,
                    updatedAt,
                    notifiedAt,
                    assignedTo,
                    author,
                    attachments,
                    externalId,
                    redacted,
                    emailMessageMetadata,
                    metadata,
                    state,
                    tags,
                    eventDetails,
                    appPackageCode,
                    additionalProperties);
        }
    }

    public static final class State {
        public static final State SNOOZED = new State(Value.SNOOZED, "snoozed");

        public static final State CLOSED = new State(Value.CLOSED, "closed");

        public static final State OPEN = new State(Value.OPEN, "open");

        private final Value value;

        private final String string;

        State(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof State && this.string.equals(((State) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case SNOOZED:
                    return visitor.visitSnoozed();
                case CLOSED:
                    return visitor.visitClosed();
                case OPEN:
                    return visitor.visitOpen();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static State valueOf(String value) {
            switch (value) {
                case "snoozed":
                    return SNOOZED;
                case "closed":
                    return CLOSED;
                case "open":
                    return OPEN;
                default:
                    return new State(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            OPEN,

            CLOSED,

            SNOOZED,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitOpen();

            T visitClosed();

            T visitSnoozed();

            T visitUnknown(String unknownType);
        }
    }
}
