/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ConversationPartAuthor.Builder.class)
public final class ConversationPartAuthor {
    private final String type;

    private final String id;

    private final Optional<String> name;

    private final Optional<String> email;

    private final Optional<Boolean> fromAiAgent;

    private final Optional<Boolean> isAiAnswer;

    private final Map<String, Object> additionalProperties;

    private ConversationPartAuthor(
            String type,
            String id,
            Optional<String> name,
            Optional<String> email,
            Optional<Boolean> fromAiAgent,
            Optional<Boolean> isAiAnswer,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.email = email;
        this.fromAiAgent = fromAiAgent;
        this.isAiAnswer = isAiAnswer;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of the author
     */
    @JsonProperty("type")
    public String getType() {
        return type;
    }

    /**
     * @return The id of the author
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The name of the author
     */
    @JsonProperty("name")
    public Optional<String> getName() {
        return name;
    }

    /**
     * @return The email of the author
     */
    @JsonProperty("email")
    public Optional<String> getEmail() {
        return email;
    }

    /**
     * @return If this conversation part was sent by the AI Agent
     */
    @JsonProperty("from_ai_agent")
    public Optional<Boolean> getFromAiAgent() {
        return fromAiAgent;
    }

    /**
     * @return If this conversation part body was generated by the AI Agent
     */
    @JsonProperty("is_ai_answer")
    public Optional<Boolean> getIsAiAnswer() {
        return isAiAnswer;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ConversationPartAuthor && equalTo((ConversationPartAuthor) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationPartAuthor other) {
        return type.equals(other.type)
                && id.equals(other.id)
                && name.equals(other.name)
                && email.equals(other.email)
                && fromAiAgent.equals(other.fromAiAgent)
                && isAiAnswer.equals(other.isAiAnswer);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.id, this.name, this.email, this.fromAiAgent, this.isAiAnswer);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    public interface TypeStage {
        /**
         * <p>The type of the author</p>
         */
        IdStage type(@NotNull String type);

        Builder from(ConversationPartAuthor other);
    }

    public interface IdStage {
        /**
         * <p>The id of the author</p>
         */
        _FinalStage id(@NotNull String id);
    }

    public interface _FinalStage {
        ConversationPartAuthor build();

        /**
         * <p>The name of the author</p>
         */
        _FinalStage name(Optional<String> name);

        _FinalStage name(String name);

        /**
         * <p>The email of the author</p>
         */
        _FinalStage email(Optional<String> email);

        _FinalStage email(String email);

        /**
         * <p>If this conversation part was sent by the AI Agent</p>
         */
        _FinalStage fromAiAgent(Optional<Boolean> fromAiAgent);

        _FinalStage fromAiAgent(Boolean fromAiAgent);

        /**
         * <p>If this conversation part body was generated by the AI Agent</p>
         */
        _FinalStage isAiAnswer(Optional<Boolean> isAiAnswer);

        _FinalStage isAiAnswer(Boolean isAiAnswer);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TypeStage, IdStage, _FinalStage {
        private String type;

        private String id;

        private Optional<Boolean> isAiAnswer = Optional.empty();

        private Optional<Boolean> fromAiAgent = Optional.empty();

        private Optional<String> email = Optional.empty();

        private Optional<String> name = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ConversationPartAuthor other) {
            type(other.getType());
            id(other.getId());
            name(other.getName());
            email(other.getEmail());
            fromAiAgent(other.getFromAiAgent());
            isAiAnswer(other.getIsAiAnswer());
            return this;
        }

        /**
         * <p>The type of the author</p>
         * <p>The type of the author</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("type")
        public IdStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        /**
         * <p>The id of the author</p>
         * <p>The id of the author</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * <p>If this conversation part body was generated by the AI Agent</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage isAiAnswer(Boolean isAiAnswer) {
            this.isAiAnswer = Optional.ofNullable(isAiAnswer);
            return this;
        }

        /**
         * <p>If this conversation part body was generated by the AI Agent</p>
         */
        @java.lang.Override
        @JsonSetter(value = "is_ai_answer", nulls = Nulls.SKIP)
        public _FinalStage isAiAnswer(Optional<Boolean> isAiAnswer) {
            this.isAiAnswer = isAiAnswer;
            return this;
        }

        /**
         * <p>If this conversation part was sent by the AI Agent</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage fromAiAgent(Boolean fromAiAgent) {
            this.fromAiAgent = Optional.ofNullable(fromAiAgent);
            return this;
        }

        /**
         * <p>If this conversation part was sent by the AI Agent</p>
         */
        @java.lang.Override
        @JsonSetter(value = "from_ai_agent", nulls = Nulls.SKIP)
        public _FinalStage fromAiAgent(Optional<Boolean> fromAiAgent) {
            this.fromAiAgent = fromAiAgent;
            return this;
        }

        /**
         * <p>The email of the author</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        /**
         * <p>The email of the author</p>
         */
        @java.lang.Override
        @JsonSetter(value = "email", nulls = Nulls.SKIP)
        public _FinalStage email(Optional<String> email) {
            this.email = email;
            return this;
        }

        /**
         * <p>The name of the author</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        /**
         * <p>The name of the author</p>
         */
        @java.lang.Override
        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @java.lang.Override
        public ConversationPartAuthor build() {
            return new ConversationPartAuthor(type, id, name, email, fromAiAgent, isAiAnswer, additionalProperties);
        }
    }
}
