/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpdateArticleRequestBody.Builder.class)
public final class UpdateArticleRequestBody {
    private final Optional<ParentType> parentType;

    private final Map<String, Object> additionalProperties;

    private UpdateArticleRequestBody(Optional<ParentType> parentType, Map<String, Object> additionalProperties) {
        this.parentType = parentType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("parent_type")
    public Optional<ParentType> getParentType() {
        return parentType;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdateArticleRequestBody && equalTo((UpdateArticleRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateArticleRequestBody other) {
        return parentType.equals(other.parentType);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.parentType);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<ParentType> parentType = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(UpdateArticleRequestBody other) {
            parentType(other.getParentType());
            return this;
        }

        @JsonSetter(value = "parent_type", nulls = Nulls.SKIP)
        public Builder parentType(Optional<ParentType> parentType) {
            this.parentType = parentType;
            return this;
        }

        public Builder parentType(ParentType parentType) {
            this.parentType = Optional.ofNullable(parentType);
            return this;
        }

        public UpdateArticleRequestBody build() {
            return new UpdateArticleRequestBody(parentType, additionalProperties);
        }
    }

    public static final class ParentType {
        public static final ParentType SECTION = new ParentType(Value.SECTION, "section");

        public static final ParentType COLLECTION = new ParentType(Value.COLLECTION, "collection");

        private final Value value;

        private final String string;

        ParentType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof ParentType && this.string.equals(((ParentType) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case SECTION:
                    return visitor.visitSection();
                case COLLECTION:
                    return visitor.visitCollection();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static ParentType valueOf(String value) {
            switch (value) {
                case "section":
                    return SECTION;
                case "collection":
                    return COLLECTION;
                default:
                    return new ParentType(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            COLLECTION,

            SECTION,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitCollection();

            T visitSection();

            T visitUnknown(String unknownType);
        }
    }
}
