/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.teams.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.AdminPriorityLevel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Team {
    private final String type;
    private final String id;
    private final String name;
    private final List<Integer> adminIds;
    private final Optional<AdminPriorityLevel> adminPriorityLevel;
    private final Optional<Integer> assignmentLimit;
    private final Optional<String> distributionMethod;
    private final Map<String, Object> additionalProperties;

    private Team(String type, String id, String name, List<Integer> adminIds, Optional<AdminPriorityLevel> adminPriorityLevel, Optional<Integer> assignmentLimit, Optional<String> distributionMethod, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.adminIds = adminIds;
        this.adminPriorityLevel = adminPriorityLevel;
        this.assignmentLimit = assignmentLimit;
        this.distributionMethod = distributionMethod;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="admin_ids")
    public List<Integer> getAdminIds() {
        return this.adminIds;
    }

    @JsonProperty(value="admin_priority_level")
    public Optional<AdminPriorityLevel> getAdminPriorityLevel() {
        return this.adminPriorityLevel;
    }

    @JsonProperty(value="assignment_limit")
    public Optional<Integer> getAssignmentLimit() {
        return this.assignmentLimit;
    }

    @JsonProperty(value="distribution_method")
    public Optional<String> getDistributionMethod() {
        return this.distributionMethod;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Team && this.equalTo((Team)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Team other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.name.equals(other.name) && this.adminIds.equals(other.adminIds) && this.adminPriorityLevel.equals(other.adminPriorityLevel) && this.assignmentLimit.equals(other.assignmentLimit) && this.distributionMethod.equals(other.distributionMethod);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.name, this.adminIds, this.adminPriorityLevel, this.assignmentLimit, this.distributionMethod);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TypeStage,
    IdStage,
    NameStage,
    _FinalStage {
        private String type;
        private String id;
        private String name;
        private Optional<String> distributionMethod = Optional.empty();
        private Optional<Integer> assignmentLimit = Optional.empty();
        private Optional<AdminPriorityLevel> adminPriorityLevel = Optional.empty();
        private List<Integer> adminIds = new ArrayList<Integer>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Team other) {
            this.type(other.getType());
            this.id(other.getId());
            this.name(other.getName());
            this.adminIds(other.getAdminIds());
            this.adminPriorityLevel(other.getAdminPriorityLevel());
            this.assignmentLimit(other.getAssignmentLimit());
            this.distributionMethod(other.getDistributionMethod());
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public IdStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        public _FinalStage distributionMethod(String distributionMethod) {
            this.distributionMethod = Optional.ofNullable(distributionMethod);
            return this;
        }

        @Override
        @JsonSetter(value="distribution_method", nulls=Nulls.SKIP)
        public _FinalStage distributionMethod(Optional<String> distributionMethod) {
            this.distributionMethod = distributionMethod;
            return this;
        }

        @Override
        public _FinalStage assignmentLimit(Integer assignmentLimit) {
            this.assignmentLimit = Optional.ofNullable(assignmentLimit);
            return this;
        }

        @Override
        @JsonSetter(value="assignment_limit", nulls=Nulls.SKIP)
        public _FinalStage assignmentLimit(Optional<Integer> assignmentLimit) {
            this.assignmentLimit = assignmentLimit;
            return this;
        }

        @Override
        public _FinalStage adminPriorityLevel(AdminPriorityLevel adminPriorityLevel) {
            this.adminPriorityLevel = Optional.ofNullable(adminPriorityLevel);
            return this;
        }

        @Override
        @JsonSetter(value="admin_priority_level", nulls=Nulls.SKIP)
        public _FinalStage adminPriorityLevel(Optional<AdminPriorityLevel> adminPriorityLevel) {
            this.adminPriorityLevel = adminPriorityLevel;
            return this;
        }

        @Override
        public _FinalStage addAllAdminIds(List<Integer> adminIds) {
            if (adminIds != null) {
                this.adminIds.addAll(adminIds);
            }
            return this;
        }

        @Override
        public _FinalStage addAdminIds(Integer adminIds) {
            this.adminIds.add(adminIds);
            return this;
        }

        @Override
        @JsonSetter(value="admin_ids", nulls=Nulls.SKIP)
        public _FinalStage adminIds(List<Integer> adminIds) {
            this.adminIds.clear();
            if (adminIds != null) {
                this.adminIds.addAll(adminIds);
            }
            return this;
        }

        @Override
        public Team build() {
            return new Team(this.type, this.id, this.name, this.adminIds, this.adminPriorityLevel, this.assignmentLimit, this.distributionMethod, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Team build();

        public _FinalStage adminIds(List<Integer> var1);

        public _FinalStage addAdminIds(Integer var1);

        public _FinalStage addAllAdminIds(List<Integer> var1);

        public _FinalStage adminPriorityLevel(Optional<AdminPriorityLevel> var1);

        public _FinalStage adminPriorityLevel(AdminPriorityLevel var1);

        public _FinalStage assignmentLimit(Optional<Integer> var1);

        public _FinalStage assignmentLimit(Integer var1);

        public _FinalStage distributionMethod(Optional<String> var1);

        public _FinalStage distributionMethod(String var1);
    }

    public static interface NameStage {
        public _FinalStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);
    }

    public static interface TypeStage {
        public IdStage type(@NotNull String var1);

        public Builder from(Team var1);
    }
}

