/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.ContactReference;
import com.intercom.api.resources.unstable.types.Reference;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConversationRating {
    private final Optional<Integer> rating;
    private final Optional<String> remark;
    private final Optional<Integer> createdAt;
    private final Optional<Integer> updatedAt;
    private final Optional<ContactReference> contact;
    private final Optional<Reference> teammate;
    private final Map<String, Object> additionalProperties;

    private ConversationRating(Optional<Integer> rating, Optional<String> remark, Optional<Integer> createdAt, Optional<Integer> updatedAt, Optional<ContactReference> contact, Optional<Reference> teammate, Map<String, Object> additionalProperties) {
        this.rating = rating;
        this.remark = remark;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.contact = contact;
        this.teammate = teammate;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="rating")
    public Optional<Integer> getRating() {
        return this.rating;
    }

    @JsonProperty(value="remark")
    public Optional<String> getRemark() {
        return this.remark;
    }

    @JsonProperty(value="created_at")
    public Optional<Integer> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<Integer> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="contact")
    public Optional<ContactReference> getContact() {
        return this.contact;
    }

    @JsonProperty(value="teammate")
    public Optional<Reference> getTeammate() {
        return this.teammate;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConversationRating && this.equalTo((ConversationRating)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationRating other) {
        return this.rating.equals(other.rating) && this.remark.equals(other.remark) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.contact.equals(other.contact) && this.teammate.equals(other.teammate);
    }

    public int hashCode() {
        return Objects.hash(this.rating, this.remark, this.createdAt, this.updatedAt, this.contact, this.teammate);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Integer> rating = Optional.empty();
        private Optional<String> remark = Optional.empty();
        private Optional<Integer> createdAt = Optional.empty();
        private Optional<Integer> updatedAt = Optional.empty();
        private Optional<ContactReference> contact = Optional.empty();
        private Optional<Reference> teammate = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ConversationRating other) {
            this.rating(other.getRating());
            this.remark(other.getRemark());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.contact(other.getContact());
            this.teammate(other.getTeammate());
            return this;
        }

        @JsonSetter(value="rating", nulls=Nulls.SKIP)
        public Builder rating(Optional<Integer> rating) {
            this.rating = rating;
            return this;
        }

        public Builder rating(Integer rating) {
            this.rating = Optional.ofNullable(rating);
            return this;
        }

        @JsonSetter(value="remark", nulls=Nulls.SKIP)
        public Builder remark(Optional<String> remark) {
            this.remark = remark;
            return this;
        }

        public Builder remark(String remark) {
            this.remark = Optional.ofNullable(remark);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="contact", nulls=Nulls.SKIP)
        public Builder contact(Optional<ContactReference> contact) {
            this.contact = contact;
            return this;
        }

        public Builder contact(ContactReference contact) {
            this.contact = Optional.ofNullable(contact);
            return this;
        }

        @JsonSetter(value="teammate", nulls=Nulls.SKIP)
        public Builder teammate(Optional<Reference> teammate) {
            this.teammate = teammate;
            return this;
        }

        public Builder teammate(Reference teammate) {
            this.teammate = Optional.ofNullable(teammate);
            return this;
        }

        public ConversationRating build() {
            return new ConversationRating(this.rating, this.remark, this.createdAt, this.updatedAt, this.contact, this.teammate, this.additionalProperties);
        }
    }
}

