/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.context;

import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.context.MethodValueResolver;
import java.lang.reflect.Method;

public class JavaBeanValueResolver
extends MethodValueResolver {
    private static final String IS_PREFIX = "is";
    private static final String GET_PREFIX = "get";
    public static final ValueResolver INSTANCE = new JavaBeanValueResolver();

    @Override
    public boolean matches(Method method, String name) {
        boolean isStatic = this.isStatic(method);
        boolean isPublic = this.isPublic(method);
        boolean isGet = method.getName().equals(JavaBeanValueResolver.javaBeanMethod(GET_PREFIX, name));
        boolean isBoolGet = method.getName().equals(JavaBeanValueResolver.javaBeanMethod(IS_PREFIX, name));
        int parameterCount = method.getParameterTypes().length;
        return !isStatic && isPublic && parameterCount == 0 && (isGet || isBoolGet);
    }

    private static String javaBeanMethod(String prefix, String name) {
        StringBuilder buffer = new StringBuilder(prefix);
        buffer.append(name);
        buffer.setCharAt(prefix.length(), Character.toUpperCase(name.charAt(0)));
        return buffer.toString();
    }

    @Override
    protected String memberName(Method member) {
        String name = member.getName();
        if (name.startsWith(GET_PREFIX)) {
            name = name.substring(GET_PREFIX.length());
        } else if (name.startsWith(IS_PREFIX)) {
            name = name.substring(IS_PREFIX.length());
        } else {
            return name;
        }
        if (name.length() > 0) {
            return Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }
        return member.getName();
    }
}

