/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.cli;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.cli.CliContext;
import io.jooby.cli.Cmd;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Matcher;
import picocli.CommandLine;

@CommandLine.Command(name="set", description={"Set and save options in the ~/.jooby file"})
public class SetCmd
extends Cmd {
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"-w", "--workspace"}, description={"Save the workspace directory. Projects are going to be created here"})
    private String workspace;
    @CommandLine.Option(names={"-f", "--force"}, description={"Force creation of workspace"})
    private boolean force;

    @Override
    public void run(@NonNull CliContext ctx) throws Exception {
        if (this.workspace != null) {
            Path path = Paths.get(this.workspace.replaceFirst("^~", Matcher.quoteReplacement(System.getProperty("user.home"))), new String[0]).normalize().toAbsolutePath();
            if (Files.exists(path, new LinkOption[0])) {
                ctx.setWorkspace(path);
            } else if (this.force) {
                Files.createDirectories(path, new FileAttribute[0]);
                ctx.setWorkspace(path);
            } else {
                ctx.println("Directory doesn't exist: " + path);
                ctx.println("Use -f to force directory creation");
            }
        } else {
            ctx.println(this.spec.commandLine().getUsageMessage());
        }
    }
}

