/*
 * Decompiled with CFR 0.152.
 */
package io.rdapapi.client;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.rdapapi.client.DomainOptions;
import io.rdapapi.client.RdapClientOptions;
import io.rdapapi.client.exceptions.AuthenticationException;
import io.rdapapi.client.exceptions.NotFoundException;
import io.rdapapi.client.exceptions.RateLimitException;
import io.rdapapi.client.exceptions.RdapApiException;
import io.rdapapi.client.exceptions.SubscriptionRequiredException;
import io.rdapapi.client.exceptions.UpstreamException;
import io.rdapapi.client.exceptions.ValidationException;
import io.rdapapi.client.responses.AsnResponse;
import io.rdapapi.client.responses.BulkDomainResponse;
import io.rdapapi.client.responses.DomainResponse;
import io.rdapapi.client.responses.EntityResponse;
import io.rdapapi.client.responses.IpResponse;
import io.rdapapi.client.responses.NameserverResponse;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;

public final class RdapClient
implements AutoCloseable {
    private static final String DEFAULT_BASE_URL = "https://rdapapi.io/api/v1";
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(30L);
    static final ObjectMapper MAPPER = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final String baseUrl;
    private final HttpClient httpClient;
    private final String authHeader;
    private final String userAgent;

    public RdapClient(String apiKey) {
        this(apiKey, new RdapClientOptions());
    }

    public RdapClient(String apiKey, RdapClientOptions options) {
        if (apiKey == null || apiKey.isEmpty()) {
            throw new IllegalArgumentException("apiKey must be a non-empty string");
        }
        this.baseUrl = options.getBaseUrl() != null ? options.getBaseUrl() : DEFAULT_BASE_URL;
        Duration timeout = options.getTimeout() != null ? options.getTimeout() : DEFAULT_TIMEOUT;
        this.httpClient = HttpClient.newBuilder().connectTimeout(timeout).build();
        this.authHeader = "Bearer " + apiKey;
        this.userAgent = "rdapapi-java/0.1.0";
    }

    public DomainResponse domain(String name) throws IOException, InterruptedException {
        return this.domain(name, new DomainOptions());
    }

    public DomainResponse domain(String name, DomainOptions options) throws IOException, InterruptedException {
        String path = "/domain/" + name;
        if (options.isFollow()) {
            path = path + "?follow=true";
        }
        byte[] body = this.doGet(path);
        return (DomainResponse)MAPPER.readValue(body, DomainResponse.class);
    }

    public IpResponse ip(String address) throws IOException, InterruptedException {
        byte[] body = this.doGet("/ip/" + address);
        return (IpResponse)MAPPER.readValue(body, IpResponse.class);
    }

    public AsnResponse asn(int number) throws IOException, InterruptedException {
        return this.asn(String.valueOf(number));
    }

    public AsnResponse asn(String number) throws IOException, InterruptedException {
        String value = number.toUpperCase().replaceFirst("^AS", "");
        byte[] body = this.doGet("/asn/" + value);
        return (AsnResponse)MAPPER.readValue(body, AsnResponse.class);
    }

    public NameserverResponse nameserver(String host) throws IOException, InterruptedException {
        byte[] body = this.doGet("/nameserver/" + host);
        return (NameserverResponse)MAPPER.readValue(body, NameserverResponse.class);
    }

    public EntityResponse entity(String handle) throws IOException, InterruptedException {
        byte[] body = this.doGet("/entity/" + handle);
        return (EntityResponse)MAPPER.readValue(body, EntityResponse.class);
    }

    public BulkDomainResponse bulkDomains(List<String> domains) throws IOException, InterruptedException {
        return this.bulkDomains(domains, new DomainOptions());
    }

    public BulkDomainResponse bulkDomains(List<String> domains, DomainOptions options) throws IOException, InterruptedException {
        byte[] responseBody;
        JsonNode tree;
        JsonNode results;
        ObjectNode root = MAPPER.createObjectNode();
        ArrayNode domainsNode = root.putArray("domains");
        for (String d : domains) {
            domainsNode.add(d);
        }
        if (options.isFollow()) {
            root.put("follow", true);
        }
        if ((results = (tree = MAPPER.readTree(responseBody = this.doPost("/domains/bulk", MAPPER.writeValueAsBytes((Object)root)))).get("results")) != null && results.isArray()) {
            for (JsonNode result : results) {
                if (!"success".equals(result.path("status").asText()) || !result.has("data") || !result.has("meta")) continue;
                ((ObjectNode)result.get("data")).set("meta", result.get("meta"));
                ((ObjectNode)result).remove("meta");
            }
        }
        return (BulkDomainResponse)MAPPER.treeToValue((TreeNode)tree, BulkDomainResponse.class);
    }

    @Override
    public void close() {
    }

    private byte[] doGet(String path) throws IOException, InterruptedException {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.baseUrl + path)).header("Authorization", this.authHeader).header("User-Agent", this.userAgent).header("Accept", "application/json").GET().build();
        return this.doRequest(request);
    }

    private byte[] doPost(String path, byte[] body) throws IOException, InterruptedException {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.baseUrl + path)).header("Authorization", this.authHeader).header("User-Agent", this.userAgent).header("Accept", "application/json").header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofByteArray(body)).build();
        return this.doRequest(request);
    }

    private byte[] doRequest(HttpRequest request) throws IOException, InterruptedException {
        HttpResponse<byte[]> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofByteArray());
        if (response.statusCode() >= 400) {
            this.handleError(response);
        }
        return response.body();
    }

    private void handleError(HttpResponse<byte[]> response) {
        String retryHeader;
        String errorCode = "unknown_error";
        Object message = "HTTP " + response.statusCode();
        try {
            JsonNode body = MAPPER.readTree(response.body());
            if (body.has("error")) {
                errorCode = body.get("error").asText();
            }
            if (body.has("message")) {
                message = body.get("message").asText();
            }
        }
        catch (Exception body) {
            // empty catch block
        }
        Integer retryAfter = null;
        if (response.statusCode() == 429 && (retryHeader = (String)response.headers().firstValue("Retry-After").orElse(null)) != null) {
            try {
                retryAfter = Integer.parseInt(retryHeader);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw this.createException(response.statusCode(), errorCode, (String)message, retryAfter);
    }

    private RdapApiException createException(int statusCode, String errorCode, String message, Integer retryAfter) {
        switch (statusCode) {
            case 400: {
                return new ValidationException(message, errorCode);
            }
            case 401: {
                return new AuthenticationException(message, errorCode);
            }
            case 403: {
                return new SubscriptionRequiredException(message, errorCode);
            }
            case 404: {
                return new NotFoundException(message, errorCode);
            }
            case 429: {
                return new RateLimitException(message, errorCode, retryAfter);
            }
            case 502: {
                return new UpstreamException(message, errorCode);
            }
        }
        return new RdapApiException(message, statusCode, errorCode);
    }
}

