/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.projectsettings;

import io.spring.javaformat.config.JavaFormatConfig;
import io.spring.javaformat.eclipse.projectsettings.ProjectProperties;
import io.spring.javaformat.eclipse.projectsettings.ProjectSettingsFile;
import io.spring.javaformat.eclipse.projectsettings.ProjectSettingsFiles;
import io.spring.javaformat.eclipse.projectsettings.ProjectSettingsFilesLocator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.LocalDate;
import java.util.Properties;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class ProjectPropertiesTests {
    @TempDir
    public File temp;

    @Test
    void addFromFolderAddsEclipseProperties() throws IOException {
        File file = new File(this.temp, "eclipse.properties");
        this.writeProperties(file, "2018");
        ProjectProperties properties = new ProjectProperties();
        properties.addFromFolder(this.temp);
        Assertions.assertThat((String)properties.get("copyright-year")).isEqualTo((Object)"2018");
    }

    @Test
    void addFromFolderWhenAlreadySetDoesNotOverwrite() throws IOException {
        ProjectProperties properties = new ProjectProperties();
        File folder1 = new File(this.temp, "1");
        folder1.mkdirs();
        this.writeProperties(new File(folder1, "eclipse.properties"), "2018");
        properties.addFromFolder(folder1);
        File folder2 = new File(this.temp, "2");
        folder2.mkdirs();
        this.writeProperties(new File(folder2, "eclipse.properties"), "2017");
        properties.addFromFolder(folder2);
        Assertions.assertThat((String)properties.get("copyright-year")).isEqualTo((Object)"2018");
    }

    @Test
    void addFromEmptyFolderUsesDefaults() throws IOException {
        ProjectProperties properties = new ProjectProperties();
        properties.addFromFolder(this.temp);
        String currentYear = String.valueOf(LocalDate.now().getYear());
        Assertions.assertThat((String)properties.get("copyright-year")).isEqualTo((Object)currentYear);
    }

    @Test
    void getModifiedContentReplacesCopyrightYear() throws IOException {
        String year = "2016-2020";
        File file = new File(this.temp, "eclipse.properties");
        this.writeProperties(file, year);
        ProjectProperties properties = new ProjectProperties();
        properties.addFromFolder(this.temp);
        ProjectSettingsFiles files = new ProjectSettingsFilesLocator(new File[0]).locateSettingsFiles();
        ProjectSettingsFile prefs = this.getFile(files, "org.eclipse.jdt.ui.prefs");
        String content = this.loadContent(properties.getModifiedContent(prefs).getContent(JavaFormatConfig.DEFAULT));
        Assertions.assertThat((String)content).contains(new CharSequence[]{"Copyright " + year + " the original author or authors"});
    }

    private ProjectSettingsFile getFile(ProjectSettingsFiles files, String name) {
        for (ProjectSettingsFile candidate : files) {
            if (!candidate.getName().equals(name)) continue;
            return candidate;
        }
        throw new IllegalStateException("No file " + name);
    }

    private void writeProperties(File file, String copyrightYear) throws IOException {
        Properties properties = new Properties();
        properties.setProperty("copyright-year", copyrightYear);
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            properties.store(outputStream, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String loadContent(InputStream stream) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            return reader.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

