/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.projectsettings;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

final class ProjectSettingsFile {
    private final String name;
    private final ContentSupplier contentSupplier;

    private ProjectSettingsFile(String name, ContentSupplier contentSupplier) {
        this.name = name;
        this.contentSupplier = contentSupplier;
    }

    public String getName() {
        return this.name;
    }

    public InputStream getContent() throws IOException {
        return this.contentSupplier.getContent();
    }

    public static ProjectSettingsFile fromFile(File file) {
        return new ProjectSettingsFile(file.getName(), () -> new FileInputStream(file));
    }

    public static ProjectSettingsFile fromClasspath(Class<?> sourceClass, String name) {
        return new ProjectSettingsFile(name, () -> sourceClass.getResourceAsStream(name));
    }

    @FunctionalInterface
    private static interface ContentSupplier {
        public InputStream getContent() throws IOException;
    }
}

