/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle.check;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;

public class SpringLambdaCheck
extends AbstractCheck {
    private boolean singleArgumentParentheses = true;

    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    public int[] getAcceptableTokens() {
        return new int[]{181};
    }

    public int[] getRequiredTokens() {
        return CommonUtils.EMPTY_INT_ARRAY;
    }

    public void visitToken(DetailAST ast) {
        if (ast.getType() == 181) {
            this.visitLambda(ast);
        }
    }

    private void visitLambda(DetailAST lambda) {
        DetailAST block;
        if (this.hasSingleParameter(lambda)) {
            boolean hasParentheses = this.hasToken(lambda, 76);
            if (this.singleArgumentParentheses && !hasParentheses) {
                this.log(lambda.getLineNo(), lambda.getColumnNo(), "lambda.missingParen", new Object[0]);
            } else if (!this.singleArgumentParentheses && hasParentheses && !this.isUsingParametersToDefineType(lambda)) {
                this.log(lambda.getLineNo(), lambda.getColumnNo(), "lambda.unnecessaryParen", new Object[0]);
            }
        }
        if (this.isStatementList(block = lambda.getLastChild()) && block.getChildCount(45) == 0 && !this.isNecessaryBlock(block)) {
            this.log(block.getLineNo(), block.getColumnNo(), "lambda.unnecessaryBlock", new Object[0]);
        }
    }

    private boolean hasSingleParameter(DetailAST lambda) {
        DetailAST parameters = lambda.findFirstToken(20);
        return parameters == null || parameters.getChildCount(21) == 1;
    }

    private boolean isUsingParametersToDefineType(DetailAST lambda) {
        DetailAST ast = lambda.findFirstToken(20);
        ast = ast != null ? ast.findFirstToken(21) : null;
        ast = ast != null ? ast.findFirstToken(13) : null;
        ast = ast != null ? ast.findFirstToken(58) : null;
        return ast != null;
    }

    private boolean isNecessaryBlock(DetailAST block) {
        DetailAST firstChild = block.getFirstChild();
        if (firstChild == null) {
            return false;
        }
        if (firstChild.getType() == 90) {
            return true;
        }
        if (block.getChildCount() == 1 && firstChild.getType() == 73) {
            return true;
        }
        for (DetailAST candidate = firstChild.getFirstChild(); candidate != null; candidate = candidate.getNextSibling()) {
            if (!this.isStatementList(candidate)) continue;
            return true;
        }
        return false;
    }

    private boolean isStatementList(DetailAST ast) {
        return ast != null && ast.getType() == 7;
    }

    private boolean hasToken(DetailAST ast, int type) {
        return ast.findFirstToken(type) != null;
    }

    public void setSingleArgumentParentheses(boolean singleArgumentParentheses) {
        this.singleArgumentParentheses = singleArgumentParentheses;
    }
}

