/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle.check;

import antlr.CommonAST;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import io.spring.javaformat.checkstyle.check.AbstractSpringCheck;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class SpringMethodOrderCheck
extends AbstractSpringCheck {
    private static final List<String> EXPECTED_ORDER = Collections.unmodifiableList(Arrays.asList("equals", "hashCode", "toString"));

    public int[] getAcceptableTokens() {
        return new int[]{14, 15};
    }

    public void visitToken(DetailAST ast) {
        DetailAST block = ast.findFirstToken(6);
        DetailAST candidate = block.getFirstChild();
        ArrayList<DetailAST> methods = new ArrayList<DetailAST>();
        while (candidate != null) {
            DetailAST parameters;
            DetailAST ident;
            if ((candidate = candidate.getNextSibling()) == null || candidate.getType() != 9 || !this.isOrderedMethod(ident = candidate.findFirstToken(58), parameters = candidate.findFirstToken(20))) continue;
            methods.add(ident);
        }
        this.checkOrder(methods);
    }

    private void checkOrder(List<DetailAST> methods) {
        List methodsNames = methods.stream().map(CommonAST::getText).collect(Collectors.toList());
        ArrayList<String> expected = new ArrayList<String>(EXPECTED_ORDER);
        expected.retainAll(methodsNames);
        for (int i = 0; i < methods.size(); ++i) {
            DetailAST method = methods.get(i);
            if (method.getText().equals(expected.get(i))) continue;
            this.log(method.getLineNo(), method.getColumnNo(), "methodorder.outOfOrder", new Object[]{method.getText(), expected});
        }
    }

    private boolean isOrderedMethod(DetailAST ident, DetailAST parameters) {
        if ("equals".equals(ident.getText()) && parameters.getChildCount() == 1) {
            return true;
        }
        if ("hashCode".equals(ident.getText()) && parameters.getChildCount() == 0) {
            return true;
        }
        return "toString".equals(ident.getText()) && parameters.getChildCount() == 0;
    }
}

