/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.formatter;

import io.spring.javaformat.formatter.FileEdit;
import io.spring.javaformat.formatter.FileFormatterException;
import io.spring.javaformat.formatter.Formatter;
import io.spring.javaformat.formatter.FormatterOption;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.text.edits.TextEdit;

public class FileFormatter {
    private final Formatter formatter;

    public FileFormatter() {
        this(new Formatter());
    }

    public FileFormatter(FormatterOption ... options) {
        this(new Formatter(options));
    }

    public FileFormatter(Formatter formatter) {
        Optional.ofNullable(formatter).orElseThrow(() -> new IllegalArgumentException("Formatter must not be null"));
        this.formatter = formatter;
    }

    public Stream<FileEdit> formatFiles(Iterable<File> files, Charset encoding) {
        return this.formatFiles(files, encoding, Formatter.DEFAULT_LINE_SEPARATOR);
    }

    public Stream<FileEdit> formatFiles(Iterable<File> files, Charset encoding, String lineSeparator) {
        return this.formatFiles(StreamSupport.stream(files.spliterator(), false), encoding, lineSeparator);
    }

    public Stream<FileEdit> formatFiles(Stream<File> files, Charset encoding) {
        return this.formatFiles(files, encoding, Formatter.DEFAULT_LINE_SEPARATOR);
    }

    public Stream<FileEdit> formatFiles(Stream<File> files, Charset encoding, String lineSeparator) {
        return files.map(file -> this.formatFile((File)file, encoding, lineSeparator));
    }

    public FileEdit formatFile(File file, Charset encoding) {
        return this.formatFile(file, encoding, Formatter.DEFAULT_LINE_SEPARATOR);
    }

    public FileEdit formatFile(File file, Charset encoding, String lineSeparator) {
        try {
            String content = new String(Files.readAllBytes(file.toPath()), encoding);
            TextEdit edit = this.formatter.format(content, lineSeparator);
            return new FileEdit(file, encoding, content, edit);
        }
        catch (Exception ex) {
            throw FileFormatterException.wrap(file, ex);
        }
    }
}

