/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.formatter.preparator;

import io.spring.javaformat.formatter.eclipse.Preparator;
import io.spring.javaformat.formatter.eclipse.Token;
import io.spring.javaformat.formatter.eclipse.TokenManager;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;

class CodeLineBreakPreparator
implements Preparator {
    CodeLineBreakPreparator() {
    }

    public void apply(TokenManager tokenManager, ASTNode astRoot) {
        Vistor visitor = new Vistor(tokenManager);
        astRoot.accept((ASTVisitor)visitor);
    }

    private static class Vistor
    extends ASTVisitor {
        private final TokenManager tokenManager;

        Vistor(TokenManager tokenManager) {
            this.tokenManager = tokenManager;
        }

        public boolean visit(TypeDeclaration node) {
            this.visitType((AbstractTypeDeclaration)node);
            return true;
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            this.visitType((AbstractTypeDeclaration)node);
            return true;
        }

        public boolean visit(EnumDeclaration node) {
            this.visitType((AbstractTypeDeclaration)node);
            return true;
        }

        private void visitType(AbstractTypeDeclaration node) {
            SimpleName name = node.getName();
            int openBraceIndex = name == null ? this.tokenManager.firstIndexIn((ASTNode)node, 48) : this.tokenManager.firstIndexAfter((ASTNode)name, 48);
            Token openBraceToken = this.tokenManager.get(openBraceIndex);
            openBraceToken.clearLineBreaksAfter();
            openBraceToken.putLineBreaksAfter(2);
            int closeBraceIndex = this.tokenManager.lastIndexIn((ASTNode)node, 33);
            Token closeBraceToken = this.tokenManager.get(closeBraceIndex);
            closeBraceToken.clearLineBreaksBefore();
            closeBraceToken.putLineBreaksBefore(2);
        }

        public boolean visit(FieldDeclaration node) {
            int index = this.tokenManager.lastIndexIn((ASTNode)node, 26);
            while (this.tokenIsOfType(index + 1, 1001, 1002) && this.tokenManager.get(index).getLineBreaksAfter() <= 0 && this.tokenManager.get(index + 1).getLineBreaksBefore() <= 0) {
                ++index;
            }
            Token token = this.tokenManager.get(index);
            if (this.tokenIsOfType(index + 1, 38)) {
                return true;
            }
            token.clearLineBreaksAfter();
            token.putLineBreaksAfter(2);
            return true;
        }

        private boolean tokenIsOfType(int index, int ... types) {
            if (index < this.tokenManager.size()) {
                Token token = this.tokenManager.get(index);
                for (int type : types) {
                    if (token.tokenType != type) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

