/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.gradle.tasks;

import io.spring.javaformat.config.JavaFormatConfig;
import io.spring.javaformat.formatter.FileEdit;
import io.spring.javaformat.formatter.FileFormatter;
import java.io.File;
import java.nio.charset.Charset;
import java.util.stream.Stream;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SourceTask;

public abstract class FormatterTask
extends SourceTask {
    private String encoding;

    FormatterTask() {
    }

    @Input
    @Optional
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected final Stream<FileEdit> formatFiles() {
        JavaFormatConfig javaFormatConfig = JavaFormatConfig.findFrom((File)this.getProject().getProjectDir());
        FileFormatter formatter = new FileFormatter(javaFormatConfig);
        Charset encoding = this.getEncoding() != null ? Charset.forName(this.getEncoding()) : Charset.defaultCharset();
        return formatter.formatFiles((Iterable)this.getSource().getFiles(), encoding);
    }
}

