/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.integercompression;

import me.lemire.integercompression.BitPacking;
import me.lemire.integercompression.DeltaZigzagEncoding;
import me.lemire.integercompression.IntWrapper;
import me.lemire.integercompression.IntegerCODEC;
import me.lemire.integercompression.Util;

public final class DeltaZigzagBinaryPacking
implements IntegerCODEC {
    public static final int BLOCK_LENGTH = 128;

    public void compress(int[] inBuf, IntWrapper inPos, int inLen, int[] outBuf, IntWrapper outPos) {
        int ip;
        if ((inLen -= inLen % 128) == 0) {
            return;
        }
        outBuf[outPos.get()] = inLen;
        outPos.increment();
        DeltaZigzagEncoding.Encoder ctx = new DeltaZigzagEncoding.Encoder();
        int[] work = new int[128];
        int op = outPos.get();
        int inPosLast = ip + inLen;
        for (ip = inPos.get(); ip < inPosLast; ip += 128) {
            ctx.encodeArray(inBuf, ip, 128, work);
            int bits1 = Util.maxbits32(work, 0);
            int bits2 = Util.maxbits32(work, 32);
            int bits3 = Util.maxbits32(work, 64);
            int bits4 = Util.maxbits32(work, 96);
            outBuf[op++] = bits1 << 24 | bits2 << 16 | bits3 << 8 | bits4 << 0;
            op += DeltaZigzagBinaryPacking.pack(work, 0, outBuf, op, bits1);
            op += DeltaZigzagBinaryPacking.pack(work, 32, outBuf, op, bits2);
            op += DeltaZigzagBinaryPacking.pack(work, 64, outBuf, op, bits3);
            op += DeltaZigzagBinaryPacking.pack(work, 96, outBuf, op, bits4);
        }
        inPos.add(inLen);
        outPos.set(op);
    }

    public void uncompress(int[] inBuf, IntWrapper inPos, int inLen, int[] outBuf, IntWrapper outPos) {
        int op;
        if (inLen == 0) {
            return;
        }
        int outLen = inBuf[inPos.get()];
        inPos.increment();
        DeltaZigzagEncoding.Decoder ctx = new DeltaZigzagEncoding.Decoder();
        int[] work = new int[128];
        int ip = inPos.get();
        int outPosLast = op + outLen;
        for (op = outPos.get(); op < outPosLast; op += 128) {
            int n = inBuf[ip++];
            ip += DeltaZigzagBinaryPacking.unpack(inBuf, ip, work, 0, n >> 24 & 0x3F);
            ip += DeltaZigzagBinaryPacking.unpack(inBuf, ip, work, 32, n >> 16 & 0x3F);
            ip += DeltaZigzagBinaryPacking.unpack(inBuf, ip, work, 64, n >> 8 & 0x3F);
            ip += DeltaZigzagBinaryPacking.unpack(inBuf, ip, work, 96, n >> 0 & 0x3F);
            ctx.decodeArray(work, 0, 128, outBuf, op);
        }
        outPos.add(outLen);
        inPos.set(ip);
    }

    private static int pack(int[] inBuf, int inOff, int[] outBuf, int outOff, int validBits) {
        BitPacking.fastpackwithoutmask(inBuf, inOff, outBuf, outOff, validBits);
        return validBits;
    }

    private static int unpack(int[] inBuf, int inOff, int[] outBuf, int outOff, int validBits) {
        BitPacking.fastunpack(inBuf, inOff, outBuf, outOff, validBits);
        return validBits;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

