
package net.lightapi.portal.instance.command.handler;

import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * deleteInstanceApiPathPrefix is a command side handler to delete a path prefix for an instance API.
*/
@ServiceHandler(id="lightapi.net/instance/deleteInstanceApiPathPrefix/0.1.0")
public class DeleteInstanceApiPathPrefix extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeleteInstanceApiPathPrefix.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.INSTANCE_API_PATH_PREFIX_DELETED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}
