/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.instance.command.handler;

import com.networknt.config.JsonMapper;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.utility.UuidUtil;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.impl.BaseCloudEventBuilder;
import io.undertow.server.HttpServerExchange;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.lightapi.portal.EventTypeUtil;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/instance/compositeCreateInstanceApi/0.1.0")
public class CompositeCreateInstanceApi
extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CompositeCreateInstanceApi.class);

    protected Logger getLogger() {
        return logger;
    }

    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        String hostId = (String)map.get("hostId");
        String instanceId = (String)map.get("instanceId");
        String apiId = (String)map.get("apiId");
        String apiVersion = (String)map.get("apiVersion");
        String apiVersionId = this.getApiVersionId(hostId, apiId, apiVersion);
        map.put("apiVersionId", apiVersionId);
        map.put("instanceApiId", this.getInstanceApiId(hostId, instanceId, apiVersionId));
        return Success.of(map);
    }

    protected String getCloudEventType() {
        return "CompositeInstanceApiCreatedEvent";
    }

    protected String getCloudEventAggregateId(Map<String, Object> map) {
        return (String)map.get("instanceApiId");
    }

    protected CloudEvent[] buildCloudEvent(Map<String, Object> map, String userId, String host, Number nonce) {
        ArrayList<CloudEvent> events = new ArrayList<CloudEvent>();
        events.add(this.buildApiCloudEvent(map, userId, host));
        events.add(this.buildApiVersionCloudEvent(map, userId, host));
        events.add(this.buildInstanceApiCloudEvent(map, userId, host));
        events.add(this.buildInstanceApiPathPrefixCloudEvent(map, userId, host));
        return events.toArray(new CloudEvent[0]);
    }

    private CloudEvent buildApiCloudEvent(Map<String, Object> map, String userId, String host) {
        String aggregateType = "Api";
        String apiId = (String)map.get("apiId");
        String eventType = "ApiCreatedEvent";
        if (apiId == null || apiId.isEmpty()) {
            throw new IllegalArgumentException("apiId is missing or empty in the provided data");
        }
        HashMap<String, String> apiAggregateMap = new HashMap<String, String>();
        String hostId = (String)map.get("hostId");
        apiAggregateMap.put("apiId", apiId);
        apiAggregateMap.put("hostId", hostId);
        String aggregateId = EventTypeUtil.getAggregateId((String)eventType, apiAggregateMap);
        int maxAggregateVersion = dbProvider.getMaxAggregateVersion(aggregateId);
        int newAggregateVersion = maxAggregateVersion + 1;
        BaseCloudEventBuilder eventBuilder = ((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withSource(PortalConstants.EVENT_SOURCE).withType(eventType).withId(UuidUtil.getUUID().toString()).withTime(OffsetDateTime.now()).withSubject(aggregateId).withExtension("user", userId)).withExtension("nonce", (Number)dbProvider.queryNonceByUserId(userId))).withExtension("host", host)).withExtension("aggregatetype", aggregateType)).withExtension("aggregateversion", Integer.valueOf(newAggregateVersion));
        String data = JsonMapper.toJson(this.prepareApiData(host, map));
        eventBuilder.withData("application/json", data.getBytes(StandardCharsets.UTF_8));
        if (logger.isTraceEnabled()) {
            logger.trace("Creating API event: user = {}, host = {}, type = {}, data = {}", new Object[]{userId, host, eventType, data});
        }
        return eventBuilder.build();
    }

    private CloudEvent buildApiVersionCloudEvent(Map<String, Object> map, String userId, String host) {
        String aggregateType = "ApiVersion";
        String eventType = "ApiVersionCreatedEvent";
        String apiVersionId = (String)map.get("apiVersionId");
        String apiId = (String)map.get("apiId");
        if (apiVersionId == null || apiVersionId.isEmpty()) {
            throw new IllegalArgumentException("apiVersionId is missing or empty in the provided data");
        }
        HashMap<String, String> apiAggregateMap = new HashMap<String, String>();
        apiAggregateMap.put("apiVersionId", apiVersionId);
        String aggregateId = EventTypeUtil.getAggregateId((String)eventType, apiAggregateMap);
        int maxAggregateVersion = dbProvider.getMaxAggregateVersion(aggregateId);
        int newAggregateVersion = maxAggregateVersion + 1;
        BaseCloudEventBuilder eventBuilder = ((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withSource(PortalConstants.EVENT_SOURCE).withType(eventType).withId(UuidUtil.getUUID().toString()).withTime(OffsetDateTime.now()).withSubject(aggregateId).withExtension("user", userId)).withExtension("nonce", (Number)dbProvider.queryNonceByUserId(userId))).withExtension("host", host)).withExtension("aggregatetype", aggregateType)).withExtension("aggregateversion", Integer.valueOf(newAggregateVersion));
        String data = JsonMapper.toJson(this.prepareApiVersionData(host, apiVersionId, apiId, map));
        eventBuilder.withData("application/json", data.getBytes(StandardCharsets.UTF_8));
        if (logger.isTraceEnabled()) {
            logger.trace("Creating API event: user = {}, host = {}, type = {}, data = {}", new Object[]{userId, host, eventType, data});
        }
        return eventBuilder.build();
    }

    private CloudEvent buildInstanceApiCloudEvent(Map<String, Object> map, String userId, String host) {
        String aggregateType = "InstanceApi";
        String eventType = "InstanceApiCreatedEvent";
        String instanceApiId = (String)map.get("instanceApiId");
        String apiVersionId = (String)map.get("apiVersionId");
        if (instanceApiId == null || instanceApiId.isEmpty()) {
            throw new IllegalArgumentException("instanceApiId is missing or empty in the provided data");
        }
        HashMap<String, String> apiAggregateMap = new HashMap<String, String>();
        apiAggregateMap.put("instanceApiId", instanceApiId);
        String aggregateId = EventTypeUtil.getAggregateId((String)eventType, apiAggregateMap);
        BaseCloudEventBuilder eventBuilder = ((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withSource(PortalConstants.EVENT_SOURCE).withType(eventType).withId(UuidUtil.getUUID().toString()).withTime(OffsetDateTime.now()).withSubject(aggregateId).withExtension("user", userId)).withExtension("nonce", (Number)dbProvider.queryNonceByUserId(userId))).withExtension("host", host)).withExtension("aggregatetype", aggregateType)).withExtension("aggregateversion", (Number)map.get("newAggregateVersion"));
        String data = JsonMapper.toJson(this.prepareInstanceApiData(host, apiVersionId, instanceApiId, (String)map.get("instanceId")));
        eventBuilder.withData("application/json", data.getBytes(StandardCharsets.UTF_8));
        if (logger.isTraceEnabled()) {
            logger.trace("Creating Instance Api event: user = {}, host = {}, type = {}, data = {}", new Object[]{userId, host, eventType, data});
        }
        return eventBuilder.build();
    }

    private CloudEvent buildInstanceApiPathPrefixCloudEvent(Map<String, Object> map, String userId, String host) {
        String aggregateType = "InstanceApiPathPrefix";
        String eventType = "InstanceApiPathPrefixCreatedEvent";
        String instanceApiId = (String)map.get("instanceApiId");
        String pathPrefix = (String)map.get("pathPrefix");
        if (instanceApiId == null || instanceApiId.isEmpty()) {
            throw new IllegalArgumentException("instanceApiId is missing or empty in the provided data");
        }
        if (pathPrefix == null || pathPrefix.isEmpty()) {
            throw new IllegalArgumentException("pathPrefix is missing or empty in the provided data");
        }
        HashMap<String, String> apiAggregateMap = new HashMap<String, String>();
        apiAggregateMap.put("instanceApiId", instanceApiId);
        apiAggregateMap.put("pathPrefix", pathPrefix);
        String aggregateId = EventTypeUtil.getAggregateId((String)eventType, apiAggregateMap);
        int maxAggregateVersion = dbProvider.getMaxAggregateVersion(aggregateId);
        int newAggregateVersion = maxAggregateVersion + 1;
        BaseCloudEventBuilder eventBuilder = ((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withSource(PortalConstants.EVENT_SOURCE).withType(eventType).withId(UuidUtil.getUUID().toString()).withTime(OffsetDateTime.now()).withSubject(aggregateId).withExtension("user", userId)).withExtension("nonce", (Number)dbProvider.queryNonceByUserId(userId))).withExtension("host", host)).withExtension("aggregatetype", aggregateType)).withExtension("aggregateversion", Integer.valueOf(newAggregateVersion));
        String data = JsonMapper.toJson(this.prepareInstanceApiPathPrefixData(host, instanceApiId, pathPrefix));
        eventBuilder.withData("application/json", data.getBytes(StandardCharsets.UTF_8));
        if (logger.isTraceEnabled()) {
            logger.trace("Creating Instance Api event: user = {}, host = {}, type = {}, data = {}", new Object[]{userId, host, eventType, data});
        }
        return eventBuilder.build();
    }

    private Map<String, Object> prepareApiData(String hostId, Map<String, Object> input) {
        HashMap<String, Object> apiData = new HashMap<String, Object>();
        apiData.put("hostId", hostId);
        this.applyIfNotNull("apiId", map -> map.get("apiId")).accept(input, apiData);
        this.applyIfNotNull("apiName", map -> map.get("apiName")).accept(input, apiData);
        this.applyIfNotNull("apiDesc", map -> map.get("apiDesc")).accept(input, apiData);
        this.applyIfNotNull("operationOwner", map -> map.get("operationOwner")).accept(input, apiData);
        this.applyIfNotNull("deliveryOwner", map -> map.get("deliveryOwner")).accept(input, apiData);
        this.applyIfNotNull("region", map -> map.get("region")).accept(input, apiData);
        this.applyIfNotNull("businessGroup", map -> map.get("businessGroup")).accept(input, apiData);
        this.applyIfNotNull("lob", map -> map.get("lob")).accept(input, apiData);
        this.applyIfNotNull("platform", map -> map.get("platform")).accept(input, apiData);
        this.applyIfNotNull("capability", map -> map.get("capability")).accept(input, apiData);
        this.applyIfNotNull("gitRepo", map -> map.get("gitRepo")).accept(input, apiData);
        this.applyIfNotNull("apiTags", map -> map.get("apiTags")).accept(input, apiData);
        this.applyIfNotNull("apiStatus", map -> map.get("apiStatus")).accept(input, apiData);
        return apiData;
    }

    private Map<String, Object> prepareApiVersionData(String hostId, String apiVersionId, String apiId, Map<String, Object> input) {
        HashMap<String, Object> apiVersionData = new HashMap<String, Object>();
        apiVersionData.put("hostId", hostId);
        apiVersionData.put("apiVersionId", apiVersionId);
        apiVersionData.put("apiId", apiId);
        this.applyIfNotNull("apiVersion", map -> map.get("apiVersion")).accept(input, apiVersionData);
        this.applyIfNotNull("apiType", map -> map.get("apiType")).accept(input, apiVersionData);
        this.applyIfNotNull("serviceId", map -> map.get("serviceId")).accept(input, apiVersionData);
        this.applyIfNotNull("apiVersionDesc", map -> map.get("apiVersionDesc")).accept(input, apiVersionData);
        return apiVersionData;
    }

    private Map<String, Object> prepareInstanceApiData(String hostId, String apiVersionId, String instanceApiId, String instanceId) {
        HashMap<String, Object> instanceApiData = new HashMap<String, Object>();
        instanceApiData.put("hostId", hostId);
        instanceApiData.put("apiVersionId", apiVersionId);
        instanceApiData.put("instanceApiId", instanceApiId);
        instanceApiData.put("instanceId", instanceId);
        return instanceApiData;
    }

    private Map<String, Object> prepareInstanceApiPathPrefixData(String hostId, String instanceApiId, String pathPrefix) {
        HashMap<String, Object> instanceApiPathPrefixData = new HashMap<String, Object>();
        instanceApiPathPrefixData.put("hostId", hostId);
        instanceApiPathPrefixData.put("instanceApiId", instanceApiId);
        instanceApiPathPrefixData.put("pathPrefix", pathPrefix);
        return instanceApiPathPrefixData;
    }

    private BiConsumer<Map<String, Object>, Map<String, Object>> applyIfNotNull(String key, Function<Map<String, Object>, Object> valueExtractor) {
        return (inputMap, outputMap) -> {
            Object value = valueExtractor.apply((Map<String, Object>)inputMap);
            if (value != null) {
                outputMap.put(key, value);
            }
        };
    }

    private String getApiVersionId(String hostId, String apiId, String apiVersion) {
        String apiVersionId = dbProvider.queryApiVersionId(hostId, apiId, apiVersion);
        if (apiVersionId != null && !apiVersionId.isEmpty()) {
            return apiVersionId;
        }
        return UuidUtil.getUUID().toString();
    }

    private String getInstanceApiId(String hostId, String instanceId, String apiVersionId) {
        String existingInstanceApiId = dbProvider.getInstanceApiId(hostId, instanceId, apiVersionId);
        if (existingInstanceApiId != null && !existingInstanceApiId.isEmpty()) {
            return existingInstanceApiId;
        }
        return UuidUtil.getUUID().toString();
    }
}

