/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.plugin.cluster;

import net.sourceforge.javaocr.plugin.cluster.AbstractBaseCluster;
import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.DecompositionSolver;
import org.apache.commons.math.linear.LUDecompositionImpl;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.SingularMatrixException;

public class MahalanobisDistanceCluster
extends AbstractBaseCluster {
    double[][] sumxy;
    double[][] invcov;

    public MahalanobisDistanceCluster() {
    }

    public MahalanobisDistanceCluster(int dimensions) {
        super(dimensions);
        this.sumxy = new double[dimensions][dimensions];
    }

    public MahalanobisDistanceCluster(double[] mx, double[][] invcov) {
        super(mx);
        this.invcov = invcov;
    }

    public double distance(double[] features) {
        this.getInvcov();
        double cumulated = 0.0;
        for (int i = 0; i < this.getDimensions(); ++i) {
            double xmxc = 0.0;
            for (int j = 0; j < this.getDimensions(); ++j) {
                xmxc += this.invcov[j][i] * (features[j] - this.center()[j]);
            }
            cumulated += xmxc * (features[i] - this.center()[i]);
        }
        return Math.sqrt(Math.abs(cumulated));
    }

    public void train(double[] samples) {
        super.train(samples);
        this.invcov = null;
        for (int i = 0; i < this.getDimensions(); ++i) {
            for (int j = 0; j < this.getDimensions(); ++j) {
                double[] dArray = this.sumxy[i];
                int n = j;
                dArray[n] = dArray[n] + samples[i] * samples[j];
            }
        }
    }

    double[][] matrix() {
        double[][] cov = new double[this.getDimensions()][this.getDimensions()];
        for (int i = 0; i < this.getDimensions(); ++i) {
            for (int j = 0; j < this.getDimensions(); ++j) {
                double[] dArray = cov[i];
                int n = j;
                dArray[n] = dArray[n] + (this.sumxy[i][j] / (double)this.getAmountSamples() - this.center()[i] * this.center()[j]);
            }
        }
        Array2DRowRealMatrix a = new Array2DRowRealMatrix(cov);
        DecompositionSolver solver = new LUDecompositionImpl((RealMatrix)a, Double.MIN_VALUE).getSolver();
        try {
            RealMatrix inverse = solver.getInverse();
            return inverse.getData();
        }
        catch (SingularMatrixException ex) {
            System.err.println("singular - return identity!!!!!!");
            double[][] identity = new double[this.getDimensions()][this.getDimensions()];
            for (int i = 0; i < this.getDimensions(); ++i) {
                identity[i][i] = 1.0;
            }
            return identity;
        }
    }

    public double[][] getInvcov() {
        if (this.invcov == null) {
            this.invcov = this.matrix();
        }
        return this.invcov;
    }

    public void setInvcov(double[][] invcov) {
        this.invcov = invcov;
    }
}

