/*
 * Decompiled with CFR 0.152.
 */
package net.voidnote;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.HexFormat;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.crypto.AEADBadTagException;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.voidnote.CreateOptions;
import net.voidnote.CreateResult;
import net.voidnote.ReadResult;
import net.voidnote.StreamHandle;
import net.voidnote.StreamOptions;
import net.voidnote.VoidNoteException;

public final class VoidNote {
    static final String DEFAULT_BASE = "https://voidnote.net";
    static final Gson GSON = new Gson();
    static final HttpClient HTTP = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(15L)).build();

    private VoidNote() {
    }

    public static ReadResult read(String urlOrToken) throws VoidNoteException {
        return VoidNote.readFrom(urlOrToken, DEFAULT_BASE);
    }

    public static ReadResult readFrom(String urlOrToken, String base) throws VoidNoteException {
        String token = VoidNote.extractToken(urlOrToken);
        if (token.length() != 64) {
            throw new VoidNoteException(VoidNoteException.Kind.INVALID_TOKEN, "invalid token length " + token.length() + " (want 64)");
        }
        String tokenId = token.substring(0, 32);
        String secret = token.substring(32);
        String body = VoidNote.httpGet(base + "/api/note/" + tokenId);
        NotePayload p = (NotePayload)GSON.fromJson(body, NotePayload.class);
        String content = VoidNote.decrypt(p.encrypted_content, p.iv, secret);
        return new ReadResult(content, p.title, p.view_count, p.max_views, p.destroyed);
    }

    public static CreateResult create(String content, CreateOptions opts) throws VoidNoteException {
        VoidNote.requireApiKey(opts.apiKey);
        byte[] raw = VoidNote.generateToken();
        String hex = HexFormat.of().formatHex(raw);
        String tokenId = hex.substring(0, 32);
        String secret = hex.substring(32);
        EncryptResult enc = VoidNote.encryptContent(content, secret);
        JsonObject req = new JsonObject();
        req.addProperty("tokenId", tokenId);
        req.addProperty("encryptedContent", enc.ciphertext());
        req.addProperty("iv", enc.iv());
        if (opts.maxViews != null) {
            req.addProperty("maxViews", (Number)opts.maxViews);
        }
        if (opts.ttlMinutes != null) {
            req.addProperty("ttlMinutes", (Number)opts.ttlMinutes);
        }
        if (opts.title != null) {
            req.addProperty("title", opts.title);
        }
        String resp = VoidNote.httpPost("https://voidnote.net/api/notes", GSON.toJson((JsonElement)req), opts.apiKey);
        CreatePayload p = (CreatePayload)GSON.fromJson(resp, CreatePayload.class);
        return new CreateResult("https://voidnote.net/note/" + hex, p.expires_at != null ? p.expires_at : "");
    }

    public static StreamHandle createStream(StreamOptions opts) throws VoidNoteException {
        VoidNote.requireApiKey(opts.apiKey);
        byte[] raw = VoidNote.generateToken();
        String hex = HexFormat.of().formatHex(raw);
        String tokenId = hex.substring(0, 32);
        String secret = hex.substring(32);
        byte[] key = VoidNote.deriveKey(secret);
        JsonObject req = new JsonObject();
        req.addProperty("tokenId", tokenId);
        req.addProperty("ttl", (Number)opts.ttlSeconds);
        if (opts.title != null) {
            req.addProperty("title", opts.title);
        }
        String resp = VoidNote.httpPost("https://voidnote.net/api/stream", GSON.toJson((JsonElement)req), opts.apiKey);
        StreamPayload p = (StreamPayload)GSON.fromJson(resp, StreamPayload.class);
        String siteUrl = p.siteUrl != null ? p.siteUrl : DEFAULT_BASE;
        String url = siteUrl + "/stream/" + hex;
        String expiresAt = p.expiresAt != null ? p.expiresAt : "";
        return new StreamHandle(url, expiresAt, hex, key, DEFAULT_BASE);
    }

    public static void watch(String urlOrToken, Consumer<String> onMessage) throws VoidNoteException {
        String token = VoidNote.extractToken(urlOrToken);
        if (token.length() != 64) {
            throw new VoidNoteException(VoidNoteException.Kind.INVALID_TOKEN, "invalid token length " + token.length() + " (want 64)");
        }
        byte[] key = VoidNote.deriveKey(token.substring(32));
        VoidNote.watchSse("https://voidnote.net/api/stream/" + token + "/events", key, onMessage);
    }

    static void watchSse(String sseUrl, byte[] key, Consumer<String> onMessage) throws VoidNoteException {
        String lastId = "";
        while (true) {
            try {
                block6: while (true) {
                    HttpRequest.Builder rb = HttpRequest.newBuilder().uri(URI.create(sseUrl)).GET();
                    if (!lastId.isEmpty()) {
                        rb.header("Last-Event-ID", lastId);
                    }
                    HttpClient sseClient = HttpClient.newHttpClient();
                    HttpResponse<Stream<String>> resp = sseClient.send(rb.build(), HttpResponse.BodyHandlers.ofLines());
                    String eventId = "";
                    StringBuilder eventData = new StringBuilder();
                    Iterator iterator = ((Iterable)resp.body()::iterator).iterator();
                    while (true) {
                        JsonObject data;
                        String type;
                        if (!iterator.hasNext()) continue block6;
                        String line = (String)iterator.next();
                        if (line.startsWith("id: ")) {
                            eventId = line.substring(4);
                            continue;
                        }
                        if (line.startsWith("data: ")) {
                            eventData.append(line.substring(6));
                            continue;
                        }
                        if (!line.isEmpty() || eventData.length() <= 0) continue;
                        if (!eventId.isEmpty()) {
                            lastId = eventId;
                        }
                        String string = type = (data = (JsonObject)GSON.fromJson(eventData.toString(), JsonObject.class)).has("type") ? data.get("type").getAsString() : "";
                        if ("closed".equals(type) || "expired".equals(type)) {
                            return;
                        }
                        if (data.has("enc")) {
                            String enc = data.get("enc").getAsString();
                            String iv = data.get("iv").getAsString();
                            String content = VoidNote.decryptWithKey(enc, iv, key);
                            onMessage.accept(content);
                        }
                        eventId = "";
                        eventData.setLength(0);
                    }
                    break;
                }
            }
            catch (VoidNoteException e) {
                throw e;
            }
            catch (Exception e) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    static byte[] generateToken() {
        byte[] raw = new byte[32];
        new SecureRandom().nextBytes(raw);
        return raw;
    }

    static byte[] deriveKey(String secret) throws VoidNoteException {
        try {
            byte[] secretBytes = HexFormat.of().parseHex(secret);
            return MessageDigest.getInstance("SHA-256").digest(secretBytes);
        }
        catch (Exception e) {
            throw new VoidNoteException(VoidNoteException.Kind.API, "key derivation failed", e);
        }
    }

    static EncryptResult encryptContent(String plaintext, String secret) throws VoidNoteException {
        return VoidNote.encryptWithKey(plaintext, VoidNote.deriveKey(secret));
    }

    static EncryptResult encryptWithKey(String plaintext, byte[] key) throws VoidNoteException {
        try {
            byte[] iv = new byte[12];
            new SecureRandom().nextBytes(iv);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, (Key)new SecretKeySpec(key, "AES"), new GCMParameterSpec(128, iv));
            byte[] ciphertext = cipher.doFinal(plaintext.getBytes(StandardCharsets.UTF_8));
            HexFormat hex = HexFormat.of();
            return new EncryptResult(hex.formatHex(ciphertext), hex.formatHex(iv));
        }
        catch (Exception e) {
            throw new VoidNoteException(VoidNoteException.Kind.API, "encryption failed", e);
        }
    }

    static String decrypt(String encryptedHex, String ivHex, String secret) throws VoidNoteException {
        return VoidNote.decryptWithKey(encryptedHex, ivHex, VoidNote.deriveKey(secret));
    }

    static String decryptWithKey(String encryptedHex, String ivHex, byte[] key) throws VoidNoteException {
        try {
            HexFormat hex = HexFormat.of();
            byte[] ciphertext = hex.parseHex(encryptedHex);
            byte[] iv = hex.parseHex(ivHex);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)new SecretKeySpec(key, "AES"), new GCMParameterSpec(128, iv));
            byte[] plaintext = cipher.doFinal(ciphertext);
            return new String(plaintext, StandardCharsets.UTF_8);
        }
        catch (AEADBadTagException e) {
            throw new VoidNoteException(VoidNoteException.Kind.DECRYPTION_FAILED, "decryption failed \u2014 tampered data or wrong key", e);
        }
        catch (Exception e) {
            throw new VoidNoteException(VoidNoteException.Kind.DECRYPTION_FAILED, "decryption failed", e);
        }
    }

    static String httpGet(String url) throws VoidNoteException {
        try {
            HttpResponse<String> resp = HTTP.send(HttpRequest.newBuilder().uri(URI.create(url)).GET().timeout(Duration.ofSeconds(15L)).build(), HttpResponse.BodyHandlers.ofString());
            return VoidNote.checkStatus(resp);
        }
        catch (VoidNoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VoidNoteException(VoidNoteException.Kind.NETWORK, "request failed", e);
        }
    }

    static String httpPost(String url, String body, String apiKey) throws VoidNoteException {
        try {
            HttpRequest.Builder rb = HttpRequest.newBuilder().uri(URI.create(url)).POST(HttpRequest.BodyPublishers.ofString(body)).header("Content-Type", "application/json").timeout(Duration.ofSeconds(15L));
            if (apiKey != null && !apiKey.isEmpty()) {
                rb.header("Authorization", "Bearer " + apiKey);
            }
            HttpResponse<String> resp = HTTP.send(rb.build(), HttpResponse.BodyHandlers.ofString());
            return VoidNote.checkStatus(resp);
        }
        catch (VoidNoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VoidNoteException(VoidNoteException.Kind.NETWORK, "request failed", e);
        }
    }

    private static String checkStatus(HttpResponse<String> resp) throws VoidNoteException {
        switch (resp.statusCode()) {
            case 200: 
            case 201: {
                break;
            }
            case 404: {
                throw new VoidNoteException(VoidNoteException.Kind.NOT_FOUND, "not found or already destroyed");
            }
            case 401: {
                throw new VoidNoteException(VoidNoteException.Kind.UNAUTHORIZED, "unauthorized \u2014 check your API key");
            }
            default: {
                throw new VoidNoteException(VoidNoteException.Kind.API, "server returned " + resp.statusCode() + ": " + resp.body());
            }
        }
        return resp.body();
    }

    static String extractToken(String urlOrToken) {
        if (urlOrToken.startsWith("http")) {
            String[] parts = urlOrToken.split("/");
            String last = parts[parts.length - 1];
            int hash = last.indexOf(35);
            if (hash >= 0) {
                last = last.substring(hash + 1);
            }
            return last;
        }
        return urlOrToken;
    }

    private static void requireApiKey(String apiKey) throws VoidNoteException {
        if (apiKey == null || apiKey.isEmpty()) {
            throw new VoidNoteException(VoidNoteException.Kind.API, "apiKey is required");
        }
    }

    private static class NotePayload {
        String encrypted_content;
        String iv;
        String title;
        int view_count;
        int max_views;
        boolean destroyed;

        private NotePayload() {
        }
    }

    record EncryptResult(String ciphertext, String iv) {
    }

    private static class CreatePayload {
        String expires_at;

        private CreatePayload() {
        }
    }

    private static class StreamPayload {
        String siteUrl;
        String expiresAt;

        private StreamPayload() {
        }
    }
}

