/*
 * Decompiled with CFR 0.152.
 */
package xapi.bytecode.impl;

import java.lang.annotation.Annotation;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import xapi.bytecode.impl.BytecodeAdapterService;
import xapi.bytecode.impl.OuterTestClass;
import xapi.source.X_Source;
import xapi.source.api.HasAnnotations;
import xapi.source.api.IsAnnotation;
import xapi.source.api.IsAnnotationValue;
import xapi.source.api.IsClass;
import xapi.source.api.IsField;
import xapi.source.api.IsMethod;
import xapi.source.api.IsType;

public class BytecodeAdapterServiceTest {
    private static BytecodeAdapterService service;

    @BeforeClass
    public static void extractClassFile() {
        service = new BytecodeAdapterService();
    }

    @Test
    public void testArrayParser() {
        IsClass clsArray = service.toClass("java.lang.Class[]");
        Assert.assertNotNull((Object)clsArray);
    }

    @Test
    public void testAnnoNoArgs() {
        IsClass asClass = service.toClass(OuterTestClass.NoTargetAnno.class.getName());
        IsAnnotation anno = asClass.getAnnotation(Target.class.getName());
        IsAnnotationValue empty = anno.getValue(anno.getMethod("value", new IsType[0]));
        Assert.assertTrue((boolean)empty.isArray());
        Assert.assertEquals((long)0L, (long)Array.getLength(empty.getRawValue()));
    }

    @Test
    public void testTestClass() {
        Class<?> cls = this.getTestClass();
        IsClass asClass = service.toClass(cls.getName());
        Assert.assertEquals((Object)asClass.getPackage(), (Object)cls.getPackage().getName());
        Assert.assertEquals((Object)asClass.getEnclosedName(), (Object)X_Source.classToEnclosedSourceName(cls));
        Assert.assertEquals((long)asClass.getModifier(), (long)cls.getModifiers());
        this.testAnnos(cls.getDeclaredAnnotations(), (HasAnnotations)asClass);
    }

    @Test
    public void testTestClass_Methods() {
        Class<?> cls = this.getTestClass();
        IsClass asClass = service.toClass(cls.getName());
        for (Method method : cls.getMethods()) {
            IsMethod imethod = asClass.getMethod(method.getName(), true, (Class[])method.getParameterTypes());
            String testCase = imethod.getQualifiedName() + " != " + method.getName();
            Assert.assertNotNull((String)testCase, (Object)imethod);
            Assert.assertEquals((String)testCase, (Object)method.getName(), (Object)imethod.getName());
            Assert.assertEquals((String)testCase, (long)method.getModifiers(), (long)imethod.getModifier());
            Assert.assertEquals((String)testCase, (Object)imethod.getReturnType().getQualifiedName(), (Object)method.getReturnType().getCanonicalName());
            Assert.assertTrue((String)testCase, (boolean)X_Source.typesEqual((IsType[])imethod.getParameters(), (Class[])method.getParameterTypes()));
            Assert.assertTrue((String)testCase, (boolean)X_Source.typesEqual((IsType[])imethod.getExceptions(), (Class[])method.getExceptionTypes()));
            this.testAnnos(method.getDeclaredAnnotations(), (HasAnnotations)imethod);
        }
    }

    @Test
    public void testTestClass_Fields() {
        Class<?> cls = this.getTestClass();
        IsClass asClass = service.toClass(cls.getName());
        for (Field field : cls.getFields()) {
            IsField ifield = asClass.getField(field.getName());
            Assert.assertNotNull((String)field.getName(), (Object)ifield);
            Assert.assertEquals((Object)field.getName(), (Object)ifield.getDeclaredName());
            Assert.assertEquals((long)field.getModifiers(), (long)ifield.getModifier());
            this.testAnnos(field.getDeclaredAnnotations(), (HasAnnotations)ifield);
        }
    }

    private void testAnnos(Annotation[] runtimeAnnotations, HasAnnotations hasAnnos) {
        for (Annotation anno : runtimeAnnotations) {
            IsAnnotation isAnno = hasAnnos.getAnnotation(anno.annotationType().getCanonicalName());
            Assert.assertNotNull((String)("Missing annotation " + anno + " on " + hasAnnos), (Object)isAnno);
            Assert.assertEquals((Object)anno.annotationType().getCanonicalName(), (Object)isAnno.getQualifiedName());
        }
        int cnt = 0;
        for (IsAnnotation anno : hasAnnos.getAnnotations()) {
            if (!anno.isRuntime()) continue;
            ++cnt;
        }
        Assert.assertEquals((long)runtimeAnnotations.length, (long)cnt);
    }

    protected Class<?> getTestClass() {
        return OuterTestClass.class;
    }
}

