/*
 * Decompiled with CFR 0.152.
 */
package xapi.bytecode;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import xapi.bytecode.Annotated;
import xapi.bytecode.annotation.Annotation;
import xapi.bytecode.annotation.AnnotationsAttribute;
import xapi.bytecode.attributes.AttributeInfo;

public abstract class MemberInfo
implements Annotated {
    private static WeakHashMap<MemberInfo, Map<String, Annotation>> cache = new WeakHashMap();
    ArrayList<AttributeInfo> attribute;

    public List<AttributeInfo> getAttributes() {
        if (this.attribute == null) {
            this.attribute = new ArrayList();
        }
        return this.attribute;
    }

    public AttributeInfo getAttribute(String name) {
        return AttributeInfo.lookup(this.attribute, name);
    }

    @Override
    public Annotation[] getAnnotations() {
        if (!cache.containsKey(this)) {
            this.loadAnnotations();
        }
        return cache.get(this).values().toArray(new Annotation[0]);
    }

    @Override
    public Annotation getAnnotation(String annoName) {
        Map<String, Annotation> map = cache.get(this);
        if (map == null) {
            map = this.loadAnnotations();
        }
        return map.get(annoName);
    }

    public boolean hasAnnotation(String annoName) {
        return cache.containsKey(this) && cache.get(this).containsKey(annoName);
    }

    private Map<String, Annotation> loadAnnotations() {
        AttributeInfo invis;
        LinkedHashMap<String, Annotation> annos = new LinkedHashMap<String, Annotation>();
        cache.put(this, annos);
        AttributeInfo vis = this.getAttribute("RuntimeVisibleAnnotations");
        if (vis != null) {
            for (Annotation anno : ((AnnotationsAttribute)vis).getAnnotations()) {
                annos.put(anno.getTypeName(), anno);
            }
        }
        if ((invis = this.getAttribute("RuntimeInvisibleAnnotations")) != null) {
            for (Annotation anno : ((AnnotationsAttribute)invis).getAnnotations()) {
                annos.put(anno.getTypeName(), anno);
            }
        }
        return annos;
    }

    public abstract String getSignature();

    public boolean equals(Object obj) {
        return obj instanceof MemberInfo && this.getSignature().equals(((MemberInfo)obj).getSignature());
    }

    public int hashCode() {
        return this.getSignature().hashCode();
    }
}

