/*
 * Decompiled with CFR 0.152.
 */
package xapi.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import xapi.bytecode.ConstInfo;
import xapi.bytecode.ConstPool;
import xapi.bytecode.Descriptor;

class NameAndTypeInfo
extends ConstInfo {
    static final int tag = 12;
    int memberName;
    int typeDescriptor;

    public NameAndTypeInfo(int name, int type) {
        this.memberName = name;
        this.typeDescriptor = type;
    }

    public NameAndTypeInfo(DataInput in) throws IOException {
        this.memberName = in.readUnsignedShort();
        this.typeDescriptor = in.readUnsignedShort();
    }

    @Override
    boolean hashCheck(int a, int b) {
        return a == this.memberName && b == this.typeDescriptor;
    }

    @Override
    public int getTag() {
        return 12;
    }

    @Override
    public void renameClass(ConstPool cp, String oldName, String newName) {
        String type2;
        String type = cp.getUtf8Info(this.typeDescriptor);
        if (type != (type2 = Descriptor.rename(type, oldName, newName))) {
            this.typeDescriptor = cp.addUtf8Info(type2);
        }
    }

    @Override
    public void renameClass(ConstPool cp, Map<?, ?> map) {
        String type2;
        String type = cp.getUtf8Info(this.typeDescriptor);
        if (type != (type2 = Descriptor.rename(type, map))) {
            this.typeDescriptor = cp.addUtf8Info(type2);
        }
    }

    @Override
    public int copy(ConstPool src, ConstPool dest, Map<?, ?> map) {
        String mname = src.getUtf8Info(this.memberName);
        String tdesc = src.getUtf8Info(this.typeDescriptor);
        tdesc = Descriptor.rename(tdesc, map);
        return dest.addNameAndTypeInfo(dest.addUtf8Info(mname), dest.addUtf8Info(tdesc));
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(12);
        out.writeShort(this.memberName);
        out.writeShort(this.typeDescriptor);
    }

    @Override
    public void print(PrintWriter out) {
        out.print("NameAndType #");
        out.print(this.memberName);
        out.print(", type #");
        out.println(this.typeDescriptor);
    }
}

