/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.CheckedChange;
import org.androidannotations.handler.AbstractListenerHandler;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class CheckedChangeHandler
extends AbstractListenerHandler {
    public CheckedChangeHandler(ProcessingEnvironment processingEnvironment) {
        super(CheckedChange.class, processingEnvironment);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        super.validate(element, validatedElements, valid);
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.returnTypeIsVoid(executableElement, valid);
        this.validatorHelper.param.hasZeroOrOneCompoundButtonParameter(executableElement, valid);
        this.validatorHelper.param.hasZeroOrOneBooleanParameter(executableElement, valid);
        this.validatorHelper.param.hasNoOtherParameterThanCompoundButtonOrBoolean(executableElement, valid);
    }

    @Override
    protected void makeCall(JBlock listenerMethodBody, JInvocation call, TypeMirror returnType) {
        listenerMethodBody.add(call);
    }

    @Override
    protected void processParameters(EComponentWithViewSupportHolder holder, JMethod listenerMethod, JInvocation call, List<? extends VariableElement> parameters) {
        JVar btnParam = listenerMethod.param(this.classes().COMPOUND_BUTTON, "buttonView");
        JVar isCheckedParam = listenerMethod.param(this.codeModel().BOOLEAN, "isChecked");
        for (VariableElement variableElement : parameters) {
            String parameterType = variableElement.asType().toString();
            if (parameterType.equals("android.widget.CompoundButton")) {
                call.arg(btnParam);
                continue;
            }
            if (!parameterType.equals(CanonicalNameConstants.BOOLEAN) && variableElement.asType().getKind() != TypeKind.BOOLEAN) continue;
            call.arg(isCheckedParam);
        }
    }

    @Override
    protected JMethod createListenerMethod(JDefinedClass listenerAnonymousClass) {
        return listenerAnonymousClass.method(1, this.codeModel().VOID, "onCheckedChanged");
    }

    @Override
    protected String getSetterName() {
        return "setOnCheckedChangeListener";
    }

    @Override
    protected JClass getListenerClass() {
        return this.classes().COMPOUND_BUTTON_ON_CHECKED_CHANGE_LISTENER;
    }

    @Override
    protected JClass getViewClass() {
        return this.classes().COMPOUND_BUTTON;
    }
}

