/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.model;

import com.sun.codemodel.JFieldRef;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.holder.EComponentHolder;

public class AndroidSystemServices {
    private Map<String, String> registeredServices = new HashMap<String, String>();

    public AndroidSystemServices() {
        this.registeredServices.put("android.view.accessibility.AccessibilityManager", "android.content.Context.ACCESSIBILITY_SERVICE");
        this.registeredServices.put("android.accounts.AccountManager", "android.content.Context.ACCOUNT_SERVICE");
        this.registeredServices.put("android.app.ActivityManager", "android.content.Context.ACTIVITY_SERVICE");
        this.registeredServices.put("android.app.AlarmManager", "android.content.Context.ALARM_SERVICE");
        this.registeredServices.put("android.app.AppOpsManager", "android.content.Context.APP_OPS_SERVICE");
        this.registeredServices.put("android.appwidget.AppWidgetManager", "android.content.Context.APPWIDGET_SERVICE");
        this.registeredServices.put("android.media.AudioManager", "android.content.Context.AUDIO_SERVICE");
        this.registeredServices.put("android.app.backup.IBackupManager", "android.content.Context.BACKUP_SERVICE");
        this.registeredServices.put("android.os.BatteryManager", "android.content.Context.BATTERY_SERVICE");
        this.registeredServices.put("android.bluetooth.BluetoothManager", "android.content.Context.BLUETOOTH_SERVICE");
        this.registeredServices.put("android.hardware.camera2.CameraManager", "android.content.Context.CAMERA_SERVICE");
        this.registeredServices.put("android.view.accessibility.CaptioningManager", "android.content.Context.CAPTIONING_SERVICE");
        this.registeredServices.put("android.content.ClipboardManager", "android.content.Context.CLIPBOARD_SERVICE");
        this.registeredServices.put("android.text.ClipboardManager", "android.content.Context.CLIPBOARD_SERVICE");
        this.registeredServices.put("android.net.ConnectivityManager", "android.content.Context.CONNECTIVITY_SERVICE");
        this.registeredServices.put("android.hardware.ConsumerIrManager", "android.content.Context.CONSUMER_IR_SERVICE");
        this.registeredServices.put("android.location.CountryDetector", "android.content.Context.COUNTRY_DETECTOR");
        this.registeredServices.put("android.app.admin.DevicePolicyManager", "android.content.Context.DEVICE_POLICY_SERVICE");
        this.registeredServices.put("android.hardware.display.DisplayManager", "android.content.Context.DISPLAY_SERVICE");
        this.registeredServices.put("android.app.DownloadManager", "android.content.Context.DOWNLOAD_SERVICE");
        this.registeredServices.put("android.os.DropBoxManager", "android.content.Context.DROPBOX_SERVICE");
        this.registeredServices.put("android.net.EthernetManager", "android.content.Context.ETHERNET_SERVICE");
        this.registeredServices.put("android.service.fingerprint.FingerprintManager", "android.content.Context.FINGERPRINT_SERVICE");
        this.registeredServices.put("android.hardware.hdmi.HdmiControlManager", "android.content.Context.HDMI_CONTROL_SERVICE");
        this.registeredServices.put("android.hardware.input.InputManager", "android.content.Context.INPUT_SERVICE");
        this.registeredServices.put("android.view.inputmethod.InputMethodManager", "android.content.Context.INPUT_METHOD_SERVICE");
        this.registeredServices.put("android.app.job.JobScheduler", "android.content.Context.JOB_SCHEDULER_SERVICE");
        this.registeredServices.put("android.app.KeyguardManager", "android.content.Context.KEYGUARD_SERVICE");
        this.registeredServices.put("android.content.pm.LauncherApps", "android.content.Context.LAUNCHER_APPS_SERVICE");
        this.registeredServices.put("android.view.LayoutInflater", "android.content.Context.LAYOUT_INFLATER_SERVICE");
        this.registeredServices.put("android.location.LocationManager", "android.content.Context.LOCATION_SERVICE");
        this.registeredServices.put("android.media.projection.MediaProjectionManager", "android.content.Context.MEDIA_PROJECTION_SERVICE");
        this.registeredServices.put("android.media.MediaRouter", "android.content.Context.MEDIA_ROUTER_SERVICE");
        this.registeredServices.put("android.media.session.MediaSessionManager", "android.content.Context.MEDIA_SESSION_SERVICE");
        this.registeredServices.put("android.net.NetworkScoreManager", "android.content.Context.NETWORK_SCORE_SERVICE");
        this.registeredServices.put("android.net.NetworkManagementService", "android.content.Context.NETWORKMANAGEMENT_SERVICE");
        this.registeredServices.put("android.net.NetworkPolicyManager", "android.content.Context.NETWORK_POLICY_SERVICE");
        this.registeredServices.put("android.net.NetworkStatsService", "android.content.Context.NETWORK_STATS_SERVICE");
        this.registeredServices.put("android.nfc.NfcManager", "android.content.Context.NFC_SERVICE");
        this.registeredServices.put("android.app.NotificationManager", "android.content.Context.NOTIFICATION_SERVICE");
        this.registeredServices.put("android.net.nsd.NsdManager", "android.content.Context.NSD_SERVICE");
        this.registeredServices.put("android.service.persistentdata.PersistentDataBlockManager", "android.content.Context.PERSISTENT_DATA_BLOCK_SERVICE");
        this.registeredServices.put("android.print.PrintManager", "android.content.Context.PRINT_SERVICE");
        this.registeredServices.put("android.os.PowerManager", "android.content.Context.POWER_SERVICE");
        this.registeredServices.put("android.content.RestrictionsManager", "android.content.Context.RESTRICTIONS_SERVICE");
        this.registeredServices.put("android.app.SearchManager", "android.content.Context.SEARCH_SERVICE");
        this.registeredServices.put("android.hardware.SerialManager", "android.content.Context.SERIAL_SERVICE");
        this.registeredServices.put("android.hardware.SensorManager", "android.content.Context.SENSOR_SERVICE");
        this.registeredServices.put("android.net.sip.SipManager", "android.content.Context.SIP_SERVICE");
        this.registeredServices.put("android.app.StatusBarManager", "android.content.Context.STATUS_BAR_SERVICE");
        this.registeredServices.put("android.os.storage.StorageManager", "android.content.Context.STORAGE_SERVICE");
        this.registeredServices.put("android.telephony.SubscriptionManager", "android.content.Context.TELEPHONY_SUBSCRIPTION_SERVICE");
        this.registeredServices.put("android.telecom.TelecomManager", "android.content.Context.TELECOM_SERVICE");
        this.registeredServices.put("android.telephony.TelephonyManager", "android.content.Context.TELEPHONY_SERVICE");
        this.registeredServices.put("android.view.textservice.TextServicesManager", "android.content.Context.TEXT_SERVICES_MANAGER_SERVICE");
        this.registeredServices.put("android.net.ThrottleManager", "android.content.Context.THROTTLE_SERVICE");
        this.registeredServices.put("android.media.tv.TvInputManager", "android.content.Context.TV_INPUT_SERVICE");
        this.registeredServices.put("android.app.UiModeManager", "android.content.Context.UI_MODE_SERVICE");
        this.registeredServices.put("android.os.IUpdateLock", "android.content.Context.UPDATE_LOCK_SERVICE");
        this.registeredServices.put("android.app.usage.UsageStatsManager", "android.content.Context.USAGE_STATS_SERVICE");
        this.registeredServices.put("android.hardware.usb.UsbManager", "android.content.Context.USB_SERVICE");
        this.registeredServices.put("android.os.UserManager", "android.content.Context.USER_SERVICE");
        this.registeredServices.put("android.os.Vibrator", "android.content.Context.VIBRATOR_SERVICE");
        this.registeredServices.put("android.app.WallpaperManager", "android.content.Context.WALLPAPER_SERVICE");
        this.registeredServices.put("android.net.wifi.WifiManager", "android.content.Context.WIFI_SERVICE");
        this.registeredServices.put("android.net.wifi.passpoint.WifiPasspointManager", "android.content.Context.WIFI_PASSPOINT_SERVICE");
        this.registeredServices.put("android.net.wifi.p2p.WifiP2pManager", "android.content.Context.WIFI_P2P_SERVICE");
        this.registeredServices.put("android.view.WindowManager", "android.content.Context.WINDOW_SERVICE");
    }

    public boolean contains(TypeMirror serviceType) {
        return this.registeredServices.containsKey(serviceType.toString());
    }

    public String getServiceConstant(TypeMirror serviceType) {
        return this.registeredServices.get(serviceType.toString());
    }

    public JFieldRef getServiceConstant(TypeMirror serviceType, EComponentHolder holder) {
        return this.extractIdStaticRef(holder, this.getServiceConstant(serviceType));
    }

    private JFieldRef extractIdStaticRef(EComponentHolder holder, String staticFieldQualifiedName) {
        if (staticFieldQualifiedName != null) {
            int fieldSuffix = staticFieldQualifiedName.lastIndexOf(46);
            String fieldName = staticFieldQualifiedName.substring(fieldSuffix + 1);
            String className = staticFieldQualifiedName.substring(0, fieldSuffix);
            return holder.refClass(className).staticRef(fieldName);
        }
        return null;
    }
}

