/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JStatement;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.SystemService;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class SystemServiceHandler
extends BaseAnnotationHandler<EComponentHolder> {
    public SystemServiceHandler(ProcessingEnvironment processingEnvironment) {
        super(SystemService.class, processingEnvironment);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEnhancedComponentAnnotation(element, validatedElements, valid);
        this.validatorHelper.androidService(this.androidSystemServices, element, valid);
        this.validatorHelper.isNotPrivate(element, valid);
    }

    @Override
    public void process(Element element, EComponentHolder holder) {
        String fieldName = element.getSimpleName().toString();
        TypeMirror serviceType = element.asType();
        String fieldTypeQualifiedName = serviceType.toString();
        JFieldRef serviceRef = this.androidSystemServices.getServiceConstant(serviceType, holder);
        JBlock methodBody = holder.getInitBody();
        if ("android.appwidget.AppWidgetManager".equals(fieldTypeQualifiedName)) {
            this.createSpecialInjection(holder, fieldName, fieldTypeQualifiedName, serviceRef, methodBody, 21, "LOLLIPOP", holder.classes().APP_WIDGET_MANAGER, "getInstance", true);
        } else {
            methodBody.add(this.createNormalInjection(holder, fieldName, fieldTypeQualifiedName, serviceRef, methodBody));
        }
    }

    private void createSpecialInjection(EComponentHolder holder, String fieldName, String fieldTypeQualifiedName, JFieldRef serviceRef, JBlock methodBody, int apiLevel, String apiLevelName, JClass serviceClass, String injectionMethodName, boolean contextNeeded) {
        if (this.androidManifest.getMinSdkVersion() >= apiLevel) {
            methodBody.add(this.createNormalInjection(holder, fieldName, fieldTypeQualifiedName, serviceRef, methodBody));
        } else {
            JInvocation injectionMethodInvokation = serviceClass.staticInvoke(injectionMethodName);
            if (contextNeeded) {
                injectionMethodInvokation.arg(holder.getContextRef());
            }
            JStatement oldInjection = (JStatement)((Object)JExpr.assign(JExpr.ref(fieldName), injectionMethodInvokation));
            if (this.isApiOnClasspath(apiLevelName)) {
                JConditional conditional = methodBody._if(holder.classes().BUILD_VERSION.staticRef("SDK_INT").gte(holder.classes().BUILD_VERSION_CODES.staticRef(apiLevelName)));
                conditional._then().add(this.createNormalInjection(holder, fieldName, fieldTypeQualifiedName, serviceRef, methodBody));
                conditional._else().add(oldInjection);
            } else {
                methodBody.add(oldInjection);
            }
        }
    }

    private JStatement createNormalInjection(EComponentHolder holder, String fieldName, String fieldTypeQualifiedName, JFieldRef serviceRef, JBlock methodBody) {
        return (JStatement)((Object)JExpr.assign(JExpr.ref(fieldName), JExpr.cast(this.refClass(fieldTypeQualifiedName), holder.getContextRef().invoke("getSystemService").arg(serviceRef))));
    }

    private boolean isApiOnClasspath(String apiName) {
        TypeElement typeElement = this.processingEnvironment().getElementUtils().getTypeElement("android.os.Build.VERSION_CODES");
        for (Element element : typeElement.getEnclosedElements()) {
            if (!element.getSimpleName().contentEquals(apiName)) continue;
            return true;
        }
        return false;
    }
}

