/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

public class Option<T> {
    private static final Option<?> ABSENT = new Option<Object>(null, false);
    private final T reference;
    private final boolean isPresent;

    public static <T> Option<T> of(T value) {
        return new Option<T>(value, true);
    }

    public static <T> Option<T> absent() {
        return ABSENT;
    }

    private Option(T reference, boolean isPresent) {
        this.reference = reference;
        this.isPresent = isPresent;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public boolean isAbsent() {
        return !this.isPresent;
    }

    public T get() {
        if (!this.isPresent) {
            throw new IllegalStateException("value is absent");
        }
        return this.reference;
    }

    public T getOr(T defaultValue) {
        if (this.isPresent) {
            return this.reference;
        }
        return defaultValue;
    }
}

