/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.logger.formatter;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.androidannotations.logger.Level;
import org.androidannotations.logger.Logger;

public abstract class Formatter {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("HH:mm:ss.S");
    private static final String ARGS_PATTERN = "{}";
    private static final int ARGS_PATTERN_LENGTH = "{}".length();

    public abstract String buildLog(Level var1, String var2, String var3, Throwable var4, Object ... var5);

    protected String getCurrentThread() {
        return Thread.currentThread().getName();
    }

    protected String getTime() {
        return DATE_FORMAT.format(new Date());
    }

    protected String buildFullMessage(String message, Object ... args) {
        int argPos;
        StringBuilder stringBuilder = new StringBuilder(message.length());
        int lastIndex = 0;
        int argIndex = 0;
        while ((argPos = message.indexOf(ARGS_PATTERN, lastIndex)) != -1) {
            stringBuilder.append(message.substring(lastIndex, argPos));
            lastIndex = argPos + ARGS_PATTERN_LENGTH;
            if (argIndex >= args.length) continue;
            stringBuilder.append(this.formatArgument(args[argIndex]));
            ++argIndex;
        }
        stringBuilder.append(message.substring(lastIndex));
        return stringBuilder.toString();
    }

    protected String formatArgument(Object arg) {
        if (arg != null && arg.getClass().isArray()) {
            return Arrays.toString((Object[])arg);
        }
        return arg.toString();
    }

    protected String stackTraceToString(Throwable e) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        e.printStackTrace(pw);
        return writer.toString();
    }

    protected int getCallerLineNumber() {
        StackTraceElement[] stackTrace;
        boolean previousWasLogger = false;
        String loggerClassName = Logger.class.getCanonicalName();
        for (StackTraceElement stackTraceElement : stackTrace = Thread.currentThread().getStackTrace()) {
            if (stackTraceElement.getClassName().equals(loggerClassName)) {
                previousWasLogger = true;
                continue;
            }
            if (!previousWasLogger) continue;
            return stackTraceElement.getLineNumber();
        }
        return -1;
    }
}

