/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.asteriskjava.AsteriskVersion;
import org.asteriskjava.config.ConfigFile;
import org.asteriskjava.live.AsteriskAgent;
import org.asteriskjava.live.AsteriskChannel;
import org.asteriskjava.live.AsteriskQueue;
import org.asteriskjava.live.AsteriskQueueEntry;
import org.asteriskjava.live.AsteriskServer;
import org.asteriskjava.live.AsteriskServerListener;
import org.asteriskjava.live.CallerId;
import org.asteriskjava.live.ChannelState;
import org.asteriskjava.live.ManagerCommunicationException;
import org.asteriskjava.live.MeetMeRoom;
import org.asteriskjava.live.MeetMeUser;
import org.asteriskjava.live.NoSuchChannelException;
import org.asteriskjava.live.OriginateCallback;
import org.asteriskjava.live.Voicemailbox;
import org.asteriskjava.live.internal.AgentManager;
import org.asteriskjava.live.internal.AsteriskAgentImpl;
import org.asteriskjava.live.internal.AsteriskChannelImpl;
import org.asteriskjava.live.internal.ChannelManager;
import org.asteriskjava.live.internal.ConfigFileImpl;
import org.asteriskjava.live.internal.ManagerCommunicationExceptionMapper;
import org.asteriskjava.live.internal.MeetMeManager;
import org.asteriskjava.live.internal.OriginateCallbackData;
import org.asteriskjava.live.internal.QueueManager;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.ManagerConnectionState;
import org.asteriskjava.manager.ManagerEventListener;
import org.asteriskjava.manager.ManagerEventListenerProxy;
import org.asteriskjava.manager.ResponseEvents;
import org.asteriskjava.manager.action.CommandAction;
import org.asteriskjava.manager.action.DbGetAction;
import org.asteriskjava.manager.action.DbPutAction;
import org.asteriskjava.manager.action.EventGeneratingAction;
import org.asteriskjava.manager.action.GetConfigAction;
import org.asteriskjava.manager.action.GetVarAction;
import org.asteriskjava.manager.action.MailboxCountAction;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.action.ModuleCheckAction;
import org.asteriskjava.manager.action.ModuleLoadAction;
import org.asteriskjava.manager.action.OriginateAction;
import org.asteriskjava.manager.action.SetVarAction;
import org.asteriskjava.manager.action.SipPeersAction;
import org.asteriskjava.manager.event.AbstractMeetMeEvent;
import org.asteriskjava.manager.event.AgentCallbackLoginEvent;
import org.asteriskjava.manager.event.AgentCallbackLogoffEvent;
import org.asteriskjava.manager.event.AgentCalledEvent;
import org.asteriskjava.manager.event.AgentCompleteEvent;
import org.asteriskjava.manager.event.AgentConnectEvent;
import org.asteriskjava.manager.event.AgentLoginEvent;
import org.asteriskjava.manager.event.AgentLogoffEvent;
import org.asteriskjava.manager.event.AgentsEvent;
import org.asteriskjava.manager.event.BridgeEvent;
import org.asteriskjava.manager.event.CdrEvent;
import org.asteriskjava.manager.event.ConnectEvent;
import org.asteriskjava.manager.event.DbGetResponseEvent;
import org.asteriskjava.manager.event.DialEvent;
import org.asteriskjava.manager.event.DisconnectEvent;
import org.asteriskjava.manager.event.DtmfEvent;
import org.asteriskjava.manager.event.HangupEvent;
import org.asteriskjava.manager.event.JoinEvent;
import org.asteriskjava.manager.event.LeaveEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.event.MonitorStartEvent;
import org.asteriskjava.manager.event.MonitorStopEvent;
import org.asteriskjava.manager.event.NewCallerIdEvent;
import org.asteriskjava.manager.event.NewChannelEvent;
import org.asteriskjava.manager.event.NewExtenEvent;
import org.asteriskjava.manager.event.NewStateEvent;
import org.asteriskjava.manager.event.OriginateResponseEvent;
import org.asteriskjava.manager.event.ParkedCallEvent;
import org.asteriskjava.manager.event.ParkedCallGiveUpEvent;
import org.asteriskjava.manager.event.ParkedCallTimeOutEvent;
import org.asteriskjava.manager.event.PeerEntryEvent;
import org.asteriskjava.manager.event.QueueMemberAddedEvent;
import org.asteriskjava.manager.event.QueueMemberPausedEvent;
import org.asteriskjava.manager.event.QueueMemberPenaltyEvent;
import org.asteriskjava.manager.event.QueueMemberRemovedEvent;
import org.asteriskjava.manager.event.QueueMemberStatusEvent;
import org.asteriskjava.manager.event.RenameEvent;
import org.asteriskjava.manager.event.ResponseEvent;
import org.asteriskjava.manager.event.UnparkedCallEvent;
import org.asteriskjava.manager.event.VarSetEvent;
import org.asteriskjava.manager.response.CommandResponse;
import org.asteriskjava.manager.response.GetConfigResponse;
import org.asteriskjava.manager.response.MailboxCountResponse;
import org.asteriskjava.manager.response.ManagerError;
import org.asteriskjava.manager.response.ManagerResponse;
import org.asteriskjava.manager.response.ModuleCheckResponse;
import org.asteriskjava.util.AstUtil;
import org.asteriskjava.util.DateUtil;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class AsteriskServerImpl
implements AsteriskServer,
ManagerEventListener {
    private static final String ACTION_ID_PREFIX_ORIGINATE = "AJ_ORIGINATE_";
    private static final String SHOW_VERSION_COMMAND = "show version";
    private static final String SHOW_VERSION_1_6_COMMAND = "core show version";
    private static final String SHOW_VERSION_FILES_COMMAND = "show version files";
    private static final String SHOW_VERSION_FILES_1_6_COMMAND = "core show file version";
    private static final Pattern SHOW_VERSION_FILES_PATTERN = Pattern.compile("^([\\S]+)\\s+Revision: ([0-9\\.]+)");
    private static final String SHOW_VOICEMAIL_USERS_COMMAND = "show voicemail users";
    private static final String SHOW_VOICEMAIL_USERS_1_6_COMMAND = "voicemail show users";
    private static final Pattern SHOW_VOICEMAIL_USERS_PATTERN = Pattern.compile("^(\\S+)\\s+(\\S+)\\s+(.{25})");
    private final Log logger = LogFactory.getLog(this.getClass());
    private ManagerConnection eventConnection;
    private ManagerEventListener eventListener = null;
    private ManagerEventListenerProxy managerEventListenerProxy;
    private boolean initialized = false;
    private boolean initializing = false;
    final Set<AsteriskServerListener> listeners;
    final ChannelManager channelManager;
    final MeetMeManager meetMeManager;
    final QueueManager queueManager;
    final AgentManager agentManager;
    private String version;
    private Map<String, String> versions;
    private final Map<String, OriginateCallbackData> originateCallbacks;
    private final AtomicLong idCounter;
    private boolean skipQueues;
    private boolean asyncEventHandling = true;
    private List<ManagerEventListener> chainListeners = new ArrayList<ManagerEventListener>();

    public AsteriskServerImpl() {
        this.idCounter = new AtomicLong();
        this.listeners = new LinkedHashSet<AsteriskServerListener>();
        this.originateCallbacks = new HashMap<String, OriginateCallbackData>();
        this.channelManager = new ChannelManager(this);
        this.agentManager = new AgentManager(this);
        this.meetMeManager = new MeetMeManager(this, this.channelManager);
        this.queueManager = new QueueManager(this, this.channelManager);
    }

    public AsteriskServerImpl(ManagerConnection eventConnection) {
        this();
        this.setManagerConnection(eventConnection);
    }

    public void setSkipQueues(boolean skipQueues) {
        this.skipQueues = skipQueues;
    }

    public void setManagerConnection(ManagerConnection eventConnection) {
        if (this.eventConnection != null) {
            throw new IllegalStateException("ManagerConnection already set.");
        }
        this.eventConnection = eventConnection;
    }

    @Override
    public ManagerConnection getManagerConnection() {
        return this.eventConnection;
    }

    @Override
    public void initialize() throws ManagerCommunicationException {
        this.initializeIfNeeded();
    }

    private synchronized void initializeIfNeeded() throws ManagerCommunicationException {
        if (this.initialized || this.initializing) {
            return;
        }
        if (this.asyncEventHandling && this.managerEventListenerProxy == null) {
            this.managerEventListenerProxy = new ManagerEventListenerProxy(this);
            this.eventConnection.addEventListener(this.managerEventListenerProxy);
        } else if (!this.asyncEventHandling && this.eventListener == null) {
            this.eventListener = this;
            this.eventConnection.addEventListener(this.eventListener);
        }
        this.initializing = true;
        if (this.eventConnection.getState() == ManagerConnectionState.INITIAL || this.eventConnection.getState() == ManagerConnectionState.DISCONNECTED) {
            try {
                this.eventConnection.login();
            }
            catch (Exception e) {
                throw new ManagerCommunicationException("Unable to login: " + e.getMessage(), e);
            }
        }
        this.channelManager.initialize();
        this.agentManager.initialize();
        this.meetMeManager.initialize();
        if (!this.skipQueues) {
            this.queueManager.initialize();
        }
        if (this.asyncEventHandling && this.managerEventListenerProxy == null) {
            this.managerEventListenerProxy = new ManagerEventListenerProxy(this);
            this.eventConnection.addEventListener(this.managerEventListenerProxy);
        } else if (!this.asyncEventHandling && this.eventListener == null) {
            this.eventListener = this;
            this.eventConnection.addEventListener(this.eventListener);
        }
        this.logger.info("Initializing done");
        this.initializing = false;
        this.initialized = true;
    }

    @Override
    public AsteriskChannel originateToExtension(String channel, String context, String exten, int priority, long timeout) throws ManagerCommunicationException, NoSuchChannelException {
        return this.originateToExtension(channel, context, exten, priority, timeout, null, null);
    }

    @Override
    public AsteriskChannel originateToExtension(String channel, String context, String exten, int priority, long timeout, CallerId callerId, Map<String, String> variables) throws ManagerCommunicationException, NoSuchChannelException {
        OriginateAction originateAction = new OriginateAction();
        originateAction.setChannel(channel);
        originateAction.setContext(context);
        originateAction.setExten(exten);
        originateAction.setPriority(priority);
        originateAction.setTimeout(timeout);
        if (callerId != null) {
            originateAction.setCallerId(callerId.toString());
        }
        originateAction.setVariables(variables);
        return this.originate(originateAction);
    }

    @Override
    public AsteriskChannel originateToApplication(String channel, String application, String data, long timeout) throws ManagerCommunicationException, NoSuchChannelException {
        return this.originateToApplication(channel, application, data, timeout, null, null);
    }

    @Override
    public AsteriskChannel originateToApplication(String channel, String application, String data, long timeout, CallerId callerId, Map<String, String> variables) throws ManagerCommunicationException, NoSuchChannelException {
        OriginateAction originateAction = new OriginateAction();
        originateAction.setChannel(channel);
        originateAction.setApplication(application);
        originateAction.setData(data);
        originateAction.setTimeout(timeout);
        if (callerId != null) {
            originateAction.setCallerId(callerId.toString());
        }
        originateAction.setVariables(variables);
        return this.originate(originateAction);
    }

    @Override
    public AsteriskChannel originate(OriginateAction originateAction) throws ManagerCommunicationException, NoSuchChannelException {
        ResponseEvent responseEvent;
        AsteriskChannel channel = null;
        originateAction.setAsync(Boolean.TRUE);
        this.initializeIfNeeded();
        ResponseEvents responseEvents = this.sendEventGeneratingAction(originateAction, originateAction.getTimeout() + 2000L);
        Iterator<ResponseEvent> responseEventIterator = responseEvents.getEvents().iterator();
        if (responseEventIterator.hasNext() && (responseEvent = responseEventIterator.next()) instanceof OriginateResponseEvent) {
            String uniqueId = ((OriginateResponseEvent)responseEvent).getUniqueId();
            this.logger.debug(responseEvent.getClass().getName() + " received with uniqueId " + uniqueId);
            channel = this.getChannelById(uniqueId);
        }
        if (channel == null) {
            throw new NoSuchChannelException("Channel '" + originateAction.getChannel() + "' is not available");
        }
        return channel;
    }

    @Override
    public void originateToExtensionAsync(String channel, String context, String exten, int priority, long timeout, OriginateCallback cb) throws ManagerCommunicationException {
        this.originateToExtensionAsync(channel, context, exten, priority, timeout, null, null, cb);
    }

    @Override
    public void originateToExtensionAsync(String channel, String context, String exten, int priority, long timeout, CallerId callerId, Map<String, String> variables, OriginateCallback cb) throws ManagerCommunicationException {
        OriginateAction originateAction = new OriginateAction();
        originateAction.setChannel(channel);
        originateAction.setContext(context);
        originateAction.setExten(exten);
        originateAction.setPriority(priority);
        originateAction.setTimeout(timeout);
        if (callerId != null) {
            originateAction.setCallerId(callerId.toString());
        }
        originateAction.setVariables(variables);
        this.originateAsync(originateAction, cb);
    }

    @Override
    public void originateToApplicationAsync(String channel, String application, String data, long timeout, OriginateCallback cb) throws ManagerCommunicationException {
        this.originateToApplicationAsync(channel, application, data, timeout, null, null, cb);
    }

    @Override
    public void originateToApplicationAsync(String channel, String application, String data, long timeout, CallerId callerId, Map<String, String> variables, OriginateCallback cb) throws ManagerCommunicationException {
        OriginateAction originateAction = new OriginateAction();
        originateAction.setChannel(channel);
        originateAction.setApplication(application);
        originateAction.setData(data);
        originateAction.setTimeout(timeout);
        if (callerId != null) {
            originateAction.setCallerId(callerId.toString());
        }
        originateAction.setVariables(variables);
        this.originateAsync(originateAction, cb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void originateAsync(OriginateAction originateAction, OriginateCallback cb) throws ManagerCommunicationException {
        String traceId = ACTION_ID_PREFIX_ORIGINATE + this.idCounter.getAndIncrement();
        HashMap<String, String> variables = originateAction.getVariables() == null ? new HashMap<String, String>() : new HashMap<String, String>(originateAction.getVariables());
        variables.put("__AJ_TRACE_ID", traceId);
        originateAction.setVariables(variables);
        originateAction.setAsync(Boolean.TRUE);
        originateAction.setActionId(traceId);
        if (cb != null) {
            OriginateCallbackData callbackData = new OriginateCallbackData(originateAction, DateUtil.getDate(), cb);
            Map<String, OriginateCallbackData> map = this.originateCallbacks;
            synchronized (map) {
                this.originateCallbacks.put(traceId, callbackData);
            }
        }
        this.initializeIfNeeded();
        this.sendActionOnEventConnection(originateAction);
    }

    @Override
    public Collection<AsteriskChannel> getChannels() throws ManagerCommunicationException {
        this.initializeIfNeeded();
        return this.channelManager.getChannels();
    }

    @Override
    public AsteriskChannel getChannelByName(String name) throws ManagerCommunicationException {
        this.initializeIfNeeded();
        return this.channelManager.getChannelImplByName(name);
    }

    @Override
    public AsteriskChannel getChannelById(String id) throws ManagerCommunicationException {
        this.initializeIfNeeded();
        return this.channelManager.getChannelImplById(id);
    }

    @Override
    public Collection<MeetMeRoom> getMeetMeRooms() throws ManagerCommunicationException {
        this.initializeIfNeeded();
        return this.meetMeManager.getMeetMeRooms();
    }

    @Override
    public MeetMeRoom getMeetMeRoom(String name) throws ManagerCommunicationException {
        this.initializeIfNeeded();
        return this.meetMeManager.getOrCreateRoomImpl(name);
    }

    @Override
    public Collection<AsteriskQueue> getQueues() throws ManagerCommunicationException {
        this.initializeIfNeeded();
        return this.queueManager.getQueues();
    }

    @Override
    public AsteriskQueue getQueueByName(String queueName) {
        this.initializeIfNeeded();
        return this.queueManager.getQueueByName(queueName);
    }

    @Override
    public List<AsteriskQueue> getQueuesUpdatedAfter(Date date) {
        this.initializeIfNeeded();
        return this.queueManager.getQueuesUpdatedAfter(date);
    }

    @Override
    public synchronized String getVersion() throws ManagerCommunicationException {
        this.initializeIfNeeded();
        if (this.version == null) {
            String command = this.eventConnection.getVersion().isAtLeast(AsteriskVersion.ASTERISK_1_6) ? SHOW_VERSION_1_6_COMMAND : SHOW_VERSION_COMMAND;
            ManagerResponse response = this.sendAction(new CommandAction(command));
            if (response instanceof CommandResponse) {
                List<String> result = ((CommandResponse)response).getResult();
                if (!result.isEmpty()) {
                    this.version = result.get(0);
                }
            } else {
                this.logger.error("Response to CommandAction(\"" + command + "\") was not a CommandResponse but " + response);
            }
        }
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getVersion(String file) throws ManagerCommunicationException {
        String fileVersion;
        block13: {
            Map<Object, Object> map;
            fileVersion = null;
            this.initializeIfNeeded();
            if (this.versions == null) {
                map = new HashMap();
                try {
                    String command = this.eventConnection.getVersion().isAtLeast(AsteriskVersion.ASTERISK_1_6) ? SHOW_VERSION_FILES_1_6_COMMAND : SHOW_VERSION_FILES_COMMAND;
                    ManagerResponse response = this.sendAction(new CommandAction(command));
                    if (response instanceof CommandResponse) {
                        List<String> result = ((CommandResponse)response).getResult();
                        for (int i = 2; i < result.size(); ++i) {
                            String line = result.get(i);
                            Matcher matcher = SHOW_VERSION_FILES_PATTERN.matcher(line);
                            if (!matcher.find()) continue;
                            String key = matcher.group(1);
                            String value = matcher.group(2);
                            map.put(key, value);
                        }
                        fileVersion = (String)map.get(file);
                        this.versions = map;
                        break block13;
                    }
                    this.logger.error("Response to CommandAction(\"" + command + "\") was not a CommandResponse but " + response);
                }
                catch (Exception e) {
                    this.logger.warn("Unable to send 'show version files' command.", e);
                }
            } else {
                map = this.versions;
                synchronized (map) {
                    fileVersion = this.versions.get(file);
                }
            }
        }
        if (fileVersion == null) {
            return null;
        }
        String[] parts = fileVersion.split("\\.");
        int[] intParts = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            try {
                intParts[i] = Integer.parseInt(parts[i]);
                continue;
            }
            catch (NumberFormatException e) {
                intParts[i] = 0;
            }
        }
        return intParts;
    }

    @Override
    public String getGlobalVariable(String variable) throws ManagerCommunicationException {
        this.initializeIfNeeded();
        ManagerResponse response = this.sendAction(new GetVarAction(variable));
        if (response instanceof ManagerError) {
            return null;
        }
        String value = response.getAttribute("Value");
        if (value == null) {
            value = response.getAttribute(variable);
        }
        return value;
    }

    @Override
    public void setGlobalVariable(String variable, String value) throws ManagerCommunicationException {
        this.initializeIfNeeded();
        ManagerResponse response = this.sendAction(new SetVarAction(variable, value));
        if (response instanceof ManagerError) {
            this.logger.error("Unable to set global variable '" + variable + "' to '" + value + "':" + response.getMessage());
        }
    }

    @Override
    public Collection<Voicemailbox> getVoicemailboxes() throws ManagerCommunicationException {
        this.initializeIfNeeded();
        ArrayList<Voicemailbox> voicemailboxes = new ArrayList<Voicemailbox>();
        ManagerResponse response = this.eventConnection.getVersion().isAtLeast(AsteriskVersion.ASTERISK_1_6) ? this.sendAction(new CommandAction(SHOW_VOICEMAIL_USERS_1_6_COMMAND)) : this.sendAction(new CommandAction(SHOW_VOICEMAIL_USERS_COMMAND));
        if (!(response instanceof CommandResponse)) {
            this.logger.error("Response to CommandAction(\"show voicemail users\") was not a CommandResponse but " + response);
            return voicemailboxes;
        }
        List<String> result = ((CommandResponse)response).getResult();
        if (result == null || result.isEmpty()) {
            return voicemailboxes;
        }
        result.remove(0);
        for (String line : result) {
            Matcher matcher = SHOW_VOICEMAIL_USERS_PATTERN.matcher(line);
            if (!matcher.find()) continue;
            String context = matcher.group(1);
            String mailbox = matcher.group(2);
            String user = matcher.group(3).trim();
            Voicemailbox voicemailbox = new Voicemailbox(mailbox, context, user);
            voicemailboxes.add(voicemailbox);
        }
        for (Voicemailbox voicemailbox : voicemailboxes) {
            String fullname = voicemailbox.getMailbox() + "@" + voicemailbox.getContext();
            response = this.sendAction(new MailboxCountAction(fullname));
            if (response instanceof MailboxCountResponse) {
                MailboxCountResponse mailboxCountResponse = (MailboxCountResponse)response;
                voicemailbox.setNewMessages(mailboxCountResponse.getNewMessages());
                voicemailbox.setOldMessages(mailboxCountResponse.getOldMessages());
                continue;
            }
            this.logger.error("Response to MailboxCountAction was not a MailboxCountResponse but " + response);
        }
        return voicemailboxes;
    }

    @Override
    public List<String> executeCliCommand(String command) throws ManagerCommunicationException {
        this.initializeIfNeeded();
        ManagerResponse response = this.sendAction(new CommandAction(command));
        if (!(response instanceof CommandResponse)) {
            throw new ManagerCommunicationException("Response to CommandAction(\"" + command + "\") was not a CommandResponse but " + response, null);
        }
        return ((CommandResponse)response).getResult();
    }

    @Override
    public boolean isModuleLoaded(String module) throws ManagerCommunicationException {
        return this.sendAction(new ModuleCheckAction(module)) instanceof ModuleCheckResponse;
    }

    @Override
    public void loadModule(String module) throws ManagerCommunicationException {
        this.sendModuleLoadAction(module, "load");
    }

    @Override
    public void unloadModule(String module) throws ManagerCommunicationException {
        this.sendModuleLoadAction(module, "unload");
    }

    @Override
    public void reloadModule(String module) throws ManagerCommunicationException {
        this.sendModuleLoadAction(module, "reload");
    }

    @Override
    public void reloadAllModules() throws ManagerCommunicationException {
        this.sendModuleLoadAction(null, "reload");
    }

    protected void sendModuleLoadAction(String module, String loadType) throws ManagerCommunicationException {
        ManagerResponse response = this.sendAction(new ModuleLoadAction(module, loadType));
        if (response instanceof ManagerError) {
            ManagerError error = (ManagerError)response;
            throw new ManagerCommunicationException(error.getMessage(), null);
        }
    }

    @Override
    public ConfigFile getConfig(String filename) throws ManagerCommunicationException {
        this.initializeIfNeeded();
        ManagerResponse response = this.sendAction(new GetConfigAction(filename));
        if (!(response instanceof GetConfigResponse)) {
            throw new ManagerCommunicationException("Response to GetConfigAction(\"" + filename + "\") was not a CommandResponse but " + response, null);
        }
        GetConfigResponse getConfigResponse = (GetConfigResponse)response;
        Map<Integer, String> categoryMap = getConfigResponse.getCategories();
        LinkedHashMap<String, List<String>> categories = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<Integer, String> categoryEntry : categoryMap.entrySet()) {
            Map<Integer, String> lineMap = getConfigResponse.getLines(categoryEntry.getKey());
            ArrayList<Object> lines = lineMap == null ? new ArrayList() : new ArrayList<String>(lineMap.values());
            categories.put(categoryEntry.getValue(), lines);
        }
        return new ConfigFileImpl(filename, categories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAsteriskServerListener(AsteriskServerListener listener) throws ManagerCommunicationException {
        this.initializeIfNeeded();
        Set<AsteriskServerListener> set = this.listeners;
        synchronized (set) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAsteriskServerListener(AsteriskServerListener listener) {
        Set<AsteriskServerListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public boolean isAsteriskServerListening(AsteriskServerListener listener) {
        return this.listeners.contains(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChainListener(ManagerEventListener chainListener) {
        List<ManagerEventListener> list = this.chainListeners;
        synchronized (list) {
            if (!this.chainListeners.contains(chainListener)) {
                this.chainListeners.add(chainListener);
            }
        }
    }

    @Override
    public void removeChainListener(ManagerEventListener chainListener) {
        this.chainListeners.remove(chainListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireNewAsteriskChannel(AsteriskChannel channel) {
        Set<AsteriskServerListener> set = this.listeners;
        synchronized (set) {
            for (AsteriskServerListener listener : this.listeners) {
                try {
                    listener.onNewAsteriskChannel(channel);
                }
                catch (Exception e) {
                    this.logger.warn("Exception in onNewAsteriskChannel()", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireNewMeetMeUser(MeetMeUser user) {
        Set<AsteriskServerListener> set = this.listeners;
        synchronized (set) {
            for (AsteriskServerListener listener : this.listeners) {
                try {
                    listener.onNewMeetMeUser(user);
                }
                catch (Exception e) {
                    this.logger.warn("Exception in onNewMeetMeUser()", e);
                }
            }
        }
    }

    ManagerResponse sendActionOnEventConnection(ManagerAction action) throws ManagerCommunicationException {
        try {
            return this.eventConnection.sendAction(action);
        }
        catch (Exception e) {
            throw ManagerCommunicationExceptionMapper.mapSendActionException(action.getAction(), e);
        }
    }

    ManagerResponse sendAction(ManagerAction action) throws ManagerCommunicationException {
        try {
            return this.eventConnection.sendAction(action);
        }
        catch (Exception e) {
            throw ManagerCommunicationExceptionMapper.mapSendActionException(action.getAction(), e);
        }
    }

    ResponseEvents sendEventGeneratingAction(EventGeneratingAction action) throws ManagerCommunicationException {
        try {
            return this.eventConnection.sendEventGeneratingAction(action);
        }
        catch (Exception e) {
            throw ManagerCommunicationExceptionMapper.mapSendActionException(action.getAction(), e);
        }
    }

    ResponseEvents sendEventGeneratingAction(EventGeneratingAction action, long timeout) throws ManagerCommunicationException {
        try {
            return this.eventConnection.sendEventGeneratingAction(action, timeout);
        }
        catch (Exception e) {
            throw ManagerCommunicationExceptionMapper.mapSendActionException(action.getAction(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OriginateCallbackData getOriginateCallbackDataByTraceId(String traceId) {
        Map<String, OriginateCallbackData> map = this.originateCallbacks;
        synchronized (map) {
            return this.originateCallbacks.get(traceId);
        }
    }

    @Override
    public void onManagerEvent(ManagerEvent event) {
        if (event instanceof ConnectEvent) {
            this.handleConnectEvent((ConnectEvent)event);
        } else if (event instanceof DisconnectEvent) {
            this.handleDisconnectEvent((DisconnectEvent)event);
        } else if (event instanceof NewChannelEvent) {
            this.channelManager.handleNewChannelEvent((NewChannelEvent)event);
        } else if (event instanceof NewExtenEvent) {
            this.channelManager.handleNewExtenEvent((NewExtenEvent)event);
        } else if (event instanceof NewStateEvent) {
            this.channelManager.handleNewStateEvent((NewStateEvent)event);
        } else if (event instanceof NewCallerIdEvent) {
            this.channelManager.handleNewCallerIdEvent((NewCallerIdEvent)event);
        } else if (event instanceof DialEvent) {
            this.channelManager.handleDialEvent((DialEvent)event);
        } else if (event instanceof BridgeEvent) {
            this.channelManager.handleBridgeEvent((BridgeEvent)event);
        } else if (event instanceof RenameEvent) {
            this.channelManager.handleRenameEvent((RenameEvent)event);
        } else if (event instanceof HangupEvent) {
            this.channelManager.handleHangupEvent((HangupEvent)event);
        } else if (event instanceof CdrEvent) {
            this.channelManager.handleCdrEvent((CdrEvent)event);
        } else if (event instanceof VarSetEvent) {
            this.channelManager.handleVarSetEvent((VarSetEvent)event);
        } else if (event instanceof DtmfEvent) {
            this.channelManager.handleDtmfEvent((DtmfEvent)event);
        } else if (event instanceof MonitorStartEvent) {
            this.channelManager.handleMonitorStartEvent((MonitorStartEvent)event);
        } else if (event instanceof MonitorStopEvent) {
            this.channelManager.handleMonitorStopEvent((MonitorStopEvent)event);
        } else if (event instanceof ParkedCallEvent) {
            this.channelManager.handleParkedCallEvent((ParkedCallEvent)event);
        } else if (event instanceof ParkedCallGiveUpEvent) {
            this.channelManager.handleParkedCallGiveUpEvent((ParkedCallGiveUpEvent)event);
        } else if (event instanceof ParkedCallTimeOutEvent) {
            this.channelManager.handleParkedCallTimeOutEvent((ParkedCallTimeOutEvent)event);
        } else if (event instanceof UnparkedCallEvent) {
            this.channelManager.handleUnparkedCallEvent((UnparkedCallEvent)event);
        } else if (event instanceof JoinEvent) {
            this.queueManager.handleJoinEvent((JoinEvent)event);
        } else if (event instanceof LeaveEvent) {
            this.queueManager.handleLeaveEvent((LeaveEvent)event);
        } else if (event instanceof QueueMemberStatusEvent) {
            this.queueManager.handleQueueMemberStatusEvent((QueueMemberStatusEvent)event);
        } else if (event instanceof QueueMemberPenaltyEvent) {
            this.queueManager.handleQueueMemberPenaltyEvent((QueueMemberPenaltyEvent)event);
        } else if (event instanceof QueueMemberAddedEvent) {
            this.queueManager.handleQueueMemberAddedEvent((QueueMemberAddedEvent)event);
        } else if (event instanceof QueueMemberRemovedEvent) {
            this.queueManager.handleQueueMemberRemovedEvent((QueueMemberRemovedEvent)event);
        } else if (event instanceof QueueMemberPausedEvent) {
            this.queueManager.handleQueueMemberPausedEvent((QueueMemberPausedEvent)event);
        } else if (event instanceof AbstractMeetMeEvent) {
            this.meetMeManager.handleMeetMeEvent((AbstractMeetMeEvent)event);
        } else if (event instanceof OriginateResponseEvent) {
            this.handleOriginateEvent((OriginateResponseEvent)event);
        } else if (event instanceof AgentsEvent) {
            this.agentManager.handleAgentsEvent((AgentsEvent)event);
        } else if (event instanceof AgentCalledEvent) {
            this.agentManager.handleAgentCalledEvent((AgentCalledEvent)event);
        } else if (event instanceof AgentConnectEvent) {
            this.agentManager.handleAgentConnectEvent((AgentConnectEvent)event);
        } else if (event instanceof AgentCompleteEvent) {
            this.agentManager.handleAgentCompleteEvent((AgentCompleteEvent)event);
        } else if (event instanceof AgentCallbackLoginEvent) {
            this.agentManager.handleAgentCallbackLoginEvent((AgentCallbackLoginEvent)event);
        } else if (event instanceof AgentCallbackLogoffEvent) {
            this.agentManager.handleAgentCallbackLogoffEvent((AgentCallbackLogoffEvent)event);
        } else if (event instanceof AgentLoginEvent) {
            this.agentManager.handleAgentLoginEvent((AgentLoginEvent)event);
        } else if (event instanceof AgentLogoffEvent) {
            this.agentManager.handleAgentLogoffEvent((AgentLogoffEvent)event);
        }
        this.fireChainListeners(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChainListeners(ManagerEvent event) {
        List<ManagerEventListener> list = this.chainListeners;
        synchronized (list) {
            for (ManagerEventListener listener : this.chainListeners) {
                listener.onManagerEvent(event);
            }
        }
    }

    private void handleDisconnectEvent(DisconnectEvent disconnectEvent) {
        this.version = null;
        this.versions = null;
        this.channelManager.disconnected();
        this.agentManager.disconnected();
        this.meetMeManager.disconnected();
        this.queueManager.disconnected();
        this.initialized = false;
        this.initializing = false;
    }

    private void handleConnectEvent(ConnectEvent connectEvent) {
        try {
            this.initialize();
            this.channelManager.initialize();
            this.agentManager.initialize();
            this.meetMeManager.initialize();
            if (!this.skipQueues) {
                this.queueManager.initialize();
            }
            this.logger.info("Initializing done");
            this.initialized = true;
            this.initializing = false;
        }
        catch (Exception e) {
            this.logger.error("Unable to reinitialize state after reconnection", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOriginateEvent(OriginateResponseEvent originateEvent) {
        OriginateCallbackData callbackData;
        String traceId = originateEvent.getActionId();
        if (traceId == null) {
            return;
        }
        Map<String, OriginateCallbackData> map = this.originateCallbacks;
        synchronized (map) {
            callbackData = this.originateCallbacks.get(traceId);
            if (callbackData == null) {
                return;
            }
            this.originateCallbacks.remove(traceId);
        }
        OriginateCallback cb = callbackData.getCallback();
        AsteriskChannelImpl channel = !AstUtil.isNull(originateEvent.getUniqueId()) ? this.channelManager.getChannelImplById(originateEvent.getUniqueId()) : callbackData.getChannel();
        try {
            if (channel == null) {
                NoSuchChannelException cause = new NoSuchChannelException("Channel '" + callbackData.getOriginateAction().getChannel() + "' is not available");
                cb.onFailure(cause);
                return;
            }
            if (channel.wasInState(ChannelState.UP)) {
                cb.onSuccess(channel);
                return;
            }
            if (channel.wasBusy()) {
                cb.onBusy(channel);
                return;
            }
            AsteriskChannelImpl otherChannel = this.channelManager.getOtherSideOfLocalChannel(channel);
            if (otherChannel != null) {
                AsteriskChannel dialedChannel = otherChannel.getDialedChannel();
                if (otherChannel.wasBusy()) {
                    cb.onBusy(channel);
                    return;
                }
                if (dialedChannel != null && dialedChannel.wasBusy()) {
                    cb.onBusy(channel);
                    return;
                }
            }
            cb.onNoAnswer(channel);
        }
        catch (Throwable t) {
            this.logger.warn("Exception dispatching originate progress", t);
        }
    }

    @Override
    public void shutdown() {
        if (this.eventConnection != null && (this.eventConnection.getState() == ManagerConnectionState.CONNECTED || this.eventConnection.getState() == ManagerConnectionState.RECONNECTING)) {
            try {
                this.eventConnection.logoff();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.managerEventListenerProxy != null) {
            if (this.eventConnection != null) {
                this.eventConnection.removeEventListener(this.managerEventListenerProxy);
            }
            this.managerEventListenerProxy.shutdown();
        }
        if (this.eventConnection != null && this.eventListener != null) {
            this.eventConnection.removeEventListener(this.eventListener);
        }
        this.managerEventListenerProxy = null;
        this.eventListener = null;
        if (this.initialized) {
            this.handleDisconnectEvent(null);
        }
    }

    public List<PeerEntryEvent> getPeerEntries() throws ManagerCommunicationException {
        ResponseEvents responseEvents = this.sendEventGeneratingAction(new SipPeersAction(), 2000L);
        ArrayList<PeerEntryEvent> peerEntries = new ArrayList<PeerEntryEvent>(30);
        for (ResponseEvent re : responseEvents.getEvents()) {
            if (!(re instanceof PeerEntryEvent)) continue;
            peerEntries.add((PeerEntryEvent)re);
        }
        return peerEntries;
    }

    public DbGetResponseEvent dbGet(String family, String key) throws ManagerCommunicationException {
        ResponseEvents responseEvents = this.sendEventGeneratingAction(new DbGetAction(family, key), 2000L);
        DbGetResponseEvent dbgre = null;
        for (ResponseEvent re : responseEvents.getEvents()) {
            dbgre = (DbGetResponseEvent)re;
        }
        return dbgre;
    }

    public void dbDel(String family, String key) throws ManagerCommunicationException {
        this.sendAction(new CommandAction("database del " + family + " " + key));
    }

    public void dbPut(String family, String key, String value) throws ManagerCommunicationException {
        this.sendAction(new DbPutAction(family, key, value));
    }

    public AsteriskChannel getChannelByNameAndActive(String name) throws ManagerCommunicationException {
        this.initializeIfNeeded();
        return this.channelManager.getChannelImplByNameAndActive(name);
    }

    @Override
    public Collection<AsteriskAgent> getAgents() throws ManagerCommunicationException {
        this.initializeIfNeeded();
        return this.agentManager.getAgents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireNewAgent(AsteriskAgentImpl agent) {
        Set<AsteriskServerListener> set = this.listeners;
        synchronized (set) {
            for (AsteriskServerListener listener : this.listeners) {
                try {
                    listener.onNewAgent(agent);
                }
                catch (Exception e) {
                    this.logger.warn("Exception in onNewAgent()", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireNewQueueEntry(AsteriskQueueEntry entry) {
        Set<AsteriskServerListener> set = this.listeners;
        synchronized (set) {
            for (AsteriskServerListener listener : this.listeners) {
                try {
                    listener.onNewQueueEntry(entry);
                }
                catch (Exception e) {
                    this.logger.warn("Exception in onNewQueueEntry()", e);
                }
            }
        }
    }

    @Override
    public void forceQueuesMonitor(boolean force) {
        this.queueManager.forceQueuesMonitor(force);
    }

    @Override
    public boolean isQueuesMonitorForced() {
        return this.queueManager.isQueuesMonitorForced();
    }
}

