/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal.backwardsCompatibility.bridge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.asteriskjava.manager.event.BridgeEnterEvent;
import org.asteriskjava.manager.event.BridgeEvent;
import org.asteriskjava.manager.event.BridgeLeaveEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.internal.backwardsCompatibility.bridge.BridgeEnterEventComparator;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

class BridgeState {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final BridgeEnterEventComparator BRIDGE_ENTER_EVENT_COMPARATOR = new BridgeEnterEventComparator();
    private static final String HOLDING_BRIDGE_TECH = "holding_bridge";
    private final Map<String, BridgeEnterEvent> members = new HashMap<String, BridgeEnterEvent>();

    BridgeState() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ManagerEvent destroy() {
        Map<String, BridgeEnterEvent> map = this.members;
        synchronized (map) {
            this.members.clear();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ManagerEvent addMember(BridgeEnterEvent event) {
        ArrayList<BridgeEnterEvent> remaining = null;
        if (HOLDING_BRIDGE_TECH.equals(event.getBridgeTechnology())) {
            return null;
        }
        Map<String, BridgeEnterEvent> map = this.members;
        synchronized (map) {
            if (this.members.put(event.getChannel(), event) == null && this.members.size() == 2) {
                remaining = new ArrayList<BridgeEnterEvent>(this.members.values());
            }
        }
        if (remaining == null) {
            return null;
        }
        this.logger.info("Members size " + remaining.size() + " " + event);
        BridgeEvent bridgeEvent = this.buildBridgeEvent("Link", remaining);
        this.logger.info("Bridge " + bridgeEvent.getChannel1() + " " + bridgeEvent.getChannel2());
        return bridgeEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ManagerEvent removeMember(BridgeLeaveEvent event) {
        LinkedList<BridgeEnterEvent> remaining = new LinkedList<BridgeEnterEvent>();
        if (HOLDING_BRIDGE_TECH.equals(event.getBridgeTechnology())) {
            return null;
        }
        Map<String, BridgeEnterEvent> map = this.members;
        synchronized (map) {
            remaining.addAll(this.members.values());
            if (this.members.remove(event.getChannel()) != null && remaining.size() == 2) {
                return this.buildBridgeEvent("Unlink", remaining);
            }
        }
        return null;
    }

    private BridgeEvent buildBridgeEvent(String bridgeState, List<BridgeEnterEvent> members) {
        Collections.sort(members, BRIDGE_ENTER_EVENT_COMPARATOR);
        BridgeEvent bridgeEvent = new BridgeEvent(this);
        bridgeEvent.setCallerId1(members.get(0).getCallerIdNum());
        bridgeEvent.setUniqueId1(members.get(0).getUniqueId());
        bridgeEvent.setChannel1(members.get(0).getChannel());
        bridgeEvent.setCallerId2(members.get(1).getCallerIdNum());
        bridgeEvent.setUniqueId2(members.get(1).getUniqueId());
        bridgeEvent.setChannel2(members.get(1).getChannel());
        bridgeEvent.setBridgeState(bridgeState);
        bridgeEvent.setDateReceived(new Date());
        return bridgeEvent;
    }
}

